/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "type_1.h"
#include "type_2.h"
#include "type_3.h"
#include "type_4.h"

#define DEFINE_ONE_TYPE(TT, SZ1) \
template <> const char* one_value < TT > :: exists_ = SZ1;

#define DEFINE_TWO_TYPE(TT, ENUM, SZ1, SZ2) \
template <> const char* two_value < TT, ENUM > :: v1_ = SZ1; \
template <> const char* two_value < TT, ENUM > :: v2_ = SZ2;

#define DEFINE_THREE_TYPE(TT, ENUM, SZ1, SZ2, SZ3) \
template <> const char* three_value < TT, ENUM > :: v1_ = SZ1; \
template <> const char* three_value < TT, ENUM > :: v2_ = SZ2; \
template <> const char* three_value < TT, ENUM > :: v3_ = SZ3;

#define DEFINE_FOUR_TYPE(TT, ENUM, SZ1, SZ2, SZ3, SZ4) \
template <> const char* four_value < TT, ENUM > :: v1_ = SZ1; \
template <> const char* four_value < TT, ENUM > :: v2_ = SZ2; \
template <> const char* four_value < TT, ENUM > :: v3_ = SZ3; \
template <> const char* four_value < TT, ENUM > :: v4_ = SZ4;

DEFINE_ONE_TYPE (t_1, "1")
DEFINE_ONE_TYPE (t_boolean, "true")
DEFINE_ONE_TYPE (t_charset, "utf-8")

DEFINE_TWO_TYPE (t_capture, ev_capture, "user", "environment")
DEFINE_TWO_TYPE (t_cors, ev_cors, "anonymous", "use-credentials")
DEFINE_TWO_TYPE (t_truefalse, e_bool, "true", "false")
DEFINE_TWO_TYPE (t_wrap, e_wrap, "soft", "hard")
DEFINE_TWO_TYPE (t_yesno, e_yesno, "yes", "no")

DEFINE_THREE_TYPE (t_decoding, e_decoding, "auto", "sync", "async");
DEFINE_THREE_TYPE (t_dir, ed_dir, "auto", "ltr", "rtl");
DEFINE_THREE_TYPE (t_enctype, e_enctype, "application/x-www-form-urlencoded", "multipart/form-data", "text/plain")
DEFINE_THREE_TYPE (t_method, e_method, "get", "post", "dialog")

DEFINE_FOUR_TYPE (t_autocapitalise, e_autocapitalise, "sentences", "words", "characters", "none")
DEFINE_FOUR_TYPE (t_rsvp, e_rsvp, "yes", "no", "maybe", "interested")
DEFINE_FOUR_TYPE (t_scope, e_scope, "row", "col", "rowgroup", "colgroup")
DEFINE_FOUR_TYPE (t_shape, e_shape, "circle", "default", "poly", "rect")
