/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "type_master.h"

template < e_type TYPE, typename tv_value > class three_value : public type_base < TYPE >
{   tv_value value_;
    static const char* v1_;
    static const char* v2_;
    static const char* v3_;
public:
    static void init (const char* sz1, const char* sz2, const char* sz3)
    {   v1_ = sz1; v2_ = sz2; v3_ = sz3; }
    ::std::string get_value () const;
    void set_value (const ::std::string& s);
    void swap (three_value& t) noexcept { ::std::swap (value_, t.value_); type_base < TYPE >::swap (t); }
    ::std::string diagnose () const; };

#define DECLARE_THREE_TYPE(TT, ENUM, V1, V2, V3) \
typedef enum { V1, V2, V3 } ENUM; \
template < > struct type_master < TT > : public three_value < TT, ENUM > { }; \
template < > const char* three_value < TT, ENUM > :: v1_; \
template < > const char* three_value < TT, ENUM > :: v2_; \
template < > const char* three_value < TT, ENUM > :: v3_;

DECLARE_THREE_TYPE (t_decoding, e_decoding, ed_auto, ed_sync, ed_async);
DECLARE_THREE_TYPE (t_dir, ed_dir, eid_auto, edi_ltr, edi_rtl);
DECLARE_THREE_TYPE (t_enctype, e_enctype, ee_www, e_multi, ee_text)
DECLARE_THREE_TYPE (t_method, e_method, md_www, md_multi, md_text)

template < e_type TYPE, typename base_type > ::std::string three_value < TYPE, base_type > :: get_value () const
{   if (! type_base < TYPE > :: unknown ())
        if (value_ == static_cast <base_type> (0)) return v1_;
        else if (value_ == static_cast <base_type> (1)) return v2_;
        else if (value_ == static_cast <base_type> (2)) return v3_;
    return ::std::string (); }

template < e_type TYPE, typename base_type > void three_value < TYPE, base_type > :: set_value (const ::std::string& s)
{   ::std::string t = (::boost::algorithm::to_lower_copy (trim_the_lot_off (s)));
    type_base < TYPE > :: status (s_good);
    if (t == v1_) value_ = static_cast <base_type> (0);
    else if (t == v2_) value_ = static_cast <base_type> (1);
    else if (t == v3_) value_ = static_cast <base_type> (2);
    else type_base < TYPE > :: status (s_invalid); }

template < e_type TYPE, typename base_type > ::std::string three_value < TYPE, base_type > :: diagnose () const
{   if (! type_base < TYPE > :: invalid ()) return ::std::string ();
    if (! context.tell (e_error)) return ::std::string ();
    ::std::string s ("should be one of ");
    s += v1_;
    s += ", ";
    s += v2_;
    s += ", or ";
    s += v3_;
    return s; }
