/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "type_master.h"

void types_init ();

typedef enum {  e_iso_unknown,
                e_iso_AED, e_iso_AFN, e_iso_ALL, e_iso_AMD, e_iso_ANG, e_iso_AOA, e_iso_ARS, e_iso_AUD, e_iso_AWG, e_iso_AZN, e_iso_BAM,
                e_iso_BBD, e_iso_BDT, e_iso_BGN, e_iso_BHD, e_iso_BIF, e_iso_BMD, e_iso_BND, e_iso_BOB, e_iso_BOV, e_iso_BRL, e_iso_BSD,
                e_iso_BTN, e_iso_BWP, e_iso_BYN, e_iso_BZD, e_iso_CAD, e_iso_CDF, e_iso_CHE, e_iso_CHF, e_iso_CHW, e_iso_CLF, e_iso_CLP,
                e_iso_CNY, e_iso_COP, e_iso_COU, e_iso_CRC, e_iso_CUC, e_iso_CUP, e_iso_CVE, e_iso_CZK, e_iso_DJF, e_iso_DKK, e_iso_DOP,
                e_iso_DZD, e_iso_EGP, e_iso_ERN, e_iso_ETB, e_iso_EUR, e_iso_FJD, e_iso_FKP, e_iso_GBP, e_iso_GEL, e_iso_GHS, e_iso_GIP,
                e_iso_GMD, e_iso_GNF, e_iso_GTQ, e_iso_GYD, e_iso_HKD, e_iso_HNL, e_iso_HRK, e_iso_HTG, e_iso_HUF, e_iso_IDR, e_iso_ILS,
                e_iso_INR, e_iso_IQD, e_iso_IRR, e_iso_ISK, e_iso_JMD, e_iso_JOD, e_iso_JPY, e_iso_KES, e_iso_KGS, e_iso_KHR, e_iso_KMF,
                e_iso_KPW, e_iso_KRW, e_iso_KWD, e_iso_KYD, e_iso_KZT, e_iso_LAK, e_iso_LBP, e_iso_LKR, e_iso_LRD, e_iso_LSL, e_iso_LYD,
                e_iso_MAD, e_iso_MDL, e_iso_MGA, e_iso_MKD, e_iso_MMK, e_iso_MNT, e_iso_MOP, e_iso_MRU, e_iso_MUR, e_iso_MVR, e_iso_MWK,
                e_iso_MXN, e_iso_MXV, e_iso_MYR, e_iso_MZN, e_iso_NAD, e_iso_NGN, e_iso_NIO, e_iso_NOK, e_iso_NPR, e_iso_NZD, e_iso_OMR,
                e_iso_PAB, e_iso_PEN, e_iso_PGK, e_iso_PHP, e_iso_PKR, e_iso_PLN, e_iso_PYG, e_iso_QAR, e_iso_RON, e_iso_RSD, e_iso_RUB,
                e_iso_RWF, e_iso_SAR, e_iso_SBD, e_iso_SCR, e_iso_SDG, e_iso_SEK, e_iso_SGD, e_iso_SHP, e_iso_SLL, e_iso_SOS, e_iso_SRD,
                e_iso_SSP, e_iso_STN, e_iso_SVC, e_iso_SYP, e_iso_SZL, e_iso_THB, e_iso_TJS, e_iso_TMT, e_iso_TND, e_iso_TOP, e_iso_TRY,
                e_iso_TTD, e_iso_TWD, e_iso_TZS, e_iso_UAH, e_iso_UGX, e_iso_USD, e_iso_USN, e_iso_UYI, e_iso_UYU, e_iso_UYW, e_iso_UZS,
                e_iso_VES, e_iso_VND, e_iso_VUV, e_iso_WST, e_iso_XAF, e_iso_XAG, e_iso_XAU, e_iso_XBA, e_iso_XBB, e_iso_XBC, e_iso_XBD,
                e_iso_XCD, e_iso_XDR, e_iso_XOF, e_iso_XPD, e_iso_XPF, e_iso_XPT, e_iso_XSU, e_iso_XTS, e_iso_XUA, e_iso_XXX, e_iso_YER,
                e_iso_ZAR, e_iso_ZMW, e_iso_ZWL } e_currency; // ISO 4217
typedef enum { av_sell, av_rent, av_trade, av_meet, av_announce, av_offer, av_wanted, av_event, av_service } e_action;
typedef enum { he_language, he_type, he_style, he_refresh, he_cookie, he_policy } e_httpequiv;
typedef enum { k_subtitles, k_captions, k_descriptions, k_chapters, k_metadata } e_kind;

typedef enum {
// https://www.w3.org/html/wiki/Elements/meta
               mn_application, mn_author, mn_description, mn_generator, mn_keywords,
// http://ec.europa.eu/ipg/content/optimise/metadata/annex2_en.htm
               mn_classification,
// https://www.metatags.org/
               mn_copyright,  // despite metatags opinion, I suggest this metaname still has legal relevance
               // outdated
               mn_contactCity, mn_contactCountry, mn_contactFaxNumber, mn_contactName, mn_contactNetworkAddress, mn_contactOrganization,
               mn_contactPhoneNumber, mn_contactStreetAddress1, mn_contactZipcode, mn_creation, mn_distribution,
               mn_host, mn_host_admin, mn_id, mn_identifier_url, mn_language, mn_linkage, mn_note, mn_operator, mn_presdate,
               mn_rating, mn_subject, mn_template, mn_version,
// https://gist.github.com/lancejpollard/1978404
                // archaic
                mn_abstract, mn_coverage, mn_og_email, mn_og_phone_number, mn_og_fax_number, mn_og_latitude, mn_og_longitude,
                mn_og_street_address, mn_og_locality, mn_og_region, mn_og_postal_code, mn_og_country_name, mn_microid,
                mn_owner, mn_revised, mn_topic, mn_summary, mn_tweetmeme_title,
// https://wiki.whatwg.org/wiki/MetaExtensions
               // valid proposals
               mn_aglsterms_accessmode, mn_aglsterms_accessibility, mn_aglsterms_act, mn_aglsterms_aggregationlevel, mn_aglsterms_allow_search,
               mn_aglsterms_availability, mn_aglsterms_case, mn_aglsterms_category, mn_aglsterms_datelicensed, mn_aglsterms_documenttype,
               mn_aglsterms_function, mn_aglsterms_isbasedon, mn_aglsterms_isbasisfor, mn_aglsterms_jurisdiction, mn_aglsterms_mandate,
               mn_aglsterms_protectivemarking, mn_aglsterms_regulation, mn_aglsterms_servicetype, mn_dcs_dcssta, mn_essaydirectory,
               mn_flblogauthor, mn_fsdatecreation, mn_fsdatepublish, mn_fsflcontent, mn_fslanguage, mn_fsonsitemap, mn_fspagedescription,
               mn_fspagename, mn_fssearchable, mn_fssection, mn_fswritertoolpagetype, mn_ie_rm_off, mn_mssmarttagspreventparsing,
               mn_repostusapikey, mn_resourceloaderdynamicstyles, mn_wt_si_n, mn_wt_si_p, mn_wt_si_x, mn_zoomcategory, mn_zoomdescription,
               mn_zoomimage, mn_zoompageboost, mn_zoomtitle, mn_zoomwords, mn_alexaverifyid, mn_apple_itunes_app, mn_apple_mobile_web_app_capable,
               mn_apple_mobile_web_app_status_bar_style, mn_apple_mobile_web_app_title, mn_apple_touch_fullscreen, mn_application_name,
               mn_application_url, mn_appstore_bundle_id, mn_appstore_developer_url, mn_appstore_store_id, mn_audience, mn_bitcoin,
               mn_blazerr_secure, mn_blazerr_seo, mn_blazerr_ssl, mn_blazerr_support_id_noncookies, mn_blazerr_support_identifier,
               mn_bug_blocked, mn_bug_comment, mn_bug_component, mn_bug_product, mn_bug_short_desc, mn_cfia_gdr_activity,
               mn_cfia_gdr_commodity, mn_cfia_gdr_include, mn_cfia_gdr_program, mn_citation_author, mn_citation_author_email,
               mn_citation_author_institution, mn_citation_conference_title, mn_citation_date, mn_citation_dissertation_institution,
               mn_citation_doi, mn_citation_firstpage, mn_citation_fulltext_html_url, mn_citation_isbn, mn_citation_issn, mn_citation_issue,
               mn_citation_journal_abbrev, mn_citation_journal_title, mn_citation_keywords, mn_citation_language, mn_citation_lastpage,
               mn_citation_pdf_url, mn_citation_publication_date, mn_citation_publisher, mn_citation_technical_report_institution,
               mn_citation_technical_report_number, mn_citation_title, mn_citation_volume, mn_collection, mn_contact, mn_creator,
               mn_csrf_param, mn_csrf_token, mn_da_anonymiseip, mn_da_contactcompany, mn_da_contactemail, mn_da_contactfirstname,
               mn_da_contactlastname, mn_da_contactname, mn_da_contacttelephone, mn_da_conversioncurrency, mn_da_conversionid,
               mn_da_conversionvalue, mn_da_goalcurrency, mn_da_goalid, mn_da_goalvalue, mn_da_interactionselector, mn_da_pagerole,
               mn_da_pagetaxonomy, mn_da_pagetitle, mn_da_pageversion, mn_da_sessionid, mn_da_userid, mn_dc_created, mn_dc_creator,
               mn_dc_date_issued, mn_dc_datecopyrighted, mn_dc_datesubmitted, mn_dc_description, mn_dc_language, mn_dc_license, mn_dc_mediator,
               mn_dc_medium, mn_dc_modified, mn_dc_provenance, mn_dc_publisher, mn_dc_references, mn_dc_temporal, mn_dc_title, mn_dc_type,
               mn_dc_valid, mn_dcterms_abstract, mn_dcterms_accessrights, mn_dcterms_accrualmethod, mn_dcterms_accrualperiodicity,
               mn_dcterms_accrualpolicy, mn_dcterms_alternative, mn_dcterms_audience, mn_dcterms_available, mn_dcterms_bibliographiccitation,
               mn_dcterms_collection, mn_dcterms_conformsto, mn_dcterms_contributor, mn_dcterms_coverage, mn_dcterms_created, mn_dcterms_creator,
               mn_dcterms_date, mn_dcterms_dateaccepted, mn_dcterms_datecopyrighted, mn_dcterms_datesubmitted, mn_dcterms_description,
               mn_dcterms_educationlevel, mn_dcterms_extent, mn_dcterms_format, mn_dcterms_hasformat, mn_dcterms_haspart, mn_dcterms_hasversion,
               mn_dcterms_identifier, mn_dcterms_instructionalmethod, mn_dcterms_isformatof, mn_dcterms_ispartof, mn_dcterms_isreferencedby,
               mn_dcterms_isreplacedby, mn_dcterms_isrequiredby, mn_dcterms_isversionof, mn_dcterms_issued, mn_dcterms_language, mn_dcterms_license,
               mn_dcterms_mediator, mn_dcterms_medium, mn_dcterms_modified, mn_dcterms_provenance, mn_dcterms_publisher, mn_dcterms_references,
               mn_dcterms_relation, mn_dcterms_replaces, mn_dcterms_requires, mn_dcterms_rights, mn_dcterms_rightsholder, mn_dcterms_source,
               mn_dcterms_spatial, mn_dcterms_subject, mn_dcterms_tableofcontents, mn_dcterms_temporal, mn_dcterms_title, mn_dcterms_type,
               mn_dcterms_valid, mn_designer, mn_detectify_verification, mn_entity,
               mn_fdse_description, mn_fdse_index_as, mn_fdse_keywords, mn_fdse_refresh, mn_fdse_robots, mn_format_detection, mn_format_print,
               mn_fragment, mn_gcterms_topictaxonomy, mn_geo_a1, mn_geo_a2, mn_geo_a3, mn_geo_country, mn_geo_lmk, mn_geo_placename, mn_geo_position,
               mn_geo_region, mn_globrix_bathrooms, mn_globrix_bedrooms, mn_globrix_condition, mn_globrix_features, mn_globrix_instruction,
               mn_globrix_latitude, mn_globrix_longitude, mn_globrix_outsidespace, mn_globrix_parking, mn_globrix_period, mn_globrix_poa,
               mn_globrix_postcode, mn_globrix_price, mn_globrix_priceproximity, mn_globrix_tenure, mn_globrix_type, mn_globrix_underoffer,
               mn_go_import, mn_google, mn_google_play_app, mn_google_site_verification,
               mn_gwt_property, mn_handheldfriendly, mn_icas_datetime, mn_icas_datetime_abbr, mn_icas_datetime_day, mn_icas_datetime_long,
               mn_icbm, mn_itemsperpage, mn_keywords_not, mn_meta_date, mn_microtip, mn_mobile_agent, mn_mobile_web_app_capable, mn_mobileoptimized,
               mn_msapplication_tilecolor, mn_msapplication_tileimage, mn_msapplication_config, mn_msapplication_navbutton_color,
               mn_msapplication_notification, mn_msapplication_square150x150logo, mn_msapplication_square310x310logo,
               mn_msapplication_square70x70logo, mn_msapplication_starturl, mn_msapplication_tap_highlight, mn_msapplication_task,
               mn_msapplication_tooltip, mn_msapplication_wide310x150logo, mn_msapplication_window, mn_msvalidate_01, mn_nextgen,
               mn_nibbler_site_verification, mn_nonfiction, mn_norton_safeweb_site_verification, mn_origin, mn_origin_trials, mn_p_domain_verify, mn_page_version,
               mn_pingdom, mn_pinterest, mn_prism_alternatetitle, mn_pro, mn_pro_auth, mn_pro_auth_field, mn_pro_auth_fragment,
               mn_referrer, mn_review_date, mn_revision, mn_revisit_after, mn_rights, mn_rights_standard, mn_robots, mn_rpuplugin,
               mn_rqid, mn_shareaholic_analytics, mn_shareaholic_article_author, mn_shareaholic_article_author_name,
               mn_shareaholic_article_modified_time, mn_shareaholic_article_published_time, mn_shareaholic_article_visibility,
               mn_shareaholic_drupal_version, mn_shareaholic_image, mn_shareaholic_keywords, mn_shareaholic_language, mn_shareaholic_outstreamads,
               mn_shareaholic_shareable_page, mn_shareaholic_site_id, mn_shareaholic_site_name, mn_shareaholic_url, mn_shareaholic_wp_version,
               mn_signet_authors, mn_signet_links, mn_skype_toolbar, mn_startindex, mn_startver, mn_subject_datetime, mn_subject_system,
               mn_theme_color, mn_thumbnail, mn_topper, mn_topper_major, mn_topper_minor, mn_totalresults, mn_translator, mn_twitter_app_country,
               mn_twitter_app_id_googleplay, mn_twitter_app_id_ipad, mn_twitter_app_id_iphone, mn_twitter_app_name_googleplay,
               mn_twitter_app_name_ipad, mn_twitter_app_name_iphone, mn_twitter_app_url_googleplay, mn_twitter_app_url_ipad,
               mn_twitter_app_url_iphone, mn_twitter_card, mn_twitter_creator, mn_twitter_creator_id, mn_twitter_data1, mn_twitter_data2,
               mn_twitter_description, mn_twitter_domain, mn_twitter_image, mn_twitter_image0, mn_twitter_image1, mn_twitter_image2,
               mn_twitter_image3, mn_twitter_image_height, mn_twitter_image_src, mn_twitter_image_width, mn_twitter_label1, mn_twitter_label2,
               mn_twitter_player, mn_twitter_player_height, mn_twitter_player_stream, mn_twitter_player_stream_content_type,
               mn_twitter_player_width, mn_twitter_site, mn_twitter_site_id, mn_twitter_title, mn_twitter_url, mn_typemetal_formatprefs,
               mn_verify_v1, mn_vfb_version, mn_viewport, mn_web_author, mn_witget, mn_wot_verification, mn_wt_ac, mn_wt_ad, mn_wt_cg_n,
               mn_wt_cg_s, mn_wt_mc_id, mn_wt_sv, mn_wt_ti, mn_y_key, mn_yandex_verification,
               // invalid proposals
               mn_blogcatalog, mn_created, mn_expires, mn_fb_admins, mn_fb_page_id, mn_gm_gpx_v, mn_google_translate_customization, mn_og_description,
               mn_og_image, mn_og_locale, mn_og_site_name, mn_og_title, mn_og_type, mn_og_url, mn_resolutions,
               // rejected propoals
               mn_cache, mn_dir_content_pointer, mn_no_email_collection,
               // that's end
               mn_illegal } e_metaname;
constexpr e_metaname metaname_first_w3 = mn_application;
constexpr e_metaname metaname_first_eu = mn_classification;
constexpr e_metaname metaname_first_outdated = mn_contactCity;
constexpr e_metaname metaname_first_archaic = mn_abstract;
constexpr e_metaname metaname_first_whatwg = mn_aglsterms_accessmode;
constexpr e_metaname metaname_first_dubious = mn_blogcatalog;
constexpr e_metaname metaname_first_rejected = mn_cache;

typedef enum { r_no, r_downgrade, r_same, r_origin, r_strict, r_cross, r_unsafe } e_referrer;
typedef enum { s_unknown, s_forms, s_pointer, s_popups, s_presentation, s_origin, s_scripts, s_navigation } e_sandbox;

template < typename TYPE, e_type E > struct enum_base : public type_base < E >
{   TYPE value_;
    ::std::string original_;
    static ::std::string values () { return ::std::string (); }
    static ::std::size_t value_count () { return 0; }
    void swap (enum_base& t) noexcept
    {   ::std::swap (value_, t.value_);
        original_.swap (t.original_);
        type_base < E >::swap (t); }
    ::std::string get_value () const { return ::std::string (); }
    ::std::string original () const { return original_; }
    void set_value (const ::std::string& s)
    {   original_ = s;
        value_ = static_cast < TYPE > (0);
        type_base < E > :: status (s_invalid); }
    ::std::string diagnose () const; };

template < typename TYPE, e_type E > ::std::string enum_base < TYPE, E > :: diagnose () const
{   if (! type_base < E > :: invalid ()) return ::std::string ();
    if (! context.tell (e_error)) return ::std::string ();
    ::std::string s (quote (original_));
    if (value_count () < 10)
    {   s += " is not among ";
        s += values (); }
    else s += " is not a standard value";
    return s; }

#define DECLARE_ENUM_TYPE(TT, ENUM, STRUCT) \
struct STRUCT : symbol < ENUM > \
{   static void init (); }; \
template < > inline ::std::string enum_base < ENUM, TT > :: get_value () const \
{   if (type_base < TT > :: unknown ()) return ::std::string (); \
    return STRUCT :: name (value_); } \
template < > inline void enum_base < ENUM, TT > :: set_value (const ::std::string& s) \
    {   original_ = s; \
        if (STRUCT :: parse (s, value_)) type_base < TT > :: status (s_good); \
        else type_base < TT > :: status (s_invalid); } \
template < > inline ::std::string enum_base < ENUM, TT > :: values () \
{   return STRUCT :: value_list (); } \
template < > inline ::std::size_t enum_base < ENUM, TT > :: value_count () \
{   return STRUCT :: value_count (); } \
template < > class type_master < TT > : public enum_base < ENUM, TT > { };

DECLARE_ENUM_TYPE (t_action, e_action, action)
DECLARE_ENUM_TYPE (t_currency, e_currency, currency)
DECLARE_ENUM_TYPE (t_httpequiv, e_httpequiv, httpequiv)
DECLARE_ENUM_TYPE (t_kind, e_kind, kind)
DECLARE_ENUM_TYPE (t_metaname, e_metaname, metaname)
DECLARE_ENUM_TYPE (t_referrer, e_referrer, referrer)
DECLARE_ENUM_TYPE (t_sandbox, e_sandbox, sandbox)

template < > inline ::std::string enum_base < e_metaname, t_metaname >  :: diagnose () const
{   ::std::string s (quote (original_));
    if (! type_base < t_metaname > :: invalid ())
    {   if (value_ >= metaname_first_rejected) { if (context.tell (e_warning)) return s + " was rejected as a meta name (by WhatWG)"; }
        else if (value_ >= metaname_first_dubious) { if (context.tell (e_comment)) return s + " has not been accepted as a meta name (by WhatWG)"; }
        else if (value_ < metaname_first_whatwg)
        {   if (value_ >= metaname_first_archaic) { if (context.tell (e_info)) return s + " is an archaic meta name, not listed by WhatWG"; }
            else if (value_ >= metaname_first_outdated) { if (context.tell (e_info)) return s + " is an outdated meta name (metatags.org)"; }
            else if (value_ >= metaname_first_eu) { if (context.tell (e_comment)) return s + " is specific to the European Union"; } } }
    else if (context.tell (e_warning)) return s + " is not a standard meta name";
    return ::std::string (); }

template < > struct type_master < t_dosh > : public string_value < t_dosh >
{   double value_ = 0.0;
    e_currency unit_ = e_iso_unknown;
    void swap (type_master < t_dosh >& t) noexcept
    {   ::std::swap (value_, t.value_);
        ::std::swap (unit_, t.unit_);
        type_base < t_dosh >::swap (t); }
    bool parse (const ::std::string& s) // see http://microformats.org/wiki/h-listing
    {   const vstr_t args (split_by_space (s));
        if (args.size () > 2) return false;
        ::std::string amount;
        if (args.size () == 1) amount = trim_the_lot_off (args [0]);
        if (args.size () == 2)
        {   const ::std::string c (args [0]);
            if (currency::find (args [0], unit_)) amount = trim_the_lot_off (args [1]);
            else if (! currency::find (amount, unit_)) return false; }
        if (amount.empty ()) return false;
        bool res = false;
        value_ = lexical < double > :: cast2 (amount, res);
        return res; }
    void set_value (const ::std::string& s)
    {   const ::std::string val (trim_the_lot_off (s));
        string_value < t_dosh > :: set_value (val);
        if (! parse (val)) type_base < t_dosh > :: status (s_invalid); }
    ::std::string diagnose () const
    {   if (! string_value < t_dosh > :: invalid ()) return ::std::string ();
        if (! context.tell (e_warning)) return ::std::string ();
        ::std::string s (quote (string_value < t_dosh > :: get_value ()));
        s += " is not a valid amount of money (i.e. 'EUR 3.14'; see ISO 4217)";
        return s; } };
