/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "type_url.h"
#include "directory.h"
#include "url.h"
#include "quote.h"

bool verify_directory_url (const directory& d, const ::std::string& url, ::std::ostringstream& ss)
{   if (! context.links ()) return true;
    return d.verify_url (url, ss); }

bool url_sanity_test (const url& u)
{   // only http: & https: processed for now
    if (u.empty ()) return false;
    if (! u.has_protocol ()) return true; // presume internal link.
    return u.is_usable (); }

::std::string url_verify_id (const sstr_t* ssi, const ::std::string& original, const ::std::string& fragment)
{   ::std::string res;
    if (! original.empty () && (original [0] == '#') && ! fragment.empty ())
    {   assert (ssi != nullptr);
        if (ssi -> find (fragment) == ssi -> cend ())
        {   res = "id(s) ";
            res += quote (fragment);
            res += " not found"; } }
    return res; }
