/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "standard.h"
#include "elem.h"
#include "context.h"
#include "quote.h"
#include "type.h"

struct symbol_entry < e_element > elem_symbol_table [] =
{   { { HTML_PLUS }, { HTML_UNDEF }, "!doctype", elem_faux_doctype, ns_default, EP_CLOSED | EP_TOP },
    { { HTML_TAGS }, { HTML_UNDEF }, "(*ERROR*)", elem_error, ns_default, EP_CLOSED | EP_IGNORE },
    { { HTML_2_0 }, { HTML_UNDEF }, "(asp)", elem_faux_asp, ns_default, EP_CLOSED | EP_IGNORE, EF_FAUX | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_TAGS }, { HTML_UNDEF }, "(comment)", elem_faux_comment, ns_default, EP_CLOSED | EP_IGNORE, EF_FAUX | EF_5_FLOW | EF_5_PHRASE },
    { { HTML_TAGS }, { HTML_UNDEF }, "(document)", elem_faux_document, ns_default, 0, EF_FAUX | EF_DOCUMENT },
    { { HTML_2_0 }, { HTML_UNDEF }, "(php)", elem_faux_php, ns_default, EP_CLOSED | EP_IGNORE, EF_FAUX | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_2_0 }, { HTML_UNDEF }, "(ssi)", elem_faux_ssi, ns_default, EP_CLOSED | EP_IGNORE, EF_FAUX | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_3_0 }, { HTML_UNDEF }, "(stylesheet)", elem_faux_stylesheet, ns_default, EP_CLOSED | EP_IGNORE, EF_FAUX },
    { { HTML_TAGS }, { HTML_UNDEF }, "(text)", elem_faux_text, ns_default, EP_CLOSED | EP_IGNORE, EF_FAUX | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_TAGS }, { HTML_UNDEF }, "(undefined)", elem_undefined, ns_default, EP_CLOSED | EP_IGNORE },
    { { HTML_TAGS }, { HTML_UNDEF }, "(whitespace)", elem_faux_whitespace, ns_default, EP_CLOSED | EP_IGNORE, EF_FAUX | EF_5_FLOW | EF_5_PHRASE },
    { { XHTML_1_0 }, { HTML_UNDEF }, "(xml)", elem_faux_xml, ns_default, EP_CLOSED | EP_IGNORE | EP_TOP, EF_FAUX },
    { { HTML_TAGS }, { HTML_UNDEF }, "a", elem_a, ns_default, EP_LAZY | EP_5_TRANSPARENT, EF_TEXT | EF_PRE | EF_SPECIAL | EF_4_SPECIAL | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_INTERACTIVE | EF_5_PALPABLE | EF_S_G | EF_SVG_CONTAIN },
    { { HTML_4_0 }, { HTML_UNDEF }, "abbr", elem_abbr, ns_default, EP_SIMPLE, EF_4_PHRASE | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_PLUS, HV_NOT2 }, { HTML_3_0 }, "abbrev", elem_abbrev, ns_default, 0, EF_EMPH | EF_3_MISC },
    { { HTML_3_0 }, { HTML_3_0 }, "above", elem_above, ns_default, 0, EF_MATH },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "abs", elem_abs, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_PLUS }, { HTML_PLUS }, "abstract", elem_abstract, ns_default, 0, EF_BLOK },
    { { XHTML_2_0 }, { XHTML_2_0 }, "access", elem_access, ns_default, EP_CLOSED, EF_METADATA },
    { { HTML_PLUS, HV_NOT2 }, { XHTML_1_1 }, "acronym", elem_acronym, ns_default, 0, EF_EMPH | EF_3_MISC | EF_4_PHRASE },
    { { XHTML_2_0 }, { XHTML_2_0 }, "action", elem_action, ns_default, 0, EF_X2_STRUCT },
    { { HTML_PLUS }, { HTML_PLUS }, "added", elem_added, ns_default, 0, EF_EMPH },
    { { XHTML_2_0 }, { XHTML_2_0 }, "addeventlistener", elem_addeventlistener, ns_default, EP_CLOSED },
    { { HTML_TAGS }, { HTML_UNDEF }, "address", elem_address, ns_default, 0, EF_BODY | EF_3_BODY | EF_4_BLOCK | EF_X2_STRUCT | EF_5_FLOW | EF_5_PALPABLE },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "altglyph", elem_altglyph, ns_default, 0, EF_SVG_TEXT },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "altglyphdef", elem_altglyphdef },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "altglyphitem", elem_altglyphitem },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "and", elem_and, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 | HE_SVG_2_0 }, { HTML_UNDEF }, "animate", elem_animate, ns_default, 0, EF_SVG_ANIM },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "animatecolor", elem_animatecolour, ns_default, 0, EF_SVG_ANIM },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 | HE_SVG_2_0 }, { HTML_UNDEF }, "animatemotion", elem_animatemotion, ns_default, 0, EF_SVG_ANIM },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 | HE_SVG_2_0 }, { HTML_UNDEF }, "animatetransform", elem_animatetransform, ns_default, 0, EF_SVG_ANIM },
    { { XHTML_1_0, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "animation", elem_animation },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "annotation", elem_annotation, ns_default, 0, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "annotation-xml", elem_annotation_xml, ns_default, 0, EF_M_CONTENT },
    { { HTML_3_2, HV_DEPRECATED4 }, { XHTML_2_0 }, "applet", elem_applet, ns_default, 0, EF_SPECIAL | EF_4_SPECIAL },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "apply", elem_apply, ns_default, 0, EF_M_CONTENT | EF_M_CONTINPRES },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "arccos", elem_arccos, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "arcsin", elem_arcsin, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "arctan", elem_arctan, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_2_0, HV_RFC_1980 | HV_NOT30 }, { HTML_UNDEF }, "area", elem_area, ns_default, EP_CLOSED, EF_5_FLOW | EF_5_PHRASE },
    { { HTML_PLUS }, { HTML_PLUS }, "arg", elem_arg, ns_default, 0, EF_EMPH },
    { { HTML_PLUS, HV_NOT2 }, { HTML_3_0 }, "array", elem_array, ns_default, 0, EF_MATH },
    { { HTML_5_0 }, { HTML_UNDEF }, "article", elem_article, ns_default, 0, EF_5_FLOW | EF_5_SECTION | EF_5_PALPABLE },
    { { HTML_5_0 }, { HTML_UNDEF }, "aside", elem_aside, ns_default, EP_SIMPLE, EF_5_FLOW | EF_5_SECTION | EF_5_PALPABLE },
//    { { HTML_2_0 }, { HTML_UNDEF }, "asp", elem_faux_asp, ns_default, EP_IGNORE, EF_FAUX },
    { { HTML_3_0 }, { HTML_3_0 }, "atop", elem_atop, ns_default, EP_CLOSED },
    { { HTML_3_0 }, { HTML_3_0 }, "au", elem_au, ns_default, 0, EF_3_MISC },
    { { HTML_5_0 }, { HTML_UNDEF }, "audio", elem_audio, ns_default, EP_5_TRANSPARENT, EF_5_FLOW | EF_5_PHRASE | EF_5_EMBEDDED | EF_5_INTERACTIVE | EF_5_PALPABLE | EF_SVG_STR | EF_SVG2_GRAPH },
    { { HTML_1_0 }, { HTML_UNDEF }, "b", elem_b, ns_default, 0, EF_EMPH | EF_FONT | EF_3_TEXT | EF_3_MATHVC | EF_32_FONT | EF_4_FONT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_3_0 }, { HTML_3_0 }, "banner", elem_banner },
    { { HTML_3_0 }, { HTML_3_0 }, "bar", elem_bar, ns_default, 0, EF_3_MATHVC },
    { { HTML_TAGS }, { HTML_UNDEF }, "base", elem_base, ns_default, EP_CLOSED, EF_METADATA },
    { { HTML_3_2, HV_DEPRECATED4 }, { XHTML_1_1 }, "basefont", elem_basefont, ns_default, EP_CLOSED, EF_SPECIAL | EF_4_SPECIAL },
    { { HTML_5_0 }, { HTML_UNDEF }, "bdi", elem_bdi, ns_default, 0, EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_2_0, HV_RFC_2070 }, { HTML_UNDEF }, "bdo", elem_bdo, ns_default, 0, EF_PRE | EF_TEXT | EF_4_SPECIAL | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_3_0 }, { HTML_3_0 }, "below", elem_below, ns_default, 0, EF_MATH },
    { { HTML_2_0, 0, HE_IE }, { HTML_4_01 }, "bgsound", elem_bgsound, ns_default, EP_CLOSED },
    { { HTML_3_0 }, { XHTML_1_1 }, "big", elem_big, ns_default, 0, EF_3_FONT | EF_32_FONT | EF_4_FONT },
    { { HTML_2_0, 0, HE_NETSCAPE }, { HTML_4_01 }, "blink", elem_blink, ns_default, EP_SIMPLE },
    { { XHTML_2_0 }, { XHTML_2_0 }, "blockcode", elem_blockcode, ns_default, 0, EF_X2_STRUCT },
    { { HTML_1_0, HV_DEPRECATED30 }, { HTML_UNDEF }, "blockquote", elem_blockquote, ns_default, 0, EF_3_BQ | EF_BODY | EF_32_BLOCK | EF_4_BLOCK | EF_5_FLOW | EF_X2_STRUCT | EF_5_PALPABLE | EF_5_SECTION },
    { { HTML_1_0 }, { HTML_UNDEF }, "body", elem_body, ns_default, EP_LAZY },
    { { HTML_PLUS, HV_NOT2 }, { HTML_3_0 }, "box", elem_box, ns_default, 0, EF_MATH },
    { { HTML_3_0, HV_DEPRECATED30 }, { HTML_3_0 }, "bq", elem_bq, ns_default, 0, EF_3_BQ },
    { { HTML_1_0 }, { HTML_UNDEF }, "br", elem_br, ns_default, EP_CLOSED, EF_TEXT | EF_PRE | EF_SPECIAL | EF_4_SPECIAL | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE },
    { { HTML_3_0 }, { HTML_3_0 }, "bt", elem_bt, ns_default, 0, EF_3_MATHVC },
    { { HTML_4_0, HV_NOTX2 }, { HTML_UNDEF }, "button", elem_button, ns_default, 0, EF_4_FORM | EF_5_FLOW | EF_5_PHRASE | EF_5_INTERACTIVE | EF_5_PALPABLE | EF_5_FORM },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "bvar", elem_bvar, ns_default, 0, EF_M_CONTENT },
    { { HTML_PLUS }, { HTML_PLUS }, "byline", elem_byline, ns_default, 0, EF_BLOK },
    { { HTML_5_0 }, { HTML_UNDEF }, "canvas", elem_canvas, ns_default, EP_5_TRANSPARENT, EF_5_FLOW | EF_5_PHRASE | EF_5_EMBEDDED | EF_5_PALPABLE | EF_SVG2_GRAPH },
    { { HTML_PLUS, HV_RFC_1942 }, { HTML_UNDEF }, "caption", elem_caption, ns_default, 0, EF_X2_STRUCT | EF_X2_LIST },
    { { HTML_2_0, HV_DEPRECATED23 }, { HTML_2_0 }, "cdata", elem_cdata },  // mentioned in RFC 2070
    { { HTML_3_2 }, { XHTML_1_1 }, "center", elem_centre, ns_default, 0, EF_32_BLOCK | EF_4_BLOCK },
    { { HTML_PLUS }, { HTML_PLUS }, "changed", elem_changed, ns_default, EP_CLOSED, EF_TEXT },
    { { HTML_3_0 }, { HTML_3_0 }, "choose", elem_choose, ns_default, EP_CLOSED },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "ci", elem_ci, ns_default, 0, EF_M_CONTENT | EF_M_CONTINPRES },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "circle", elem_circle, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_S_G | EF_SVG_SHAPE | EF_SVG_GRAPH | EF_SVG2_GRAPH },
    { { HTML_1_0 }, { HTML_UNDEF }, "cite", elem_cite, ns_default, 0, EF_EMPH | EF_PHRASE | EF_4_PHRASE | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "clippath", elem_clippath },
    { { HTML_PLUS }, { HTML_PLUS }, "cmd", elem_cmd, ns_default, 0, EF_EMPH },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "cn", elem_cn, ns_default, 0, EF_M_CONTENT | EF_M_CONTINPRES },
    { { HTML_1_0 }, { HTML_UNDEF }, "code", elem_code, ns_default, 0, EF_EMPH | EF_PHRASE | EF_4_PHRASE | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_2_0, HV_RFC_1942 | HV_NOT3 }, { HTML_UNDEF }, "col", elem_col, ns_default, EP_CLOSED },
    { { HTML_2_0, HV_RFC_1942 | HV_NOT3 }, { HTML_UNDEF }, "colgroup", elem_colgroup },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "colorprofile", elem_colourprofile },
    { { HTML_5_0, 0, HE_BESPOKE }, { HTML_5_0 }, "command", elem_command, ns_default, EP_CLOSED },
    { { HTML_1_0, HV_DEPRECATED1 | HE_IE | HE_NETSCAPE }, { HTML_1_0 }, "comment", elem_comment, ns_default, EP_XMP, EF_LIT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "compose", elem_compose, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "condition", elem_condition, ns_default, 0, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "conjugate", elem_conjugate, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_5_0, 0, HE_WEBCOMP }, { HTML_UNDEF }, "content", elem_content, ns_default, EP_CLOSED },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "cos", elem_cos, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "cosh", elem_cosh, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "cot", elem_cot, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "coth", elem_coth, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_3_0 }, { HTML_3_0 }, "credit", elem_credit },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "csc", elem_csc, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "csch", elem_csch, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "cursor", elem_cursor, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11 },
    { { HTML_4_0 }, { HTML_UNDEF }, "data", elem_data, ns_default, EP_CLOSED | EP_5_OPEN, EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_5_0 }, { HTML_UNDEF }, "datalist", elem_datalist, ns_default, 0, EF_5_FLOW | EF_5_PHRASE },
    { { HTML_TAGS }, { HTML_UNDEF }, "dd", elem_dd, ns_default, EP_LAZY | EP_UNCLOSED1T,  EF_X2_STRUCT | EF_X2_LIST },
    { { HTML_3_0 }, { HTML_3_0 }, "ddot", elem_ddot, ns_default, 0, EF_3_MATHVC },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "declare", elem_declare, ns_default, 0, EF_M_CONTENT },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "defs", elem_defs, ns_default, 0, EF_S_G | EF_SVG_STR | EF_SVG_CONTAIN },
    { { HTML_3_0, HV_NOT32 }, { HTML_UNDEF }, "del", elem_del, ns_default, EP_5_TRANSPARENT, EF_3_MISC | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "degree", elem_degree, ns_default, 0, EF_M_CONTENT },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "desc", elem_desc, ns_default, 0, EF_S_G | EF_SVG_DESC },
    { { HTML_5_1 }, { HTML_UNDEF }, "details", elem_details, ns_default, 0, EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "determinant", elem_determinant, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_1_0 }, { HTML_UNDEF }, "dfn", elem_dfn, ns_default, 0, EF_EMPH | EF_3_MISC | EF_4_PHRASE | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { XHTML_2_0 }, { XHTML_2_0 }, "di", elem_di, ns_default, 0, EF_X2_STRUCT | EF_X2_LIST },
    { { HTML_5_2 }, { HTML_UNDEF }, "dialog", elem_dialogue, ns_default, 0, EF_5_FLOW },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "diff", elem_diff, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_TAGS, HV_DEPRECATED30 | HV_DEPRECATED4 }, { HTML_4_01 }, "dir", elem_dir, ns_default, EP_ONLYELEMENTS, EF_3_LIST | EF_LL | EF_LIST | EF_32_BLOCK | EF_4_BLOCK },
    { { XHTML_2_0, 0, HE_SVG_1_2 | HE_SVG_2_0 }, { HTML_UNDEF }, "discard", elem_discard },
    { { XHTML_2_0 }, { XHTML_2_0 }, "dispatchevent", elem_dispatchevent, ns_default, EP_CLOSED },
    { { HTML_3_0 }, { HTML_UNDEF }, "div", elem_div, ns_default, 0, EF_3_BODY | EF_32_BLOCK | EF_4_BLOCK | EF_X2_STRUCT | EF_5_FLOW | EF_5_PALPABLE },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "divide", elem_divide, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_TAGS }, { HTML_UNDEF }, "dl", elem_dl, ns_default, EP_ONLYELEMENTS, EF_BODY | EF_LIST | EF_3_BLOCK | EF_32_BLOCK | EF_4_BLOCK | EF_X2_STRUCT | EF_X2_LIST | EF_5_FLOW | EF_5_PALPABLE },
    { { HTML_3_0 }, { HTML_3_0 }, "dot", elem_dot, ns_default, 0, EF_3_MATHVC },
    { { HTML_TAGS }, { HTML_UNDEF }, "dt", elem_dt, ns_default, EP_UNCLOSED1T | EP_LAZY, EF_X2_STRUCT | EF_X2_LIST },
    { { HTML_5_0, 0, HE_WEBCOMP }, { HTML_UNDEF }, "element", elem_element, ns_default, EP_CLOSED },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "elementdef", elem_elementdef },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "ellipse", elem_ellipse, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_S_G | EF_SVG_SHAPE | EF_SVG_GRAPH | EF_SVG2_GRAPH },
    { { HTML_1_0 }, { HTML_UNDEF }, "em", elem_em, ns_default, 0, EF_EMPH | EF_PHRASE | EF_4_PHRASE | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_5_0 }, { HTML_UNDEF }, "embed", elem_embed, ns_default, EP_CLOSED | EP_5_WILDATTR, EF_5_FLOW | EF_5_PHRASE | EF_5_EMBEDDED | EF_5_INTERACTIVE | EF_5_PALPABLE },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "eq", elem_eq, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "exists", elem_exists, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "extensiondefs", elem_extensiondefs },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "exp", elem_exp, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "factorial", elem_factorial, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "feblend", elem_feblend, ns_default, EP_CLOSED, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "fecolor", elem_fecolour, ns_default, EP_CLOSED, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "fecolormatrix", elem_fecolourmatrix, ns_default, EP_CLOSED, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "fecomponenttransfer", elem_fecomponenttransfer, ns_default, 0, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "fecomposite", elem_fecomposite, ns_default, EP_CLOSED, EF_SVG_FILTER },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "feconvolvematrix", elem_feconvolvematrix, ns_default, 0, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "fediffuselighting", elem_fediffuselighting, ns_default, 0, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "fedisplacementmap", elem_fedisplacementmap, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "fedistantlight", elem_fedistantlight, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_SVG_FILTER },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "fedropshadow", elem_fedropshadow, ns_default, 0, EF_SVG_FILTER },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "feflood", elem_feflood, ns_default, 0, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "fefunca", elem_fefunca, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "fefuncb", elem_fefuncb, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "fefuncg", elem_fefuncg, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "fefuncr", elem_fefuncr, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "fegaussianblur", elem_fegaussianblur, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "feimage", elem_feimage, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "femerge", elem_femerge, ns_default, 0, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "femergenode", elem_femergenode, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "femorphology", elem_femorphology, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "feoffset", elem_feoffset, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "fepointlight", elem_fepointlight, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "fespecularlighting", elem_fespecularlighting, ns_default, 0, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "fespotlight", elem_fespotlight, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "fetile", elem_fetile, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_SVG_FILTER },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "feturbulence", elem_feturbulence, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_SVG_FILTER },
    { { HTML_4_0, HV_NOTX2 }, { HTML_UNDEF }, "fieldset", elem_fieldset, ns_default, 0, EF_4_BLOCK | EF_5_FLOW | EF_5_PALPABLE },
    { { HTML_PLUS, HV_NOT2 }, { HTML_3_0 }, "fig", elem_fig, ns_default, 0, EF_PARA | EF_3_BLOCK },
    { { HTML_5_0 }, { HTML_UNDEF }, "figcaption", elem_figcaption },
    { { HTML_5_0 }, { HTML_UNDEF }, "figure", elem_figure, ns_default, 0, EF_5_FLOW | EF_5_PALPABLE | EF_5_SECTION },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "filter", elem_filter },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "flowdiv", elem_flowdiv },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "flowimage", elem_flowimage },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "flowline", elem_flowline },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "flowpara", elem_flowpara },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "flowref", elem_flowref, ns_default, EP_CLOSED },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "flowregion", elem_flowregion },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "flowregionbreak", elem_flowregionbreak, ns_default, EP_CLOSED },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "flowregionexclude", elem_flowregionexclude },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "flowroot", elem_flowroot },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "flowspan", elem_flowspan },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "flowtref", elem_flowtref, ns_default, EP_CLOSED },
    { { HTML_3_0, HV_NOT4 | HV_NOT32 }, { HTML_UNDEF }, "fn", elem_fn, ns_default, 0, EF_3_BLOCK | EF_X_MATH | EF_M_CONTENT | EF_M_CONTINPRES },
    { { HTML_3_2, HV_DEPRECATED4, HE_SVG_OLD_H | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "font", elem_font, ns_default, 0, EF_SPECIAL | EF_4_SPECIAL },
    { { XHTML_1_0, 0, HE_SVG_1_1 |  HE_SVG_1_2 }, { HTML_UNDEF }, "font-face", elem_fontface },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "font-face-format", elem_fontfaceformat },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "font-face-name", elem_fontfacename, ns_default, EP_CLOSED },
    { { XHTML_1_0, 0, HE_SVG_1_1 |  HE_SVG_1_2 }, { HTML_UNDEF }, "font-face-src", elem_fontfacesrc },
    { { XHTML_1_0, 0, HE_SVG_1_1 |  HE_SVG_1_2 }, { HTML_UNDEF }, "font-face-uri", elem_fontfaceuri },
    { { HTML_5_0 }, { HTML_UNDEF }, "footer", elem_footer, ns_default, 0, EF_5_FLOW | EF_5_PALPABLE },
    { { HTML_PLUS }, { HTML_PLUS }, "footnote", elem_footnote, ns_default, 0, EF_MISC },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "forall", elem_forall, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_PLUS, HV_NOT2L1 | HV_NOTX2 }, { HTML_UNDEF }, "form", elem_form, ns_default, 0, EF_BLOK | EF_3_BLOCK | EF_32_FORM | EF_4_BLOCK | EF_5_FLOW | EF_5_PALPABLE },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "foreignobject", elem_foreignobject, ns_default, 0, EF_SVG_STR | EF_SVG2_GRAPH },
    { { HTML_4_0 }, { XHTML_1_1 }, "frame", elem_frame, ns_default, EP_CLOSED },
    { { HTML_4_0, HV_FRAMESET }, { HTML_4_01 }, "frameset", elem_frameset },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "g", elem_g, ns_default, 0, EF_S_G | EF_SVG_STR | EF_SVG_CONTAIN },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "gcd", elem_gcd, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "geq", elem_geq, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_SVG_1_1 |  HE_SVG_1_2 }, { HTML_UNDEF }, "glyph", elem_glyph, ns_default, 0, EF_SVG_CONTAIN },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "glyphref", elem_glyphref },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "gt", elem_gt, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_2_0 }, { XHTML_2_0 }, "h", elem_h, ns_default, 0, EF_HEAD },
    { { HTML_TAGS }, { HTML_UNDEF }, "h1", elem_h1, ns_default, 0, EF_HEAD | EF_4_BLOCK | EF_5_FLOW | EF_5_PALPABLE },
    { { HTML_TAGS }, { HTML_UNDEF }, "h2", elem_h2, ns_default, 0, EF_HEAD | EF_4_BLOCK | EF_5_FLOW | EF_5_PALPABLE },
    { { HTML_TAGS }, { HTML_UNDEF }, "h3", elem_h3, ns_default, 0, EF_HEAD | EF_4_BLOCK | EF_5_FLOW | EF_5_PALPABLE },
    { { HTML_TAGS }, { HTML_UNDEF }, "h4", elem_h4, ns_default, 0, EF_HEAD | EF_4_BLOCK | EF_5_FLOW | EF_5_PALPABLE },
    { { HTML_TAGS }, { HTML_UNDEF }, "h5", elem_h5, ns_default, 0, EF_HEAD | EF_4_BLOCK | EF_5_FLOW | EF_5_PALPABLE },
    { { HTML_TAGS }, { HTML_UNDEF }, "h6", elem_h6, ns_default, 0, EF_HEAD | EF_4_BLOCK | EF_5_FLOW | EF_5_PALPABLE },
    { { XHTML_1_1, 0, HE_SVG_1_2 | HE_SVG_X2 }, { HTML_UNDEF }, "handler", elem_handler, ns_default, EP_SIMPLE },
    { { HTML_3_0 }, { HTML_3_0 }, "hat", elem_hat, ns_default, 0, EF_3_MATHVC },
    { { HTML_1_0 }, { HTML_UNDEF }, "head", elem_head, ns_default, EP_LAZY },
    { { HTML_5_0 }, { HTML_UNDEF }, "header", elem_header, ns_default, 0, EF_5_FLOW | EF_5_PALPABLE },
    { { HTML_JUL20 }, { HTML_UNDEF }, "hgroup", elem_hgroup, ns_default, 0, EF_HEAD | EF_5_FLOW },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "hint", elem_hint, ns_default, EP_CLOSED, EF_SVG_DESC },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "hkern", elem_hkern, ns_default, EP_CLOSED | EP_UNCLOSEDSVG12 },
    { { HTML_TAGS, HV_DEPRECATED1 }, { HTML_1_0 }, "hp1", elem_hp1 },
    { { HTML_TAGS, HV_DEPRECATED1 }, { HTML_1_0 }, "hp2", elem_hp2 },
    { { HTML_TAGS, HV_DEPRECATED1 }, { HTML_1_0 }, "hp3", elem_hp3 },
    { { HTML_TAGS, HV_DEPRECATED1 }, { HTML_1_0 }, "hp4", elem_hp4 },
    { { HTML_TAGS, HV_DEPRECATED1 }, { HTML_1_0 }, "hp5", elem_hp5 },
    { { HTML_TAGS, HV_DEPRECATED1 }, { HTML_1_0 }, "hp6", elem_hp6 },
    { { HTML_1_0 }, { HTML_UNDEF }, "hr", elem_hr, ns_default, EP_CLOSED, EF_PRE | EF_BLOK | EF_3_BODY | EF_32_BLOCK | EF_4_BLOCK | EF_5_FLOW },
    { { HTML_1_0, HV_NOTPLUS }, { HTML_UNDEF }, "html", elem_html, ns_default, EP_TOP | EP_LAZY },
    { { HTML_PLUS }, { HTML_PLUS }, "htmlplus", elem_htmlplus, ns_default, EP_TOP | EP_LAZY },
    { { HTML_1_0 }, { HTML_UNDEF }, "i", elem_i, ns_default, 0, EF_EMPH | EF_FONT | EF_3_FONT | EF_32_FONT | EF_4_FONT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "ident", elem_ident, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_4_0 }, { HTML_UNDEF }, "iframe", elem_iframe, ns_default, 0, EF_4_SPECIAL | EF_5_FLOW | EF_5_PHRASE | EF_5_EMBEDDED | EF_5_INTERACTIVE | EF_5_PALPABLE | EF_SVG_STR | EF_SVG2_GRAPH },
    { { HTML_2_0, 0, HE_NETSCAPE }, { HTML_3_2 }, "ilayer", elem_ilayer },
    { { HTML_PLUS, HV_NOT2 | HV_NOT32, HE_SVG }, { HTML_UNDEF }, "image", elem_image, ns_default, EP_CLOSED | EP_4_OPEN | EP_5_OPEN, EF_TEXT | EF_S_G | EF_SVG_GRAPH | EF_SVG_STR | EF_SVG2_GRAPH },
    { { HTML_1_0 }, { HTML_UNDEF }, "img", elem_img, ns_default, EP_CLOSED | EP_X2_OPEN | EP_5_DYNAMIC, EF_TEXT  | EF_SPECIAL | EF_4_SPECIAL | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_EMBEDDED | EF_5_INTERACTIVE | EF_5_PALPABLE | EF_5_FORM },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "implies", elem_implies, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "in", elem_in, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_PLUS, HV_NOT2L1 | HV_NOTX2 }, { HTML_UNDEF }, "input", elem_input, ns_default, EP_CLOSED | EP_LAZY, EF_MISC | EF_4_FORM | EF_5_FLOW | EF_5_PHRASE | EF_5_INTERACTIVE | EF_5_PALPABLE | EF_5_FORM },
    { { HTML_3_0, HV_NOT32 }, { HTML_UNDEF }, "ins", elem_ins, ns_default, EP_5_TRANSPARENT, EF_3_MISC | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "int", elem_int, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "intersect", elem_intersect, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "interval", elem_interval, ns_default, 0, EF_M_CONTENT | EF_M_CONTINPRES },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "inverse", elem_inverse, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_TAGS, HV_DEPRECATED4 }, { XHTML_1_1 }, "isindex", elem_isindex, ns_default, EP_CLOSED, EF_32_BLOCK | EF_METADATA | EF_3_BLOCK | EF_4_BLOCK },
    { { HTML_PLUS, HV_NOT2 }, {3, 0 }, "item", elem_item, ns_default, EP_CLOSED },
    { { HTML_1_0 }, { HTML_UNDEF }, "kbd", elem_kbd, ns_default, 0, EF_EMPH | EF_PHRASE | EF_4_PHRASE | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_5_0 }, { HTML_5_1 }, "keygen", elem_keygen, ns_default, EP_CLOSED, EF_5_FLOW | EF_5_PHRASE | EF_5_INTERACTIVE | EF_5_PALPABLE | EF_5_FORM },
    { { HTML_PLUS, HV_NOT234 | HV_NOTX1 }, { XHTML_2_0 }, "l", elem_l, ns_default, EP_CLOSED | EP_X2_OPEN, EF_X2_TEXT },
    { { HTML_4_0 }, { HTML_UNDEF }, "label", elem_label, ns_default, 0, EF_4_FORM | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_INTERACTIVE | EF_5_PALPABLE },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "lambda", elem_lambda, ns_default, 0, EF_M_CONTENT | EF_M_CONTINPRES },
    { { HTML_3_0 }, { HTML_3_0 }, "lang", elem_lang, ns_default, 0, EF_3_MISC },
    { { HTML_2_0, 0, HE_NETSCAPE }, { HTML_3_2 }, "layer", elem_layer },
    { { HTML_3_0 }, { HTML_3_0 }, "left", elem_left, ns_default, EP_CLOSED },
    { { HTML_4_0 }, { HTML_UNDEF }, "legend", elem_legend },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "leq", elem_leq, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_3_0 }, { HTML_3_0 }, "lh", elem_lh },
    { { HTML_TAGS }, { HTML_UNDEF }, "li", elem_li, ns_default, EP_UNCLOSED1T, EF_X2_STRUCT | EF_X2_LIST },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "limit", elem_limit, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "line", elem_line, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_S_G | EF_SVG_SHAPE | EF_SVG_GRAPH | EF_SVG2_GRAPH },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "lineargradient", elem_lineargradient, ns_default, 0, EF_SVG_PSGRAD },
    { { HTML_1_0 }, { HTML_UNDEF }, "link", elem_link, ns_default, EP_CLOSED, EF_METADATA | EF_5_FLOW | EF_5_PHRASE },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "list", elem_list, ns_default, 0, EF_M_CONTENT | EF_M_CONTINPRES },
    { { XHTML_2_0, 0, HE_SVG_1_2 | HE_SVG_X2 }, { HTML_UNDEF }, "listener", elem_listener, ns_default, EP_CLOSED, EF_X2_STRUCT },
    { { HTML_TAGS, HV_DEPRECATED123 }, { HTML_3_2 }, "listing", elem_listing, ns_default, 0, EF_LIT },
    { { HTML_PLUS }, { HTML_PLUS }, "lit", elem_lit, ns_default, 0, EF_PARA },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "ln", elem_ln, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "loc", elem_loc },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "log", elem_log, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "logbase", elem_logbase, ns_default, 0, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "lowlimit", elem_lowlimit, ns_default, 0, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "lt", elem_lt, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "maction", elem_maction, ns_default, 0, EF_M_PRESINCONTENT },
    { { HTML_5_0 }, { HTML_UNDEF }, "main", elem_main, ns_default, 0, EF_5_FLOW | EF_5_PALPABLE },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "maligngroup", elem_maligngroup, ns_default, EP_CLOSED, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "malignmark", elem_malignmark, ns_default, EP_CLOSED, EF_M_PRESINCONTENT },
    { { HTML_2_0, HV_RFC_1980 | HV_NOT30  }, { HTML_UNDEF }, "map", elem_map, ns_default, EP_5_TRANSPARENT, EF_TEXT | EF_SPECIAL | EF_4_SPECIAL | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_PLUS }, { HTML_PLUS }, "margin", elem_margin, ns_default, 0, EF_MISC },
    { { HTML_5_0 }, { HTML_UNDEF }, "mark", elem_mark, ns_default, 0, EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE | EF_SVG_CONTAIN },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "marker", elem_marker, ns_default, 0, EF_SVG_CONTAIN },
    { { HTML_2_0, 0, HE_IE }, { HTML_3_2 }, "marquee", elem_marquee, ns_default, EP_CLOSED },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "mask", elem_mask },
    { { HTML_PLUS, HV_NOT2 | HV_NOT32 | HV_NOT4 }, { HTML_UNDEF }, "math", elem_math, ns_default, 0, EF_BLOK | EF_SPECIAL | EF_5_FLOW | EF_5_PHRASE | EF_5_EMBEDDED },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "matrix", elem_matrix, ns_default, 0, EF_M_CONTENT | EF_M_CONTINPRES },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "matrixrow", elem_matrixrow, ns_default, 0, EF_M_CONTENT | EF_M_CONTINPRES },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "max", elem_max, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mean", elem_mean, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "median", elem_median, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_TAGS, HV_DEPRECATED30 | HV_DEPRECATED4 | HV_NOTX2 | HV_NOT50 | HV_NOT52 | HV_NOT53 }, { HTML_UNDEF }, "menu", elem_menu, ns_default, EP_ONLYELEMENTS, EF_3_LIST | EF_LL | EF_LIST | EF_32_BLOCK | EF_4_BLOCK | EF_5_FLOW | EF_5_PALPABLE },
    { { HTML_5_1 }, { HTML_5_1 }, "menuitem", elem_menuitem, ns_default, EP_CLOSED },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "merror", elem_merror, ns_default, 0, EF_M_PRESINCONTENT },
    { { HTML_2_0 }, { HTML_UNDEF }, "meta", elem_meta, ns_default, EP_CLOSED | EP_X2_OPEN, EF_METADATA | EF_5_FLOW | EF_5_PHRASE },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 | HE_SVG_2_0 }, { HTML_UNDEF }, "metadata", elem_metadata, ns_default, 0, EF_SVG_DESC },
    { { HTML_5_0 }, { HTML_UNDEF }, "meter", elem_meter, ns_default, EP_SIMPLE, EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mfenced", elem_mfenced, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mfrac", elem_mfrac, ns_default, 0, EF_M_PRESINCONTENT },
    { { HTML_PLUS }, { HTML_PLUS }, "mh", elem_mh, ns_default, EP_SIMPLE },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mi", elem_mi, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "min", elem_min, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "minus", elem_minus, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "missing-glyph", elem_missingglyph, ns_default, 0, EF_SVG_CONTAIN },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mmultiscripts", elem_mmultiscripts, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mn", elem_mn, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mo", elem_mo, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mode", elem_mode, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "moment", elem_moment, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mover", elem_mover, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mpadded", elem_mpadded, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 | HE_SVG_2_0 }, { HTML_UNDEF }, "mpath", elem_mpath },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mphantom", elem_mphantom, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mprescripts", elem_mprescripts, ns_default, EP_CLOSED, EF_M_PRES },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mroot", elem_mroot, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mrow", elem_mrow, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "ms", elem_ms, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mspace", elem_mspace, ns_default, EP_CLOSED, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "msqrt", elem_msqrt, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mstyle", elem_mstyle, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "msub", elem_msub, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "msubsup", elem_msubsup, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "msup", elem_msup, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mtable", elem_mtable, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mtd", elem_mtd, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mtext", elem_mtext, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mtr", elem_mtr, ns_default, 0, EF_M_PRESINCONTENT },
    { { HTML_2_0, 0, HE_NETSCAPE }, { HTML_4_01 }, "multicol", elem_multicol },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "munder", elem_munder, ns_default, 0, EF_M_PRESINCONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "munderover", elem_munderover, ns_default, 0, EF_M_PRESINCONTENT },
    { { HTML_5_0 }, { HTML_UNDEF }, "nav", elem_nav, ns_default, 0, EF_5_FLOW | EF_5_SECTION | EF_5_PALPABLE },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "neq", elem_neq, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_TAGS, HV_DEPRECATED23 }, { HTML_3_0 }, "nextid", elem_nextid, ns_default, EP_CLOSED, EF_METADATA },
    { { XHTML_2_0 }, { XHTML_2_0 }, "nl", elem_nl, ns_default, 0, EF_X2_STRUCT | EF_X2_LIST }, // riffing; the XHTML2 spec is inconsistent re nl
    { { HTML_2_0, 0, HE_NETSCAPE }, { HTML_2_0 }, "nobr", elem_nobr, ns_default, 0, EF_EMPH },
    { { HTML_5_0, HV_DEPRECATED50 }, { HTML_5_0 }, "noembed", elem_noembed },
    { { HTML_4_0 }, { HTML_4_01 }, "noframes", elem_noframes, ns_default, 0, EF_4_BLOCK },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "none", elem_none, ns_default, EP_CLOSED, EF_M_PRES },
    { { HTML_4_0, HV_NOTX5 }, { HTML_UNDEF }, "noscript", elem_noscript, ns_default, EP_5_TRANSPARENT, EF_METADATA | EF_4_BLOCK | EF_5_FLOW | EF_5_PHRASE },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "not", elem_not, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_PLUS, HV_NOT2 }, { HTML_3_0 }, "note", elem_note, ns_default, 0, EF_BLOK | EF_3_BLOCK },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "notin", elem_notin, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "notprsubset", elem_notprsubset, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "notsubset", elem_notsubset, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_4_0 }, { HTML_UNDEF }, "object", elem_object, ns_default, EP_5_TRANSPARENT, EF_4_SPECIAL | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_EMBEDDED | EF_5_INTERACTIVE | EF_5_PALPABLE | EF_5_FORM },
    { { HTML_3_0 }, { HTML_3_0 }, "of", elem_of, ns_default, EP_CLOSED },
    { { HTML_1_0, HV_DEPRECATED30 }, { HTML_UNDEF }, "ol", elem_ol, ns_default, EP_ONLYELEMENTS | EP_5_DYNAMIC, EF_3_LIST | EF_LL | EF_LIST | EF_32_BLOCK | EF_4_BLOCK | EF_X2_LIST | EF_X2_STRUCT | EF_5_FLOW | EF_5_PALPABLE },
    { { HTML_PLUS }, { HTML_PLUS }, "online", elem_online, ns_default, 0, EF_EMPH },
    { { HTML_4_0, HV_NOTX2 }, { HTML_UNDEF }, "optgroup", elem_optgroup },
    { { HTML_PLUS, HV_NOT2L1 | HV_NOTX2 }, { HTML_UNDEF }, "option", elem_option },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "or", elem_or, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_5_0 }, { HTML_UNDEF }, "output", elem_output, ns_default, 0, EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE | EF_5_FORM },
    { { HTML_PLUS, HV_NOT2 }, { HTML_3_0 }, "over", elem_over, ns_default, EP_CLOSED },
    { { HTML_3_0 }, { HTML_3_0 }, "overlay", elem_overlay, ns_default, EP_CLOSED },
    { { HTML_TAGS }, { HTML_UNDEF }, "p", elem_p, ns_default, EP_UNCLOSED1T | EP_LAZY, EF_BODY | EF_TABLE | EF_PARA | EF_3_BLOCK | EF_32_BLOCK | EF_4_BLOCK | EF_X2_STRUCT | EF_5_FLOW | EF_5_PALPABLE },
    { { HTML_3_2 }, { HTML_UNDEF }, "param", elem_param, ns_default, EP_CLOSED },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "page", elem_page },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "pageset", elem_pageset },
    { { XHTML_1_0 }, { HTML_UNDEF }, "partialdiff", elem_partialdiff, ns_default, EP_CLOSED, EF_X_MATH },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "path", elem_path, ns_default, 0, EF_S_G | EF_SVG_GRAPH | EF_SVG_SHAPE | EF_SVG2_GRAPH },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "pattern", elem_pattern, ns_default, 0, EF_S_G | EF_SVG_CONTAIN | EF_SVG_PSGRAD },
    { { HTML_PLUS, HV_NOT2 }, { HTML_3_0 }, "person", elem_person, ns_default, 0, EF_EMPH | EF_3_MISC },
//    { { HTML_2_0 }, { HTML_UNDEF }, "php", elem_faux_php, ns_default, EP_IGNORE, EF_FAUX },
    { { HTML_5_1 }, { HTML_UNDEF }, "picture", elem_picture, ns_default, 0, EF_5_FLOW | EF_5_PHRASE | EF_5_EMBEDDED | EF_5_PALPABLE },
    { { HTML_TAGS, HV_DEPRECATED123 }, { HTML_3_2 }, "plaintext", elem_plaintext, ns_default, EP_CLOSED | EP_XMP },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "plus", elem_plus, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "polygon", elem_polygon, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_S_G | EF_SVG_SHAPE | EF_SVG_GRAPH | EF_SVG2_GRAPH },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "polyline", elem_polyline, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_S_G | EF_SVG_SHAPE | EF_SVG_GRAPH | EF_SVG2_GRAPH },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "power", elem_power, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_1_0, HV_DEPRECATED23 }, { HTML_UNDEF }, "pre", elem_pre, ns_default, 0, EF_BODY | EF_PARA | EF_3_BLOCK | EF_32_BLOCK | EF_4_BLOCK | EF_X2_STRUCT | EF_5_FLOW | EF_5_PALPABLE },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "prefetch", elem_prefetch },
    { { XHTML_2_0 }, { XHTML_2_0 }, "preventdefault", elem_preventdefault, ns_default, EP_CLOSED },
    { { HTML_PLUS }, { HTML_PLUS }, "printed", elem_printed, ns_default, 0, EF_EMPH },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "product", elem_product, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_5_0 }, { HTML_UNDEF }, "progress", elem_progress, ns_default, 0, EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "prototype", elem_prototype },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "prsubset", elem_prsubset, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_PLUS, HV_RFC_2070 | HV_NOT32 }, { HTML_UNDEF }, "q", elem_q, ns_default, 0, EF_TEXT | EF_EMPH | EF_3_MISC | EF_4_SPECIAL | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_PLUS }, { HTML_PLUS }, "quote", elem_quote, ns_default, 0, EF_BLOK },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "quotient", elem_quotient, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "radialgradient", elem_radialgradient, ns_default, 0, EF_SVG_PSGRAD },
    { { HTML_3_0 }, { HTML_3_0 }, "range", elem_range, ns_default, EP_CLOSED },
    { { XHTML_1_1 }, { HTML_5_3 }, "rb", elem_rb },
    { { XHTML_1_1 }, { XHTML_2_0 }, "rbc", elem_rbc },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "rect", elem_rect, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11, EF_S_G | EF_SVG_SHAPE | EF_SVG_GRAPH | EF_SVG2_GRAPH },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "refcontent", elem_refcontent, ns_default, 0, EF_SVG_DESC },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "reln", elem_reln, ns_default, 0, EF_M_CONTENT | EF_M_CONTINPRES },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "rem", elem_rem, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_PLUS }, { HTML_PLUS }, "removed", elem_removed, ns_default, 0, EF_EMPH },
    { { XHTML_2_0 }, { XHTML_2_0 }, "removeeventlistener", elem_removeeventlistener, ns_default, EP_CLOSED },
    { { HTML_PLUS }, { HTML_PLUS }, "render", elem_render, ns_default, EP_CLOSED, EF_MISC | EF_METADATA },
    { { HTML_3_0 }, { HTML_3_0 }, "right", elem_right, ns_default, EP_CLOSED },
    { { HTML_3_0, HV_NOT4 | HV_NOT32 }, { HTML_UNDEF }, "root", elem_root, ns_default, EP_CLOSED | EP_PRE_X_OPEN, EF_MATH | EF_M_CONTENT },
    { { HTML_3_0 }, { HTML_3_0 }, "row", elem_row },
    { { XHTML_1_1 }, { HTML_UNDEF }, "rp", elem_rp },
    { { XHTML_1_1 }, { HTML_UNDEF }, "rt", elem_rt },
    { { XHTML_1_1 }, { HTML_5_3 }, "rtc", elem_rtc },
    { { XHTML_1_1 }, { HTML_UNDEF }, "ruby", elem_ruby, ns_default, 0, EF_4_PHRASE | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_PLUS, HV_NOT2 | HV_NOT32 | HV_DEPRECATED4 | HV_NOTXX }, { HTML_UNDEF }, "s", elem_s, ns_default, 0, EF_EMPH | EF_3_FONT | EF_4_FONT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_1_0 }, { HTML_UNDEF }, "samp", elem_samp, ns_default, 0, EF_EMPH | EF_PHRASE | EF_4_PHRASE | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_3_2 }, { HTML_UNDEF }, "script", elem_script, ns_default, EP_SIMPLE, EF_METADATA | EF_SPECIAL | EF_4_SPECIAL | EF_X2_STRUCT | EF_5_FLOW | EF_5_PHRASE | EF_5_SCRIPT | EF_SVG_STR },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "sdev", elem_sdev, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "sec", elem_sec, ns_default, 0, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "sech", elem_sech, ns_default, 0, EF_M_CONTENT },
    { { XHTML_2_0 }, { HTML_UNDEF }, "section", elem_section, ns_default, 0, EF_X2_STRUCT | EF_5_FLOW | EF_5_SECTION | EF_5_PALPABLE },
    { { HTML_PLUS, HV_NOT2L1 | HV_NOTX2 }, { HTML_UNDEF }, "select", elem_select, ns_default, 0, EF_MISC | EF_32_FORM | EF_4_FORM | EF_5_FLOW | EF_5_PHRASE | EF_5_INTERACTIVE | EF_5_PALPABLE | EF_5_FORM },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "selector", elem_selector, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "semantics", elem_semantics, ns_default, 0, EF_M_CONTENT | EF_M_CONTINPRES },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "sep", elem_sep, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_2_0 }, { XHTML_2_0 }, "separator", elem_separator, ns_default, EP_CLOSED, EF_X2_STRUCT },
    { { XHTML_1_0, 0, HE_MATH_1 | HE_SVG_1_1 | HE_SVG_1_2 | HE_SVG_2_0 }, { HTML_UNDEF }, "set", elem_set, ns_default, EP_CLOSED, EF_M_CONTENT | EF_M_CONTINPRES | EF_SVG_ANIM },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "setdiff", elem_setdiff, ns_default, 0, EF_M_CONTENT },
    { { HTML_5_0, 0, HE_WEBCOMP }, { HTML_UNDEF }, "shadow", elem_shadow },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "sin", elem_sin, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "sinh", elem_sinh, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_JUL20 }, { HTML_UNDEF }, "slot", elem_slot, ns_default, EP_5_TRANSPARENT, EF_5_FLOW | EF_5_PHRASE },
    { { HTML_3_0 }, { HTML_UNDEF }, "small", elem_small, ns_default, 0, EF_3_FONT | EF_32_FONT | EF_4_FONT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "solidcolor", elem_solidcolour },
    { { HTML_5_0 }, { HTML_UNDEF }, "source", elem_source, ns_default, EP_CLOSED },
    { { HTML_2_0, 0, HE_NETSCAPE }, { HTML_4_01 }, "spacer", elem_spacer, ns_default, EP_SIMPLE },
    { { HTML_2_0, HV_RFC_2070 | HV_NOT3 }, { HTML_UNDEF }, "span", elem_span, ns_default, 0, EF_TEXT | EF_PRE | EF_4_SPECIAL | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_3_0 }, { HTML_3_0 }, "spot", elem_spot, ns_default, EP_CLOSED },
    { { HTML_3_0 }, { HTML_3_0 }, "sqrt", elem_sqrt, ns_default, 0, EF_MATH },
//    { { HTML_2_0 }, { HTML_UNDEF }, "ssi", elem_faux_ssi, ns_default, EP_IGNORE, EF_FAUX },
    { { XHTML_2_0 }, { XHTML_2_0 }, "standby", elem_standby },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "stop", elem_stop, ns_default, EP_CLOSED | EP_UNCLOSEDSVG11 },
    { { XHTML_2_0 }, { XHTML_2_0 }, "stoppropagation", elem_stoppropagation, ns_default, EP_CLOSED },
    { { HTML_3_2, HV_DEPRECATED4 }, { HTML_4_01 }, "strike", elem_strike, ns_default, 0, EF_32_FONT | EF_4_FONT },
    { { HTML_1_0 }, { HTML_UNDEF }, "strong", elem_strong, ns_default, 0, EF_EMPH | EF_PHRASE | EF_4_PHRASE | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_3_0 }, { HTML_UNDEF }, "style", elem_style, ns_default, EP_SIMPLE, EF_METADATA | EF_X2_STRUCT | EF_5_FLOW },
    { { HTML_PLUS, HV_RFC_2070 }, { HTML_UNDEF }, "sub", elem_sub, ns_default, 0, EF_TEXT | EF_MATH | EF_EMPH | EF_3_TEXT | EF_32_FONT | EF_4_SPECIAL | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "subset", elem_subset, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "sum", elem_sum, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_2_0, HV_NOT50 }, { HTML_UNDEF }, "summary", elem_summary },
    { { HTML_PLUS, HV_RFC_2070 }, { HTML_UNDEF }, "sup", elem_sup, ns_default, 0, EF_TEXT | EF_MATH | EF_EMPH | EF_3_TEXT | EF_32_FONT | EF_4_SPECIAL | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "svg", elem_svg, ns_default, 0, EF_4_SPECIAL | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_EMBEDDED | EF_S_G | EF_SVG_STR | EF_SVG_CONTAIN },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "switch", elem_switch, ns_default, 0, EF_S_G | EF_SVG_CONTAIN },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "symbol", elem_symbol, ns_default, 0, EF_SVG_STR | EF_SVG_CONTAIN },
    { { HTML_3_0 }, { HTML_3_0 }, "t", elem_t, ns_default, 0, EF_3_MATHVC },
    { { HTML_PLUS, HV_NOT2 | HV_NOT32 | HV_NOT4 }, { HTML_UNDEF }, "tab", elem_tab, ns_default, EP_CLOSED, EF_SPECIAL | EF_X_MATH },
    { { HTML_PLUS, HV_RFC_1942 }, { HTML_UNDEF }, "table", elem_table, ns_default, 0, EF_BLOK | EF_3_BLOCK | EF_32_BLOCK | EF_4_BLOCK | EF_X2_STRUCT | EF_5_FLOW | EF_5_PALPABLE },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "tan", elem_tan, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "tanh", elem_tanh, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_2_0, HV_RFC_1942 | HV_NOT3 }, { HTML_UNDEF }, "tbody", elem_tbody },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "tbreak", elem_tbreak, ns_default, EP_CLOSED },
    { { HTML_PLUS, HV_RFC_1942 }, { HTML_UNDEF }, "td", elem_td, ns_default, EP_LAZY | EP_UNCLOSEDPLUS },
    { { HTML_5_0 }, { HTML_UNDEF }, "template", elem_template, ns_default, 0, EF_METADATA | EF_5_FLOW | EF_5_PHRASE | EF_5_SCRIPT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "tendsto", elem_tendsto, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_3_0, HV_NOT32, HE_SVG }, { HTML_UNDEF }, "text", elem_text, ns_default, 0, EF_S_G | EF_SVG_GRAPH | EF_SVG_TEXT | EF_SVG2_GRAPH },
    { { HTML_PLUS, HV_NOT2L1 | HV_NOTX2 | HE_SVG_1_2 }, { HTML_UNDEF }, "textarea", elem_textarea, ns_default, 0, EF_MISC | EF_32_FORM | EF_4_FORM | EF_5_FLOW | EF_5_PHRASE | EF_5_INTERACTIVE | EF_5_PALPABLE | EF_5_FORM },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "textpath", elem_textpath, ns_default, 0, EF_SVG_TEXT | EF_SVG2_GRAPH },
    { { HTML_2_0, HV_RFC_1942 | HV_NOT3 }, { HTML_UNDEF }, "tfoot", elem_tfoot },
    { { HTML_PLUS, HV_RFC_1942 }, { HTML_UNDEF }, "th", elem_th, ns_default, EP_LAZY | EP_UNCLOSEDPLUS },
    { { HTML_2_0, HV_RFC_1942 | HV_NOT3 }, { HTML_UNDEF }, "thead", elem_thead },
    { { HTML_3_0 }, { HTML_3_0 }, "tilde", elem_tilde, ns_default, 0, EF_3_MATHVC },
    { { HTML_5_0 }, { HTML_UNDEF }, "time", elem_time, ns_default, 0, EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "times", elem_times, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { HTML_TAGS }, { HTML_UNDEF }, "title", elem_title, ns_default, EP_SIMPLE, EF_METADATA | EF_X2_STRUCT | EF_X2_LIST | EF_X2_TEXT | EF_S_G | EF_SVG_DESC },
    { { HTML_PLUS, HV_RFC_1942 }, { HTML_UNDEF }, "tr", elem_tr, ns_default, EP_UNCLOSEDPLUS },
    { { HTML_5_0 }, { HTML_UNDEF }, "track", elem_track, ns_default, EP_CLOSED },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "traitdef", elem_traitdef, ns_default, EP_CLOSED },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "transition", elem_transition, ns_default, EP_CLOSED },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "transformer", elem_transformer },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "transpose", elem_transpose, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "tref", elem_tref, ns_default, 0, EF_SVG_TEXT },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "tspan", elem_tspan, ns_default, 0, EF_SVG_TEXT | EF_SVG2_GRAPH },
    { { HTML_1_0 }, { XHTML_1_1 }, "tt", elem_tt, ns_default, 0, EF_EMPH | EF_FONT | EF_3_FONT | EF_32_FONT | EF_4_FONT },
    { { HTML_1_0, HV_DEPRECATED4 | HV_NOTX2 }, { HTML_UNDEF }, "u", elem_u, ns_default, 0, EF_EMPH | EF_3_FONT | EF_32_FONT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { HTML_TAGS, HV_DEPRECATED30 }, { HTML_UNDEF }, "ul", elem_ul, ns_default, EP_ONLYELEMENTS | EP_5_DYNAMIC, EF_3_LIST | EF_LL | EF_LIST | EF_32_BLOCK | EF_4_BLOCK | EF_X2_STRUCT | EF_X2_LIST | EF_5_FLOW | EF_5_PALPABLE },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "union", elem_union, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "uplimit", elem_uplimit, ns_default, 0, EF_M_CONTENT },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "use", elem_use, ns_default, 0, EF_S_G | EF_SVG_STR | EF_SVG_GRAPH | EF_SVG2_GRAPH },
    { { HTML_1_0 }, { HTML_UNDEF }, "var", elem_var, ns_default, 0, EF_EMPH | EF_PHRASE | EF_4_PHRASE | EF_X2_TEXT | EF_5_FLOW | EF_5_PHRASE | EF_5_PALPABLE },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "variance", elem_variance, ns_default, EP_CLOSED, EF_M_CONTENT },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "veaffine", elem_veaffine, ns_default, EP_CLOSED },
    { { HTML_3_0 }, { HTML_3_0 }, "vec", elem_vec, ns_default, 0, EF_3_MATHVC },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "vector", elem_vector, ns_default, 0, EF_M_CONTINPRES },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "vectoreffect", elem_vectoreffect },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "veexclude", elem_veexclude, ns_default, EP_CLOSED },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "vefill", elem_vefill, ns_default, EP_CLOSED },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "veintersect", elem_veintersect, ns_default, EP_CLOSED },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "vejoin", elem_vejoin, ns_default, EP_CLOSED },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "vemarker", elem_vemarker, ns_default, EP_CLOSED },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "vemarkerpath", elem_vemarkerpath, ns_default, EP_CLOSED },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "vepath", elem_vepath },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "vepathref", elem_vepathref, ns_default, EP_CLOSED },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "vereverse", elem_vereverse, ns_default, EP_CLOSED },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "vesetback", elem_vesetback, ns_default, EP_CLOSED },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "vestroke", elem_vestroke, ns_default, EP_CLOSED },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "vestrokepath", elem_vestrokepath, ns_default, EP_CLOSED },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "veunion", elem_veunion, ns_default, EP_CLOSED },
    { { HTML_5_0 }, { HTML_UNDEF }, "video", elem_video, ns_default, EP_5_TRANSPARENT, EF_5_FLOW | EF_5_PHRASE | EF_5_EMBEDDED | EF_5_INTERACTIVE | EF_5_PALPABLE | EF_SVG_STR | EF_SVG2_GRAPH },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "view", elem_view },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "vkern", elem_vkern, ns_default, EP_CLOSED },
    { { HTML_2_0, HV_NOT324XX }, { HTML_UNDEF }, "wbr", elem_wbr, ns_default, 0, EF_EMPH | EP_CLOSED | EF_5_FLOW | EF_5_PHRASE },
    { { HTML_5_0 }, { HTML_UNDEF }, "webmention", elem_webmention },
    { { XHTML_1_1, 0, HE_SVG_1_2_FULL }, { HTML_UNDEF }, "xa", elem_xa },
    { { HTML_2_0, 0, HE_IE }, { HTML_4_01 }, "xml", elem_xml, ns_default, EP_SIMPLE },
    { { HTML_TAGS, HV_DEPRECATED123 }, { HTML_3_2 }, "xmp", elem_xmp, ns_default, EP_SIMPLE | EP_XMP, EF_LIT },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "xor", elem_xor, ns_default, EP_CLOSED, EF_M_CONTENT }
};

e_element max_tag = last_element_tag;

void elem::init (nitpick& nits)
{   symbol::init (nits, elem_symbol_table, sizeof (elem_symbol_table) / sizeof (symbol_entry < e_element >), true); }

bool elem::parse (nitpick& nits, const html_version& v, const ::std::string& x)
{   assert (! x.empty ());
    ::std::string el (x);
    ns (examine_namespace (nits, v, el));
    if (el.empty ()) return false;
    if (symbol < e_element > :: parse (nits, v, el, ns ())) return true;
    check_spelling (nits, v, el);
    return false; }

elem :: elem (nitpick& nits, const html_version& v, const ::std::string& x)
{   parse (nits, v, x); }

bool elem::is_unclosed (const html_version& v) const
{   if (v.unknown ()) return false;
    if ((flags () & (EP_IGNORE | EP_CLOSED)) != 0) return false;
    if (((flags () & EP_UNCLOSEDSVG11) == EP_UNCLOSEDSVG11) && (v.svg () != sv_1_0)) return true;
    if (((flags () & EP_UNCLOSEDSVG12) == EP_UNCLOSEDSVG12) && ((v.svg () == sv_1_1) || (v.svg () == sv_1_2_full))) return true;
    switch (v.major ())
    {   case 0 : return ((flags () & EP_UNCLOSEDTAGS) == EP_UNCLOSEDTAGS);
        case 1 : if (v.minor () == 0) return ((flags () & EP_UNCLOSED1) == EP_UNCLOSED1);
                 return ((flags () & EP_UNCLOSEDPLUS) == EP_UNCLOSEDPLUS);
        case 2 : return ((flags () & EP_UNCLOSED2) == EP_UNCLOSED2);
        default : break; }
    return false; }

bool elem::is_lazy (const html_version& v) const
{   if ((categories () & EF_DOCUMENT) == EF_DOCUMENT) return false;
    if ((flags () & EP_IGNORE) != 0) return true;
    switch (v.major ())
    {   case 0 : return false;
        case 1 : if (v.minor () == 1)
                    return ((flags () & (EP_LAZY)) | (categories () & (EF_EMPH))) != 0;
                 return false; }
    return false; }

bool elem::is_closed (const html_version& v) const
{   if ((flags () & EP_CLOSED) == 0) return false;
    switch (v.major ())
    {   case 0 :
        case 1 :
        case 2 :
        case 3 : return ((flags () & EP_PRE_X_OPEN) == 0);
        case 4 :
            if ((flags () & EP_4_OPEN) != 0) return false;
            switch (v.minor ())
            {   case 0 :
                case 1 : return ((flags () & EP_PRE_X_OPEN) == 0);
                case 4 : return ((flags () & EP_X2_OPEN) == 0);
                default : break; }
            break;
        default : return ((flags () & EP_5_OPEN) == 0); }
    return true; }

bool elem::is_transparent (const html_version& v) const
{   if (v.major () < 5) return false;
    return ((flags () & EP_5_TRANSPARENT) == EP_5_TRANSPARENT); }
