/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "standard.h"
#include "context.h"
#include "crosslink.h"
#include "schema_type.h"
#include "schema_structure.h"
#include "schema_property.h"
#include "schema_hierarchy.h"
#include "type.h"

struct property_gen
{   schema_version from_;
    schema_version to_;
    const char* name_ = nullptr;
    e_schema_property prop_;
    e_type field_type_ = t_generic;
    e_schema field_schema_ = sch_context;
    uint32_t flags_ = 0; };

#define SP_VALUE_TYPENAME   0x00000001

property_gen gentab [] =
{   { { 0, 0 }, { 0, 0 }, nullptr, sp_context, t_unknown },

    { { 2, 0 }, { 0, 0 }, "about", sp_about, t_schema, sch_thing },
    { { 3, 5 }, { 0, 0 }, "abridged", sp_abridged, t_schema, sch_boolean },
    { { 3, 5 }, { 0, 0 }, "abridged", sp_abridged, t_bool },
    { { 4, 0 }, { 0, 0 }, "abstract", sp_abstract, t_schema, sch_text },
    { { 4, 0 }, { 0, 0 }, "abstract", sp_abstract, t_text },
    { { 2, 0 }, { 0, 0 }, "accelerationTime", sp_accelerationtime, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "acceptedAnswer", sp_acceptedanswer, t_schema, sch_answer },
    { { 3, 4 }, { 0, 0 }, "acceptedAnswer", sp_acceptedanswer, t_schema, sch_itemlist },
    { { 2, 0 }, { 0, 0 }, "acceptedOffer", sp_acceptedoffer, t_schema, sch_offer },
    { { 3, 0 }, { 0, 0 }, "acceptedPaymentMethod", sp_acceptedpaymentmethod, t_schema, sch_loanorcredit },
    { { 2, 0 }, { 0, 0 }, "acceptedPaymentMethod", sp_acceptedpaymentmethod, t_schema, sch_paymentmethod },
    { { 2, 0 }, { 0, 0 }, "acceptsReservations", sp_acceptsreservations, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "acceptsReservations", sp_acceptsreservations, t_text },
    { { 2, 0 }, { 0, 0 }, "acceptsReservations", sp_acceptsreservations, t_schema, sch_boolean },
    { { 2, 0 }, { 0, 0 }, "acceptsReservations", sp_acceptsreservations, t_bool },
    { { 2, 0 }, { 0, 0 }, "acceptsReservations", sp_acceptsreservations, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "acceptsReservations", sp_acceptsreservations, t_url },
    { { 2, 0 }, { 0, 0 }, "accessCode", sp_accesscode, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "accessCode", sp_accesscode, t_text },
    { { 3, 0 }, { 0, 0 }, "accessMode", sp_accessmode, t_schema, sch_text },
    { { 3, 0 }, { 0, 0 }, "accessMode", sp_accessmode, t_text },
    { { 3, 8 }, { 0, 0 }, "accessModeSufficient", sp_accessmodesufficient, t_schema, sch_itemlist },
    { { 3, 0 }, { 3, 7 }, "accessModeSufficient", sp_accessmodesufficient, t_schema, sch_text },
    { { 3, 0 }, { 3, 7 }, "accessModeSufficient", sp_accessmodesufficient, t_text },
    { { 2, 0 }, { 0, 0 }, "accessibilityAPI", sp_accessibilityapi, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "accessibilityAPI", sp_accessibilityapi, t_text },
    { { 2, 0 }, { 0, 0 }, "accessibilityControl", sp_accessibilitycontrol, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "accessibilityControl", sp_accessibilitycontrol, t_text },
    { { 2, 0 }, { 0, 0 }, "accessibilityFeature", sp_accessibilityfeature, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "accessibilityFeature", sp_accessibilityfeature, t_text },
    { { 2, 0 }, { 0, 0 }, "accessibilityHazard", sp_accessibilityhazard, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "accessibilityHazard", sp_accessibilityhazard, t_text },
    { { 2, 0 }, { 0, 0 }, "accessibilitySummary", sp_accessibilitysummary, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "accessibilitySummary", sp_accessibilitysummary, t_text },
    { { 5, 0 }, { 0, 0 }, "accommodationCategory", sp_accommodationcategory, t_schema, sch_text },
    { { 5, 0 }, { 0, 0 }, "accommodationCategory", sp_accommodationcategory, t_text },
    { { 6, 0 }, { 0, 0 }, "accommodationFloorPlan", sp_accommodationfloorplan, t_schema, sch_floorplan },
    { { 2, 0 }, { 0, 0 }, "accountId", sp_accountid, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "accountId", sp_accountid, t_text },
    { { 3, 5 }, { 0, 0 }, "accountMinimumInflow", sp_accountminimuminflow, t_schema, sch_monetaryamount },
    { { 3, 5 }, { 0, 0 }, "accountOverdraftLimit", sp_accountoverdraftlimit, t_schema, sch_monetaryamount },
    { { 2, 0 }, { 0, 0 }, "accountablePerson", sp_accountableperson, t_schema, sch_person },
    { { 7, 0 }, { 0, 0 }, "acquireLicensePage", sp_acquirelicensepage, t_schema, sch_creativework },
    { { 7, 0 }, { 0, 0 }, "acquireLicensePage", sp_acquirelicensepage, t_schema, sch_url },
    { { 7, 0 }, { 0, 0 }, "acquireLicensePage", sp_acquirelicensepage, t_url },
    { { 2, 0 }, { 0, 0 }, "acquiredFrom", sp_acquiredfrom, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "acquiredFrom", sp_acquiredfrom, t_schema, sch_person },
    { { 3, 5 }, { 0, 0 }, "acrissCode", sp_acrisscode, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "acrissCode", sp_acrisscode, t_text },
    { { 3, 5 }, { 6, 0 }, "action", sp_action, t_schema, sch_text },
    { { 3, 5 }, { 6, 0 }, "action", sp_action, t_text },
    { { 3, 5 }, { 0, 0 }, "actionAccessibilityRequirement", sp_actionaccessibilityrequirement, t_schema, sch_actionaccessspecification },
    { { 2, 0 }, { 0, 0 }, "actionApplication", sp_actionapplication, t_schema, sch_softwareapplication },
    { { 2, 0 }, { 0, 0 }, "actionOption", sp_actionoption, t_schema, sch_thing },
    { { 2, 0 }, { 0, 0 }, "actionOption", sp_actionoption, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "actionOption", sp_actionoption, t_text },
    { { 2, 2 }, { 0, 0 }, "actionPlatform", sp_actionplatform, t_schema, sch_text },
    { { 2, 2 }, { 0, 0 }, "actionPlatform", sp_actionplatform, t_text },
    { { 2, 2 }, { 0, 0 }, "actionPlatform", sp_actionplatform, t_schema, sch_url },
    { { 2, 2 }, { 0, 0 }, "actionPlatform", sp_actionplatform, t_url },
    { { 2, 0 }, { 0, 0 }, "actionStatus", sp_actionstatus, t_schema, sch_actionstatustype },
    { { 3, 5 }, { 0, 0 }, "actionableFeedbackPolicy", sp_actionablefeedbackpolicy, t_schema, sch_creativework },
    { { 3, 5 }, { 0, 0 }, "actionableFeedbackPolicy", sp_actionablefeedbackpolicy, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "actionableFeedbackPolicy", sp_actionablefeedbackpolicy, t_url },
    { { 2, 0 }, { 0, 0 }, "activeIngredient", sp_activeingredient, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "activeIngredient", sp_activeingredient, t_text },
    { { 2, 0 }, { 0, 0 }, "activityDuration", sp_activityduration, t_schema, sch_duration },
    { { 2, 0 }, { 0, 0 }, "activityDuration", sp_activityduration, t_duration },
    { { 3, 5 }, { 0, 0 }, "activityDuration", sp_activityduration, t_schema, sch_quantitativevalue },
    { { 3, 5 }, { 0, 0 }, "activityFrequency", sp_activityfrequency, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "activityFrequency", sp_activityfrequency, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "activityFrequency", sp_activityfrequency, t_text },
    { { 2, 0 }, { 0, 0 }, "actor", sp_actor, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "addOn", sp_addon, t_schema, sch_offer },
    { { 2, 0 }, { 0, 0 }, "additionalName", sp_additionalname, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "additionalName", sp_additionalname, t_text },
    { { 2, 0 }, { 0, 0 }, "additionalNumberOfGuests", sp_additionalnumberofguests, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "additionalProperty", sp_additionalproperty, t_schema, sch_propertyvalue },
    { { 2, 0 }, { 0, 0 }, "additionalType", sp_additionaltype, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "additionalType", sp_additionaltype, t_url },
    { { 2, 0 }, { 0, 0 }, "additionalVariable", sp_additionalvariable, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "additionalVariable", sp_additionalvariable, t_text },
    { { 2, 0 }, { 0, 0 }, "address", sp_address, t_schema, sch_postaladdress },
    { { 2, 0 }, { 0, 0 }, "address", sp_address, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "address", sp_address, t_text },
    { { 2, 0 }, { 0, 0 }, "addressCountry", sp_addresscountry, t_schema, sch_country },
    { { 2, 2 }, { 0, 0 }, "addressCountry", sp_addresscountry, t_schema, sch_text },
    { { 2, 2 }, { 0, 0 }, "addressCountry", sp_addresscountry, t_text },
    { { 2, 0 }, { 0, 0 }, "addressLocality", sp_addresslocality, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "addressLocality", sp_addresslocality, t_text },
    { { 2, 0 }, { 0, 0 }, "addressRegion", sp_addressregion, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "addressRegion", sp_addressregion, t_text },
    { { 2, 0 }, { 0, 0 }, "administrationRoute", sp_administrationroute, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "administrationRoute", sp_administrationroute, t_text },
    { { 2, 0 }, { 0, 0 }, "advanceBookingRequirement", sp_advancebookingrequirement, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "adverseOutcome", sp_adverseoutcome, t_schema, sch_medicalentity },
    { { 2, 0 }, { 0, 0 }, "affectedBy", sp_affectedby, t_schema, sch_drug },
    { { 2, 0 }, { 0, 0 }, "affiliation", sp_affiliation, t_schema, sch_organisation },
    { { 3, 3 }, { 0, 0 }, "afterMedia", sp_aftermedia, t_schema, sch_mediaobject },
    { { 3, 4 }, { 0, 0 }, "afterMedia", sp_aftermedia, t_schema, sch_url },
    { { 3, 4 }, { 0, 0 }, "afterMedia", sp_aftermedia, t_url },
    { { 2, 0 }, { 0, 0 }, "agent", sp_agent, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "agent", sp_agent, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "aggregateRating", sp_aggregaterating, t_schema, sch_aggregaterating },
    { { 2, 0 }, { 0, 0 }, "aircraft", sp_aircraft, t_schema, sch_vehicle },
    { { 2, 0 }, { 0, 0 }, "aircraft", sp_aircraft, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "aircraft", sp_aircraft, t_text },
    { { 2, 0 }, { 0, 0 }, "album", sp_album, t_schema, sch_musicalbum },
    { { 2, 0 }, { 0, 0 }, "albumProductionType", sp_albumproductiontype, t_schema, sch_musicalbumproductiontype },
    { { 2, 0 }, { 0, 0 }, "albumRelease", sp_albumrelease, t_schema, sch_musicrelease },
    { { 2, 0 }, { 0, 0 }, "albumReleaseType", sp_albumreleasetype, t_schema, sch_musicalbumreleasetype },
    { { 2, 0 }, { 0, 0 }, "alcoholWarning", sp_alcoholwarning, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "alcoholWarning", sp_alcoholwarning, t_text },
    { { 2, 0 }, { 0, 0 }, "algorithm", sp_algorithm, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "algorithm", sp_algorithm, t_text },
    { { 2, 0 }, { 0, 0 }, "alignmentType", sp_alignmenttype, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "alignmentType", sp_alignmenttype, t_text },
    { { 2, 0 }, { 0, 0 }, "alternateName", sp_alternatename, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "alternateName", sp_alternatename, t_text },
    { { 2, 0 }, { 0, 0 }, "alternativeHeadline", sp_alternativeheadline, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "alternativeHeadline", sp_alternativeheadline, t_text },
    { { 2, 0 }, { 0, 0 }, "alumni", sp_alumni, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "alumniOf", sp_alumniof, t_schema, sch_educationalorganisation },
    { { 2, 2 }, { 0, 0 }, "alumniOf", sp_alumniof, t_schema, sch_organisation },
    { { 3, 1 }, { 0, 0 }, "amenityFeature", sp_amenityfeature, t_schema, sch_locationfeaturespecification },
    { { 2, 0 }, { 0, 0 }, "amount", sp_amount, t_schema, sch_float },
    { { 2, 0 }, { 0, 0 }, "amount", sp_amount, t_fixedpoint },
    { { 3, 0 }, { 0, 0 }, "amount", sp_amount, t_schema, sch_monetaryamount },
    { { 2, 0 }, { 0, 0 }, "amountOfThisGood", sp_amountofthisgood, t_schema, sch_float },
    { { 2, 0 }, { 0, 0 }, "amountOfThisGood", sp_amountofthisgood, t_fixedpoint },
    { { 7, 2 }, { 0, 0 }, "announcementLocation", sp_announcementlocation, t_schema, sch_civicstructure },
    { { 7, 2 }, { 0, 0 }, "announcementLocation", sp_announcementlocation, t_schema, sch_localbusiness },
    { { 3, 0 }, { 0, 0 }, "annualpercentagerate", sp_annualpercentagerate, t_schema, sch_quantitativevalue },
    { { 3, 0 }, { 0, 0 }, "annualpercentagerate", sp_annualpercentagerate, t_schema, sch_float },
    { { 3, 0 }, { 0, 0 }, "annualpercentagerate", sp_annualpercentagerate, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "answerCount", sp_answercount, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "answerCount", sp_answercount, t_integer },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "antagonist", sp_antagonist, t_schema, sch_muscle },
    { { 3, 5 }, { 0, 0 }, "appearance", sp_appearance, t_schema, sch_creativework },
    { { 2, 0 }, { 0, 0 }, "applicableLocation", sp_applicablelocation, t_schema, sch_administrativearea },
    { { 6, 0 }, { 0, 0 }, "applicantContact", sp_applicantcontact, t_schema, sch_contactpoint },
    { { 3, 5 }, { 0, 0 }, "applicantLocationRequirements", sp_applicantlocationrequirements, t_schema, sch_administrativearea },
    { { 2, 0 }, { 0, 0 }, "applicationCategory", sp_applicationcategory, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "applicationCategory", sp_applicationcategory, t_text },
    { { 2, 0 }, { 0, 0 }, "applicationCategory", sp_applicationcategory, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "applicationCategory", sp_applicationcategory, t_url },
    { { 6, 0 }, { 0, 0 }, "applicationDeadline", sp_applicationdeadline, t_schema, sch_date },
    { { 6, 0 }, { 0, 0 }, "applicationDeadline", sp_applicationdeadline, t_just_date },
    { { 6, 0 }, { 0, 0 }, "applicationStartDate", sp_applicationstartdate, t_schema, sch_date },
    { { 6, 0 }, { 0, 0 }, "applicationStartDate", sp_applicationstartdate, t_just_date },
    { { 2, 0 }, { 0, 0 }, "applicationSubCategory", sp_applicationsubcategory, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "applicationSubCategory", sp_applicationsubcategory, t_text },
    { { 2, 0 }, { 0, 0 }, "applicationSubCategory", sp_applicationsubcategory, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "applicationSubCategory", sp_applicationsubcategory, t_url },
    { { 2, 0 }, { 0, 0 }, "applicationSuite", sp_applicationsuite, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "applicationSuite", sp_applicationsuite, t_text },
    { { 2, 0 }, { 0, 0 }, "appliesToDeliveryMethod", sp_appliestodeliverymethod, t_schema, sch_deliverymethod },
    { { 2, 0 }, { 0, 0 }, "appliesToPaymentMethod", sp_appliestopaymentmethod, t_schema, sch_paymentmethod },
    { { 3, 5 }, { 0, 0 }, "archiveHeld", sp_archiveheld, t_schema, sch_archivecomponent },
    { { 2, 0 }, { 0, 0 }, "areaServed", sp_areaserved, t_schema, sch_administrativearea },
    { { 3, 0 }, { 0, 0 }, "areaServed", sp_areaserved, t_schema, sch_geoshape },
    { { 3, 0 }, { 0, 0 }, "areaServed", sp_areaserved, t_schema, sch_place },
    { { 3, 0 }, { 0, 0 }, "areaServed", sp_areaserved, t_schema, sch_text },
    { { 3, 0 }, { 0, 0 }, "areaServed", sp_areaserved, t_text },
    { { 2, 0 }, { 0, 0 }, "arrivalAirport", sp_arrivalairport, t_schema, sch_airport },
    { { 9, 0 }, { 0, 0 }, "arrivalBoatTerminal", sp_arrivalboatterminal, t_schema, sch_boatterminal },
    { { 2, 0 }, { 0, 0 }, "arrivalBusStop", sp_arrivalbusstop, t_schema, sch_busstation },
    { { 2, 0 }, { 0, 0 }, "arrivalBusStop", sp_arrivalbusstop, t_schema, sch_busstop },
    { { 2, 0 }, { 0, 0 }, "arrivalGate", sp_arrivalgate, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "arrivalGate", sp_arrivalgate, t_text },
    { { 2, 0 }, { 0, 0 }, "arrivalPlatform", sp_arrivalplatform, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "arrivalPlatform", sp_arrivalplatform, t_text },
    { { 2, 0 }, { 0, 0 }, "arrivalStation", sp_arrivalstation, t_schema, sch_trainstation },
    { { 2, 0 }, { 0, 0 }, "arrivalTerminal", sp_arrivalterminal, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "arrivalTerminal", sp_arrivalterminal, t_text },
    { { 2, 0 }, { 0, 0 }, "arrivalTime", sp_arrivaltime, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "arrivalTime", sp_arrivaltime, t_datetime },
    { { 2, 0 }, { 0, 0 }, "arrivalTime", sp_arrivaltime, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "arrivalTime", sp_arrivaltime, t_datetime_absolute },
    { { 2, 0 }, { 0, 0 }, "artEdition", sp_artedition, t_schema, sch_float },
    { { 2, 0 }, { 0, 0 }, "artEdition", sp_artedition, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "artEdition", sp_artedition, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "artEdition", sp_artedition, t_text },
    { { 2, 0 }, { 0, 0 }, "artMedium", sp_artmedium, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "artMedium", sp_artmedium, t_text },
    { { 2, 0 }, { 0, 0 }, "artMedium", sp_artmedium, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "artMedium", sp_artmedium, t_url },
    { { 2, 0 }, { 0, 0 }, "arterialBranch", sp_arterialbranch, t_schema, sch_anatomicalstructure },
    { { 2, 0 }, { 0, 0 }, "artform", sp_artform, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "artform", sp_artform, t_text },
    { { 2, 0 }, { 0, 0 }, "artform", sp_artform, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "artform", sp_artform, t_url },
    { { 2, 0 }, { 0, 0 }, "articleBody", sp_articlebody, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "articleBody", sp_articlebody, t_text },
    { { 2, 0 }, { 0, 0 }, "articleSection", sp_articlesection, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "articleSection", sp_articlesection, t_text },
    { { 3, 5 }, { 0, 0 }, "artist", sp_artist, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "artworkSurface", sp_artworksurface, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "artworkSurface", sp_artworksurface, t_text },
    { { 2, 0 }, { 0, 0 }, "artworkSurface", sp_artworksurface, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "artworkSurface", sp_artworksurface, t_url },
    { { 2, 0 }, { 0, 0 }, "aspect", sp_aspect, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "aspect", sp_aspect, t_text },
    { { 2, 0 }, { 0, 0 }, "assemblyVersion", sp_assemblyversion, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "assemblyVersion", sp_assemblyversion, t_text },
    { { 2, 0 }, { 0, 0 }, "assess", sp_assess, t_schema, sch_definedterm },
    { { 8, 0 }, { 0, 0 }, "assess", sp_assess, t_schema, sch_text },
    { { 8, 0 }, { 0, 0 }, "assess", sp_assess, t_text },
    { { 9, 0 }, { 0, 0 }, "assesses", sp_assesses, t_schema, sch_definedterm },
    { { 9, 0 }, { 0, 0 }, "assesses", sp_assesses, t_schema, sch_text },
    { { 9, 0 }, { 0, 0 }, "assesses", sp_assesses, t_text },
    { { 2, 0 }, { 0, 0 }, "associatedAnatomy", sp_associatedanatomy, t_schema, sch_anatomicalstructure },
    { { 2, 0 }, { 0, 0 }, "associatedAnatomy", sp_associatedanatomy, t_schema, sch_anatomicalsystem },
    { { 2, 0 }, { 0, 0 }, "associatedAnatomy", sp_associatedanatomy, t_schema, sch_superficialanatomy },
    { { 2, 0 }, { 0, 0 }, "associatedArticle", sp_associatedarticle, t_schema, sch_newsarticle },
    { { 2, 0 }, { 0, 0 }, "associatedMedia", sp_associatedmedia, t_schema, sch_mediaobject },
    { { 2, 0 }, { 0, 0 }, "associatedPathophysiology", sp_associatedpathophysiology, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "associatedPathophysiology", sp_associatedpathophysiology, t_text },
    { { 2, 0 }, { 0, 0 }, "athlete", sp_athlete, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "attendee", sp_attendee, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "attendee", sp_attendee, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "audience", sp_audience, t_schema, sch_audience },
    { { 2, 0 }, { 0, 0 }, "audienceType", sp_audiencetype, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "audienceType", sp_audiencetype, t_text },
    { { 2, 0 }, { 0, 0 }, "audio", sp_audio, t_schema, sch_audioobject },
    { { 3, 5 }, { 0, 0 }, "audio", sp_audio, t_schema, sch_clip },
    { { 5, 0 }, { 0, 0 }, "audio", sp_audio, t_schema, sch_musicrecording },
    { { 3, 5 }, { 0, 0 }, "authenticator", sp_authenticator, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "author", sp_author, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "author", sp_author, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "availabeDeliveryMethod", sp_availabedeliverymethod, t_schema, sch_deliverymethod },
    { { 2, 0 }, { 0, 0 }, "availability", sp_availability, t_schema, sch_itemavailability },
    { { 2, 0 }, { 0, 0 }, "availabilityEnds", sp_availabilityends, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "availabilityEnds", sp_availabilityends, t_datetime },
    { { 3, 5 }, { 0, 0 }, "availabilityEnds", sp_availabilityends, t_datetime_absolute },
    { { 3, 8 }, { 0, 0 }, "availabilityEnds", sp_availabilityends, t_schema, sch_date },
    { { 3, 8 }, { 0, 0 }, "availabilityEnds", sp_availabilityends, t_just_date },
    { { 3, 8 }, { 0, 0 }, "availabilityEnds", sp_availabilityends, t_schema, sch_time },
    { { 3, 8 }, { 0, 0 }, "availabilityEnds", sp_availabilityends, t_just_time },
    { { 2, 0 }, { 0, 0 }, "availabilityStarts", sp_availabilitystarts, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "availabilityStarts", sp_availabilitystarts, t_datetime },
    { { 3, 8 }, { 0, 0 }, "availabilityStarts", sp_availabilitystarts, t_datetime_absolute },
    { { 3, 5 }, { 0, 0 }, "availabilityStarts", sp_availabilitystarts, t_schema, sch_date },
    { { 3, 5 }, { 0, 0 }, "availabilityStarts", sp_availabilitystarts, t_just_date },
    { { 3, 8 }, { 0, 0 }, "availabilityStarts", sp_availabilitystarts, t_schema, sch_time },
    { { 3, 8 }, { 0, 0 }, "availabilityStarts", sp_availabilitystarts, t_just_time },
    { { 2, 0 }, { 0, 0 }, "availableAtOrFrom", sp_availableatorfrom, t_schema, sch_place },
    { { 2, 0 }, { 0, 0 }, "availableChannel", sp_availablechannel, t_schema, sch_servicechannel },
    { { 2, 0 }, { 0, 0 }, "availableDeliveryMethod", sp_availabledeliverymethod, t_schema, sch_deliverymethod },
    { { 2, 0 }, { 0, 0 }, "availableFrom", sp_availablefrom, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "availableFrom", sp_availablefrom, t_datetime },
    { { 2, 0 }, { 0, 0 }, "availableIn", sp_availablein, t_schema, sch_administrativearea },
    { { 2, 0 }, { 0, 0 }, "availableLanguage", sp_availablelanguage, t_schema, sch_language },
    { { 3, 0 }, { 0, 0 }, "availableLanguage", sp_availablelanguage, t_schema, sch_text },
    { { 3, 0 }, { 0, 0 }, "availableLanguage", sp_availablelanguage, t_text },
    { { 2, 0 }, { 0, 0 }, "availableLocation", sp_availablelocation, t_schema, sch_administrativearea },
    { { 2, 0 }, { 0, 0 }, "availableOnDevice", sp_availableondevice, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "availableOnDevice", sp_availableondevice, t_text },
    { { 2, 0 }, { 0, 0 }, "availableService", sp_availableservice, t_schema, sch_medicalprocedure },
    { { 2, 0 }, { 0, 0 }, "availableService", sp_availableservice, t_schema, sch_medicaltest },
    { { 2, 0 }, { 0, 0 }, "availableService", sp_availableservice, t_schema, sch_medicaltherapy },
    { { 2, 0 }, { 0, 0 }, "availableStrength", sp_availablestrength, t_schema, sch_drugstrength },
    { { 2, 0 }, { 0, 0 }, "availableTest", sp_availabletest, t_schema, sch_medicaltest },
    { { 2, 0 }, { 0, 0 }, "availableThrough", sp_availablethrough, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "availableThrough", sp_availablethrough, t_datetime },
    { { 2, 0 }, { 0, 0 }, "award", sp_award, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "award", sp_award, t_text },
    { { 2, 0 }, { 0, 0 }, "awayTeam", sp_awayteam, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "awayTeam", sp_awayteam, t_schema, sch_sportsteam },
    { { 3, 5 }, { 0, 0 }, "backAccountType", sp_backaccounttype, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "backAccountType", sp_backaccounttype, t_text },
    { { 3, 5 }, { 0, 0 }, "backAccountType", sp_backaccounttype, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "backAccountType", sp_backaccounttype, t_url },
    { { 2, 0 }, { 0, 0 }, "background", sp_background, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "background", sp_background, t_text },
    { { 3, 5 }, { 0, 0 }, "backstory", sp_backstory, t_schema, sch_creativework },
    { { 3, 5 }, { 0, 0 }, "backstory", sp_backstory, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "backstory", sp_backstory, t_text },
    { { 2, 0 }, { 0, 0 }, "baseSalary", sp_basesalary, t_schema, sch_float },
    { { 2, 0 }, { 0, 0 }, "baseSalary", sp_basesalary, t_fixedpoint },
    { { 3, 3 }, { 0, 0 }, "baseSalary", sp_basesalary, t_schema, sch_monetaryamount },
    { { 2, 0 }, { 0, 0 }, "baseSalary", sp_basesalary, t_schema, sch_pricespecification },
    { { 3, 3 }, { 0, 0 }, "bccRecipient", sp_bccrecipient, t_schema, sch_contactpoint },
    { { 3, 3 }, { 0, 0 }, "bccRecipient", sp_bccrecipient, t_schema, sch_organisation },
    { { 3, 3 }, { 0, 0 }, "bccRecipient", sp_bccrecipient, t_schema, sch_person },
    { { 3, 1 }, { 0, 0 }, "bed", sp_bed, t_schema, sch_beddetails },
    { { 3, 5 }, { 0, 0 }, "bed", sp_bed, t_schema, sch_bedtype },
    { { 3, 1 }, { 0, 0 }, "bed", sp_bed, t_schema, sch_text },
    { { 3, 1 }, { 0, 0 }, "bed", sp_bed, t_text },
    { { 3, 3 }, { 0, 0 }, "beforeMedia", sp_beforemedia, t_schema, sch_mediaobject },
    { { 3, 4 }, { 0, 0 }, "beforeMedia", sp_beforemedia, t_schema, sch_url },
    { { 3, 4 }, { 0, 0 }, "beforeMedia", sp_beforemedia, t_url },
    { { 3, 5 }, { 0, 0 }, "beneficiaryBank", sp_beneficiarybank, t_schema, sch_bankorcreditunion },
    { { 3, 5 }, { 0, 0 }, "beneficiaryBank", sp_beneficiarybank, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "beneficiaryBank", sp_beneficiarybank, t_text },
    { { 3, 5 }, { 0, 0 }, "benefitsSummaryUrl", sp_benefitssummaryurl, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "benefitsSummaryUrl", sp_benefitssummaryurl, t_url },
    { { 2, 0 }, { 0, 0 }, "bestRating", sp_bestrating, t_schema, sch_float },
    { { 2, 0 }, { 0, 0 }, "bestRating", sp_bestrating, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "bestRating", sp_bestrating, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "bestRating", sp_bestrating, t_text },
    { { 2, 0 }, { 0, 0 }, "billingAddress", sp_billingaddress, t_schema, sch_postaladdress },
    { { 2, 0 }, { 0, 0 }, "billingIncrement", sp_billingincrement, t_schema, sch_float },
    { { 2, 0 }, { 0, 0 }, "billingIncrement", sp_billingincrement, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "billingPeriod", sp_billingperiod, t_schema, sch_duration },
    { { 2, 0 }, { 0, 0 }, "billingPeriod", sp_billingperiod, t_duration },
    { { 2, 0 }, { 0, 0 }, "biomechanicalClass", sp_biomechanicalclass, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "biomechanicalClass", sp_biomechanicalclass, t_text },
    { { 2, 0 }, { 0, 0 }, "birthDate", sp_birthdate, t_schema, sch_date },
    { { 2, 0 }, { 0, 0 }, "birthDate", sp_birthdate, t_just_date },
    { { 2, 0 }, { 0, 0 }, "birthPlace", sp_birthplace, t_schema, sch_place },
    { { 2, 0 }, { 0, 0 }, "bitrate", sp_bitrate, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "bitrate", sp_bitrate, t_text },
    { { 2, 0 }, { 0, 0 }, "blogPost", sp_blogpost, t_schema, sch_blogposting },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "bloodSupply", sp_bloodsupply, t_schema, sch_vessel },
    { { 2, 0 }, { 0, 0 }, "boardingGroup", sp_boardinggroup, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "boardingGroup", sp_boardinggroup, t_text },
    { { 2, 0 }, { 0, 0 }, "boardingPolicy", sp_boardingpolicy, t_schema, sch_boardingpolicytype },
    { { 2, 0 }, { 0, 0 }, "boardingPolicy", sp_boardingpolicy, t_schema, sch_boardingpolicytype},
    { { 2, 0 }, { 0, 0 }, "bodyLocation", sp_bodylocation, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "bodyLocation", sp_bodylocation, t_text },
    { { 3, 5 }, { 0, 0 }, "bodyType", sp_bodytype, t_schema, sch_qualitativevalue },
    { { 3, 5 }, { 0, 0 }, "bodyType", sp_bodytype, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "bodyType", sp_bodytype, t_text },
    { { 3, 5 }, { 0, 0 }, "bodyType", sp_bodytype, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "bodyType", sp_bodytype, t_url },
    { { 2, 0 }, { 0, 0 }, "bookEdition", sp_bookedition, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "bookEdition", sp_bookedition, t_text },
    { { 2, 0 }, { 0, 0 }, "bookFormat", sp_bookformat, t_schema, sch_bookformattype },
    { { 2, 0 }, { 0, 0 }, "bookingTime", sp_bookingtime, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "bookingTime", sp_bookingtime, t_datetime },
    { { 2, 0 }, { 0, 0 }, "box", sp_box, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "box", sp_box, t_text },
    { { 2, 0 }, { 0, 0 }, "branch", sp_branch, t_schema, sch_nerve },
    { { 2, 2 }, { 0, 0 }, "branchCode", sp_branchcode, t_schema, sch_text },
    { { 2, 2 }, { 0, 0 }, "branchCode", sp_branchcode, t_text },
    { { 2, 0 }, { 0, 0 }, "brand", sp_brand, t_schema, sch_brand },
    { { 2, 0 }, { 0, 0 }, "brand", sp_brand, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "breadcrumb", sp_breadcrumb, t_schema, sch_breadcrumblist },
    { { 2, 0 }, { 0, 0 }, "breadcrumb", sp_breadcrumb, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "breadcrumb", sp_breadcrumb, t_text },
    { { 2, 0 }, { 0, 0 }, "breastfeedingWarning", sp_breastfeedingwarning, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "breastfeedingWarning", sp_breastfeedingwarning, t_text },
    { { 2, 0 }, { 0, 0 }, "broadcastAffiliateOf", sp_broadcastaffiliateof, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "broadcastChannelId", sp_broadcastchannelid, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "broadcastChannelId", sp_broadcastchannelid, t_text },
    { { 2, 0 }, { 0, 0 }, "broadcastDisplayName", sp_broadcastdisplayname, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "broadcastDisplayName", sp_broadcastdisplayname, t_text },
    { { 3, 5 }, { 0, 0 }, "broadcastFrequency", sp_broadcastfrequency, t_schema, sch_broadcastfrequencyspecification },
    { { 3, 5 }, { 0, 0 }, "broadcastFrequency", sp_broadcastfrequency, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "broadcastFrequency", sp_broadcastfrequency, t_text },
    { { 3, 5 }, { 0, 0 }, "broadcastFrequencyValue", sp_broadcastfrequencyvalue, t_schema, sch_float },
    { { 3, 5 }, { 0, 0 }, "broadcastFrequencyValue", sp_broadcastfrequencyvalue, t_fixedpoint },
    { { 3, 5 }, { 0, 0 }, "broadcastFrequencyValue", sp_broadcastfrequencyvalue, t_schema, sch_quantitativevalue },
    { { 2, 2 }, { 0, 0 }, "broadcastOfEvent", sp_broadcastofevent, t_schema, sch_event },
    { { 2, 0 }, { 0, 0 }, "broadcastServiceTier", sp_broadcastservicetier, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "broadcastServiceTier", sp_broadcastservicetier, t_text },
    { { 3, 5 }, { 0, 0 }, "broadcastSignalModulation", sp_broadcastsignalmodulation, t_schema, sch_float },
    { { 3, 5 }, { 0, 0 }, "broadcastSignalModulation", sp_broadcastsignalmodulation, t_fixedpoint },
    { { 3, 5 }, { 0, 0 }, "broadcastSignalModulation", sp_broadcastsignalmodulation, t_schema, sch_quantitativevalue },
    { { 3, 5 }, { 0, 0 }, "broadcastSubChannel", sp_broadcastsubchannel, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "broadcastSubChannel", sp_broadcastsubchannel, t_text },
    { { 2, 0 }, { 0, 0 }, "broadcastTimezone", sp_broadcasttimezone, t_tz },
    { { 2, 0 }, { 0, 0 }, "broadcaster", sp_broadcaster, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "broker", sp_broker, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "broker", sp_broker, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "browserRequirements", sp_browserrequirements, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "browserRequirements", sp_browserrequirements, t_text },
    { { 2, 0 }, { 0, 0 }, "busName", sp_busname, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "busName", sp_busname, t_text },
    { { 2, 0 }, { 0, 0 }, "busNumber", sp_busnumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "busNumber", sp_busnumber, t_text },
    { { 8, 0 }, { 0, 0 }, "businessDays", sp_businessdays, t_schema, sch_openinghoursspecification },
    { { 2, 0 }, { 0, 0 }, "businessFunction", sp_businessfunction, t_schema, sch_businessfunction },
    { { 2, 0 }, { 0, 0 }, "buyer", sp_buyer, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "byArtist", sp_byartist, t_schema, sch_musicgroup },
    { { 3, 5 }, { 0, 0 }, "byArtist", sp_byartist, t_schema, sch_person },
    { { 3, 5 }, { 0, 0 }, "byDay", sp_byday, t_schema, sch_dayofweek },
    { { 6, 0 }, { 0, 0 }, "byDay", sp_byday, t_schema, sch_text },
    { { 6, 0 }, { 0, 0 }, "byDay", sp_byday, t_text },
    { { 3, 5 }, { 0, 0 }, "byMonth", sp_bymonth, t_schema, sch_integer },
    { { 3, 5 }, { 0, 0 }, "byMonth", sp_bymonth, t_integer },
    { { 3, 5 }, { 0, 0 }, "byMonthDay", sp_bymonthday, t_schema, sch_integer },
    { { 3, 5 }, { 0, 0 }, "byMonthDay", sp_bymonthday, t_integer },
    { { 9, 0 }, { 0, 0 }, "byMonthWeek", sp_bymonthweek, t_schema, sch_integer },
    { { 9, 0 }, { 0, 0 }, "byMonthWeek", sp_bymonthweek, t_integer },
    { { 5, 0 }, { 0, 0 }, "callSign", sp_callsign, t_schema, sch_text },
    { { 5, 0 }, { 0, 0 }, "callSign", sp_callsign, t_text },
    { { 2, 0 }, { 0, 0 }, "calories", sp_calories, t_schema, sch_energy },
    { { 2, 0 }, { 0, 0 }, "candidate", sp_candidate, t_schema, sch_person },
    { { 3, 5 }, { 0, 0 }, "caption", sp_caption, t_schema, sch_mediaobject },
    { { 2, 0 }, { 0, 0 }, "caption", sp_caption, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "caption", sp_caption, t_text },
    { { 2, 0 }, { 0, 0 }, "carbohydrateContent", sp_carbohydratecontent, t_schema, sch_mass },
    { { 2, 0 }, { 0, 0 }, "cargoVolume", sp_cargovolume, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "carrierRequirements", sp_carrierrequirements, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "carrierRequirements", sp_carrierrequirements, t_text },
    { { 3, 5 }, { 0, 0 }, "cashBack", sp_cashback, t_schema, sch_boolean },
    { { 3, 5 }, { 0, 0 }, "cashBack", sp_cashback, t_bool },
    { { 3, 5 }, { 0, 0 }, "cashBack", sp_cashback, t_schema, sch_number },
    { { 3, 5 }, { 0, 0 }, "cashBack", sp_cashback, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "cataloguenumber", sp_cataloguenumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "cataloguenumber", sp_cataloguenumber, t_text },
    { { 2, 0 }, { 0, 0 }, "category", sp_category, t_schema, sch_physicalactivitycategory },
    { { 2, 0 }, { 0, 0 }, "category", sp_category, t_schema, sch_thing },
    { { 2, 0 }, { 0, 0 }, "category", sp_category, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "category", sp_category, t_text },
    { { 7, 4 }, { 0, 0 }, "category", sp_category, t_schema, sch_url },
    { { 7, 4 }, { 0, 0 }, "category", sp_category, t_url },
    { { 2, 0 }, { 6, 0 }, "cause", sp_cause, t_schema, sch_medicalcause },
    { { 2, 0 }, { 0, 0 }, "causeOf", sp_causeof, t_schema, sch_medicalentity },
    { { 3, 3 }, { 0, 0 }, "ccRecipient", sp_ccrecipient, t_schema, sch_contactpoint },
    { { 3, 3 }, { 0, 0 }, "ccRecipient", sp_ccrecipient, t_schema, sch_organisation },
    { { 3, 3 }, { 0, 0 }, "ccRecipient", sp_ccrecipient, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "character", sp_character, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "characterAttribute", sp_characterattribute, t_schema, sch_thing },
    { { 2, 0 }, { 0, 0 }, "characterName", sp_charactername, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "characterName", sp_charactername, t_text },
    { { 2, 0 }, { 0, 0 }, "cheatCode", sp_cheatcode, t_schema, sch_creativework },
    { { 2, 0 }, { 0, 0 }, "checkinTime", sp_checkintime, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "checkinTime", sp_checkintime, t_datetime },
    { { 3, 8 }, { 0, 0 }, "checkinTime", sp_checkintime, t_schema, sch_time },
    { { 3, 8 }, { 0, 0 }, "checkinTime", sp_checkintime, t_just_time },
    { { 2, 0 }, { 0, 0 }, "checkoutTime", sp_checkouttime, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "checkoutTime", sp_checkouttime, t_datetime },
    { { 3, 8 }, { 0, 0 }, "checkoutTime", sp_checkouttime, t_schema, sch_time },
    { { 3, 8 }, { 0, 0 }, "checkoutTime", sp_checkouttime, t_just_time },
    { { 2, 0 }, { 0, 0 }, "childMaxAge", sp_childmaxage, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "childMaxAge", sp_childmaxage, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "childMinAge", sp_childminage, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "childMinAge", sp_childminage, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "children", sp_children, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "cholesterolContent", sp_cholesterolcontent, t_schema, sch_mass },
    { { 2, 0 }, { 0, 0 }, "circle", sp_circle, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "circle", sp_circle, t_text },
    { { 2, 0 }, { 0, 0 }, "citation", sp_citation, t_schema, sch_creativework },
    { { 2, 0 }, { 0, 0 }, "citation", sp_citation, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "citation", sp_citation, t_text },
    { { 3, 2 }, { 0, 0 }, "claimReviewed", sp_claimreviewed, t_schema, sch_text },
    { { 3, 2 }, { 0, 0 }, "claimReviewed", sp_claimreviewed, t_text },
    { { 2, 0 }, { 0, 0 }, "clinicalPharamcology", sp_clinicalpharamcology, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "clinicalPharamcology", sp_clinicalpharamcology, t_text },
    { { 2, 0 }, { 0, 0 }, "clipNumber", sp_clipnumber, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "clipNumber", sp_clipnumber, t_integer },
    { { 2, 0 }, { 0, 0 }, "clipNumber", sp_clipnumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "clipNumber", sp_clipnumber, t_text },
    { { 2, 0 }, { 0, 0 }, "closes", sp_closes, t_schema, sch_time },
    { { 2, 0 }, { 0, 0 }, "closes", sp_closes, t_just_time },
    { { 2, 0 }, { 0, 0 }, "coach", sp_coach, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "code", sp_code, t_schema, sch_medicalcode },
    { { 2, 0 }, { 0, 0 }, "codeRepository", sp_coderepository, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "codeRepository", sp_coderepository, t_url },
    { { 2, 0 }, { 0, 0 }, "codeSampleType", sp_codesampletype, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "codeSampleType", sp_codesampletype, t_text },
    { { 2, 0 }, { 0, 0 }, "codeValue", sp_codevalue, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "codeValue", sp_codevalue, t_text },
    { { 2, 0 }, { 0, 0 }, "codingSystem", sp_codingsystem, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "codingSystem", sp_codingsystem, t_text },
    { { 2, 0 }, { 0, 0 }, "colleague", sp_colleague, t_schema, sch_person },
    { { 3, 0 }, { 0, 0 }, "colleague", sp_colleague, t_schema, sch_url },
    { { 3, 0 }, { 0, 0 }, "colleague", sp_colleague, t_url },
    { { 3, 5 }, { 0, 0 }, "collectionSize", sp_collectionsize, t_schema, sch_integer },
    { { 3, 5 }, { 0, 0 }, "collectionSize", sp_collectionsize, t_integer },
    { { 2, 0 }, { 0, 0 }, "color", sp_colour, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "color", sp_colour, t_text },
    { { 3, 5 }, { 0, 0 }, "colorist", sp_colourist, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "comment", sp_comment, t_schema, sch_comment },
    { { 2, 0 }, { 0, 0 }, "commentCount", sp_commentcount, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "commentCount", sp_commentcount, t_integer },
    { { 2, 0 }, { 0, 0 }, "commentText", sp_commenttext, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "commentText", sp_commenttext, t_text },
    { { 3, 1 }, { 0, 0 }, "commentTime", sp_commenttime, t_schema, sch_datetime },
    { { 3, 1 }, { 0, 0 }, "commentTime", sp_commenttime, t_datetime },
    { { 2, 0 }, { 0, 0 }, "commentTime", sp_commenttime, t_schema, sch_date },
    { { 2, 0 }, { 0, 0 }, "commentTime", sp_commenttime, t_just_date },
    { { 3, 5 }, { 0, 0 }, "competencyRequired", sp_competencyrequired, t_schema, sch_definedterm },
    { { 3, 5 }, { 0, 0 }, "competencyRequired", sp_competencyrequired, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "competencyRequired", sp_competencyrequired, t_text },
    { { 3, 5 }, { 0, 0 }, "competencyRequired", sp_competencyrequired, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "competencyRequired", sp_competencyrequired, t_url },
    { { 2, 0 }, { 0, 0 }, "competitor", sp_competitor, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "competitor", sp_competitor, t_schema, sch_sportsteam },
    { { 2, 0 }, { 0, 0 }, "composer", sp_composer, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "composer", sp_composer, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "comprisedOf", sp_comprisedof, t_schema, sch_anatomicalstructure },
    { { 2, 0 }, { 0, 0 }, "comprisedOf", sp_comprisedof, t_schema, sch_anatomicalsystem },
    { { 3, 8 }, { 0, 0 }, "conditionsOfAccess", sp_conditionsofaccess, t_schema, sch_text },
    { { 3, 8 }, { 0, 0 }, "conditionsOfAccess", sp_conditionsofaccess, t_text },
    { { 2, 0 }, { 0, 0 }, "confirmationNumber", sp_confirmationnumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "confirmationNumber", sp_confirmationnumber, t_text },
    { { 2, 0 }, { 0, 0 }, "connectedTo", sp_connectedto, t_schema, sch_anatomicalstructure },
    { { 3, 9 }, { 0, 0 }, "constrainingProperty", sp_constrainingproperty, t_schema, sch_integer },
    { { 3, 9 }, { 0, 0 }, "constrainingProperty", sp_constrainingproperty, t_integer },
    { { 2, 0 }, { 0, 0 }, "contactOption", sp_contactoption, t_schema, sch_contactpointoption },
    { { 2, 0 }, { 0, 0 }, "contactPoint", sp_contactpoint, t_schema, sch_contactpoint },
    { { 2, 0 }, { 0, 0 }, "contactType", sp_contacttype, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "contactType", sp_contacttype, t_text },
    { { 3, 5 }, { 0, 0 }, "contactlessPayment", sp_contactlesspayment },
    { { 2, 0 }, { 2, 1 }, "containedIn", sp_containedin, t_schema, sch_place },
    { { 2, 2 }, { 0, 0 }, "containedInPlace", sp_containedinplace, t_schema, sch_place },
    { { 2, 2 }, { 0, 0 }, "containsPlace", sp_containsplace, t_schema, sch_place },
    { { 2, 0 }, { 0, 0 }, "containsSeason", sp_containsseason, t_schema, sch_creativeworkseason },
    { { 2, 0 }, { 0, 0 }, "contentLocation", sp_contentlocation, t_schema, sch_place },
    { { 3, 4 }, { 0, 0 }, "contentRating", sp_contentrating, t_schema, sch_rating },
    { { 2, 0 }, { 0, 0 }, "contentRating", sp_contentrating, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "contentRating", sp_contentrating, t_text },
    { { 3, 5 }, { 0, 0 }, "contentReferenceTime", sp_contentreferencetime, t_schema, sch_datetime },
    { { 3, 5 }, { 0, 0 }, "contentReferenceTime", sp_contentreferencetime, t_datetime },
    { { 2, 0 }, { 0, 0 }, "contentSize", sp_contentsize, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "contentSize", sp_contentsize, t_text },
    { { 2, 0 }, { 0, 0 }, "contentType", sp_contenttype, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "contentType", sp_contenttype, t_text },
    { { 2, 0 }, { 0, 0 }, "contentUrl", sp_contenturl, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "contentUrl", sp_contenturl, t_url },
    { { 2, 0 }, { 0, 0 }, "contraindication", sp_contraindication, t_schema, sch_medicalcontraindication },
    { { 3, 5 }, { 0, 0 }, "contraindication", sp_contraindication, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "contraindication", sp_contraindication, t_text },
    { { 2, 0 }, { 0, 0 }, "contributor", sp_contributor, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "contributor", sp_contributor, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "cookTime", sp_cooktime, t_schema, sch_duration },
    { { 2, 0 }, { 0, 0 }, "cookTime", sp_cooktime, t_duration },
    { { 2, 0 }, { 0, 0 }, "cookingMethod", sp_cookingmethod, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "cookingMethod", sp_cookingmethod, t_text },
    { { 2, 0 }, { 0, 0 }, "copyrightHolder", sp_copyrightholder, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "copyrightHolder", sp_copyrightholder, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "copyrightYear", sp_copyrightyear, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "copyrightYear", sp_copyrightyear, t_fixedpoint },
    { { 3, 5 }, { 0, 0 }, "correction", sp_correction, t_schema, sch_correctioncomment },
    { { 3, 5 }, { 0, 0 }, "correction", sp_correction, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "correction", sp_correction, t_text },
    { { 3, 5 }, { 0, 0 }, "correction", sp_correction, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "correction", sp_correction, t_url },
    { { 3, 5 }, { 0, 0 }, "correctionsPolicy", sp_correctionspolicy, t_schema, sch_creativework },
    { { 3, 5 }, { 0, 0 }, "correctionsPolicy", sp_correctionspolicy, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "correctionsPolicy", sp_correctionspolicy, t_url },
    { { 2, 0 }, { 0, 0 }, "cost", sp_cost, t_schema, sch_drugcost },
    { { 2, 0 }, { 0, 0 }, "costCategory", sp_costcategory, t_schema, sch_drugcostcategory },
    { { 2, 0 }, { 0, 0 }, "costCurrency", sp_costcurrency, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "costCurrency", sp_costcurrency, t_text },
    { { 2, 0 }, { 0, 0 }, "costOrigin", sp_costorigin, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "costOrigin", sp_costorigin, t_text },
    { { 2, 0 }, { 0, 0 }, "costPerUnit", sp_costperunit, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "costPerUnit", sp_costperunit, t_fixedpoint },
    { { 3, 5 }, { 0, 0 }, "costPerUnit", sp_costperunit, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "costPerUnit", sp_costperunit, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "costPerUnit", sp_costperunit, t_text },
    { { 2, 0 }, { 0, 0 }, "countriesNotSupported", sp_countriesnotsupported, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "countriesNotSupported", sp_countriesnotsupported, t_text },
    { { 2, 0 }, { 0, 0 }, "countriesSupported", sp_countriessupported, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "countriesSupported", sp_countriessupported, t_text },
    { { 2, 2 }, { 0, 0 }, "countryOfOrigin", sp_countryoforigin, t_schema, sch_country },
    { { 3, 4 }, { 0, 0 }, "courseCode", sp_coursecode, t_schema, sch_text },
    { { 3, 4 }, { 0, 0 }, "courseCode", sp_coursecode, t_text },
    { { 3, 4 }, { 0, 0 }, "courseMode", sp_coursemode, t_schema, sch_text },
    { { 3, 4 }, { 0, 0 }, "courseMode", sp_coursemode, t_text },
    { { 3, 4 }, { 0, 0 }, "courseMode", sp_coursemode, t_schema, sch_url },
    { { 3, 4 }, { 0, 0 }, "courseMode", sp_coursemode, t_url },
    { { 3, 4 }, { 0, 0 }, "coursePresequisites", sp_coursepresequisites, t_schema, sch_alignmentobject },
    { { 3, 4 }, { 0, 0 }, "coursePresequisites", sp_coursepresequisites, t_schema, sch_course },
    { { 3, 4 }, { 0, 0 }, "coursePresequisites", sp_coursepresequisites, t_schema, sch_text },
    { { 3, 4 }, { 0, 0 }, "coursePresequisites", sp_coursepresequisites, t_text },
    { { 3, 6 }, { 0, 0 }, "courseWorkload", sp_courseworkload, t_schema, sch_text },
    { { 3, 6 }, { 0, 0 }, "courseWorkload", sp_courseworkload, t_text },
    { { 2, 1 }, { 0, 0 }, "coverageEndTime", sp_coverageendtime, t_schema, sch_datetime },
    { { 2, 1 }, { 0, 0 }, "coverageEndTime", sp_coverageendtime, t_datetime },
    { { 2, 1 }, { 0, 0 }, "coverageStartTime", sp_coveragestarttime, t_schema, sch_datetime },
    { { 2, 1 }, { 0, 0 }, "coverageStartTime", sp_coveragestarttime, t_datetime },
    { { 3, 8 }, { 0, 0 }, "creativeWorkStatus", sp_creativeworkstatus, t_schema, sch_definedterm },
    { { 3, 8 }, { 0, 0 }, "creativeWorkStatus", sp_creativeworkstatus, t_schema, sch_text },
    { { 3, 8 }, { 0, 0 }, "creativeWorkStatus", sp_creativeworkstatus, t_text },
    { { 2, 0 }, { 0, 0 }, "creator", sp_creator, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "creator", sp_creator, t_schema, sch_person },
    { { 3, 5 }, { 0, 0 }, "credentialCategory", sp_credentialcategory, t_schema, sch_definedterm },
    { { 3, 5 }, { 0, 0 }, "credentialCategory", sp_credentialcategory, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "credentialCategory", sp_credentialcategory, t_text },
    { { 3, 5 }, { 0, 0 }, "credentialCategory", sp_credentialcategory, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "credentialCategory", sp_credentialcategory, t_url },
    { { 2, 0 }, { 0, 0 }, "creditedto", sp_creditedto, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "creditedto", sp_creditedto, t_schema, sch_person },
    { { 3, 5 }, { 0, 0 }, "cssSelector", sp_cssselector, t_schema, sch_cssselectortype },
    { { 2, 0 }, { 0, 0 }, "currenciesAccepted", sp_currenciesaccepted, t_text },
    { { 2, 0 }, { 0, 0 }, "currenciesAccepted", sp_currenciesaccepted, t_text },
    { { 2, 0 }, { 0, 0 }, "currency", sp_currency, t_text },
    { { 2, 0 }, { 0, 0 }, "currency", sp_currency, t_text },
    { { 3, 5 }, { 0, 0 }, "currentExchangeRate", sp_currentexchangerate, t_schema, sch_unitpricespecification },
    { { 2, 0 }, { 0, 0 }, "customer", sp_customer, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "customer", sp_customer, t_schema, sch_person },
    { { 8, 0 }, { 0, 0 }, "cutoffTime", sp_cutofftime, t_schema, sch_text },
    { { 8, 0 }, { 0, 0 }, "cutoffTime", sp_cutofftime, t_text },
    { { 7, 3 }, { 0, 0 }, "cvdCollectionDate", sp_cvdcollectiondate, t_schema, sch_datetime },
    { { 7, 3 }, { 0, 0 }, "cvdCollectionDate", sp_cvdcollectiondate, t_datetime_absolute },
    { { 7, 3 }, { 0, 0 }, "cvdCollectionDate", sp_cvdcollectiondate, t_schema, sch_text },
    { { 7, 3 }, { 0, 0 }, "cvdCollectionDate", sp_cvdcollectiondate, t_text },
    { { 7, 3 }, { 0, 0 }, "cvdFacilityCounty", sp_cvdfacilitycounty, t_schema, sch_text },
    { { 7, 3 }, { 0, 0 }, "cvdFacilityCounty", sp_cvdfacilitycounty, t_text },
    { { 7, 3 }, { 0, 0 }, "cvdFacilityId", sp_cvdfacilityid, t_schema, sch_text },
    { { 7, 3 }, { 0, 0 }, "cvdFacilityId", sp_cvdfacilityid, t_text },
    { { 7, 3 }, { 0, 0 }, "cvdNumBeds", sp_cvdnumbeds, t_schema, sch_number },
    { { 7, 3 }, { 0, 0 }, "cvdNumBeds", sp_cvdnumbeds, t_fixedpoint },
    { { 7, 3 }, { 0, 0 }, "cvdNumBedsOcc", sp_cvdnumbedsocc, t_schema, sch_number },
    { { 7, 3 }, { 0, 0 }, "cvdNumBedsOcc", sp_cvdnumbedsocc, t_fixedpoint },
    { { 7, 3 }, { 0, 0 }, "cvdNumC19Died", sp_cvdnumc19died, t_schema, sch_number },
    { { 7, 3 }, { 0, 0 }, "cvdNumC19Died", sp_cvdnumc19died, t_fixedpoint },
    { { 7, 3 }, { 0, 0 }, "cvdNumC19HOPats", sp_cvdnumc19hopats, t_schema, sch_number },
    { { 7, 3 }, { 0, 0 }, "cvdNumC19HOPats", sp_cvdnumc19hopats, t_fixedpoint },
    { { 7, 3 }, { 0, 0 }, "cvdNumC19HospPats", sp_cvdnumc19hosppats, t_schema, sch_number },
    { { 7, 3 }, { 0, 0 }, "cvdNumC19HospPats", sp_cvdnumc19hosppats, t_fixedpoint },
    { { 7, 3 }, { 0, 0 }, "cvdNumC19MechVentPats", sp_cvdnumc19mechventpats, t_schema, sch_number },
    { { 7, 3 }, { 0, 0 }, "cvdNumC19MechVentPats", sp_cvdnumc19mechventpats, t_fixedpoint },
    { { 7, 3 }, { 0, 0 }, "cvdNumC19OFMechVentPats", sp_cvdnumc19ofmechventpats, t_schema, sch_number },
    { { 7, 3 }, { 0, 0 }, "cvdNumC19OFMechVentPats", sp_cvdnumc19ofmechventpats, t_fixedpoint },
    { { 7, 3 }, { 0, 0 }, "cvdNumC19OverflowPats", sp_cvdnumc19overflowpats, t_schema, sch_number },
    { { 7, 3 }, { 0, 0 }, "cvdNumC19OverflowPats", sp_cvdnumc19overflowpats, t_fixedpoint },
    { { 7, 3 }, { 0, 0 }, "cvdNumICUBeds", sp_cvdnumicubeds, t_schema, sch_number },
    { { 7, 3 }, { 0, 0 }, "cvdNumICUBeds", sp_cvdnumicubeds, t_fixedpoint },
    { { 7, 3 }, { 0, 0 }, "cvdNumICUBedsOcc", sp_cvdnumicubedsocc, t_schema, sch_number },
    { { 7, 3 }, { 0, 0 }, "cvdNumICUBedsOcc", sp_cvdnumicubedsocc, t_fixedpoint },
    { { 7, 3 }, { 0, 0 }, "cvdNumTotBeds", sp_cvdnumtotbeds, t_schema, sch_number },
    { { 7, 3 }, { 0, 0 }, "cvdNumTotBeds", sp_cvdnumtotbeds, t_fixedpoint },
    { { 7, 3 }, { 0, 0 }, "cvdNumVent", sp_cvdnumvent, t_schema, sch_number },
    { { 7, 3 }, { 0, 0 }, "cvdNumVent", sp_cvdnumvent, t_fixedpoint },
    { { 7, 3 }, { 0, 0 }, "cvdNumVentUse", sp_cvdnumventuse, t_schema, sch_number },
    { { 7, 3 }, { 0, 0 }, "cvdNumVentUse", sp_cvdnumventuse, t_fixedpoint },
    { { 2, 2 }, { 0, 0 }, "dataFeedElement", sp_datafeedelement, t_schema, sch_datafeeditem },
    { { 2, 2 }, { 0, 0 }, "dataFeedElement", sp_datafeedelement, t_schema, sch_thing },
    { { 2, 2 }, { 0, 0 }, "dataFeedElement", sp_datafeedelement, t_schema, sch_text },
    { { 2, 2 }, { 0, 0 }, "dataFeedElement", sp_datafeedelement, t_text },
    { { 2, 0 }, { 0, 0 }, "dataset", sp_dataset, t_schema, sch_datadownload },
    { { 2, 0 }, { 3, 0 }, "datasetTimeInterval", sp_datasettimeinterval, t_schema, sch_datacatalogue },
    { { 2, 0 }, { 0, 0 }, "dateCreated", sp_datecreated, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "dateCreated", sp_datecreated, t_datetime },
    { { 3, 0 }, { 0, 0 }, "dateDeleted", sp_datedeleted, t_schema, sch_datetime },
    { { 3, 0 }, { 0, 0 }, "dateDeleted", sp_datedeleted, t_datetime },
    { { 2, 0 }, { 0, 0 }, "dateIssued", sp_dateissued, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "dateIssued", sp_dateissued, t_datetime },
    { { 3, 8 }, { 0, 0 }, "dateIssued", sp_dateissued, t_schema, sch_date },
    { { 3, 8 }, { 0, 0 }, "dateIssued", sp_dateissued, t_just_date },
    { { 2, 0 }, { 0, 0 }, "dateModified", sp_datemodified, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "dateModified", sp_datemodified, t_datetime },
    { { 7, 3 }, { 0, 0 }, "datePosted", sp_dateposted, t_schema, sch_datetime },
    { { 7, 3 }, { 0, 0 }, "datePosted", sp_dateposted, t_datetime },
    { { 7, 3 }, { 0, 0 }, "datePosted", sp_dateposted, t_datetime_absolute },
    { { 2, 0 }, { 0, 0 }, "datePosted", sp_dateposted, t_schema, sch_date },
    { { 2, 0 }, { 0, 0 }, "datePosted", sp_dateposted, t_just_date },
    { { 2, 0 }, { 0, 0 }, "datePublished", sp_datepublished, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "datePublished", sp_datepublished, t_datetime },
    { { 3, 0 }, { 0, 0 }, "dateRead", sp_dateread, t_schema, sch_datetime },
    { { 3, 0 }, { 0, 0 }, "dateRead", sp_dateread, t_datetime },
    { { 3, 8 }, { 0, 0 }, "dateRead", sp_dateread, t_schema, sch_date },
    { { 3, 8 }, { 0, 0 }, "dateRead", sp_dateread, t_just_date },
    { { 3, 0 }, { 0, 0 }, "dateReceived", sp_datereceived, t_schema, sch_datetime },
    { { 3, 0 }, { 0, 0 }, "dateReceived", sp_datereceived, t_datetime },
    { { 3, 0 }, { 0, 0 }, "dateSent", sp_datesent, t_schema, sch_datetime },
    { { 3, 0 }, { 0, 0 }, "dateSent", sp_datesent, t_datetime },
    { { 2, 0 }, { 0, 0 }, "dateVehicleFirstRegistered", sp_datevehiclefirstregistered, t_schema, sch_date },
    { { 2, 0 }, { 0, 0 }, "dateVehicleFirstRegistered", sp_datevehiclefirstregistered, t_just_date },
    { { 2, 0 }, { 0, 0 }, "dateline", sp_dateline, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "dateline", sp_dateline, t_text },
    { { 2, 0 }, { 0, 0 }, "dayOfWeek", sp_dayofweek, t_schema, sch_dayofweek },
    { { 2, 0 }, { 0, 0 }, "deathDate", sp_deathdate, t_schema, sch_date },
    { { 2, 0 }, { 0, 0 }, "deathDate", sp_deathdate, t_just_date },
    { { 2, 0 }, { 0, 0 }, "deathPlace", sp_deathplace, t_schema, sch_place },
    { { 2, 0 }, { 0, 0 }, "defaultValue", sp_defaultvalue, t_schema, sch_thing },
    { { 2, 0 }, { 0, 0 }, "defaultValue", sp_defaultvalue, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "defaultValue", sp_defaultvalue, t_text },
    { { 2, 0 }, { 0, 0 }, "deliveryAddress", sp_deliveryaddress, t_schema, sch_postaladdress },
    { { 2, 0 }, { 0, 0 }, "deliveryLeadTime", sp_deliveryleadtime, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "deliveryMethod", sp_deliverymethod, t_schema, sch_deliverymethod },
    { { 2, 0 }, { 0, 0 }, "deliveryStatus", sp_deliverystatus, t_schema, sch_deliveryevent },
    { { 8, 0 }, { 0, 0 }, "deliveryTime", sp_deliverytime, t_schema, sch_shippingdeliverytime },
    { { 2, 0 }, { 0, 0 }, "department", sp_department, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "departureAirport", sp_departureairport, t_schema, sch_airport },
    { { 9, 0 }, { 0, 0 }, "departureBoatTerminal", sp_departureboatterminal, t_schema, sch_boatterminal },
    { { 2, 0 }, { 0, 0 }, "departureBusStop", sp_departurebusstop, t_schema, sch_busstation  },
    { { 2, 0 }, { 0, 0 }, "departureBusStop", sp_departurebusstop, t_schema, sch_busstop  },
    { { 2, 0 }, { 0, 0 }, "departureGate", sp_departuregate, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "departureGate", sp_departuregate, t_text },
    { { 2, 0 }, { 0, 0 }, "departurePlatform", sp_departureplatform, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "departurePlatform", sp_departureplatform, t_text },
    { { 2, 0 }, { 0, 0 }, "departureStation", sp_departurestation, t_schema, sch_trainstation },
    { { 2, 0 }, { 0, 0 }, "departureTerminal", sp_departureterminal, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "departureTerminal", sp_departureterminal, t_text },
    { { 2, 0 }, { 0, 0 }, "departureTime", sp_departuretime, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "departureTime", sp_departuretime, t_datetime },
    { { 2, 0 }, { 0, 0 }, "departureTime", sp_departuretime, t_datetime_absolute },
    { { 2, 0 }, { 0, 0 }, "dependencies", sp_dependencies, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "dependencies", sp_dependencies, t_text },
    { { 2, 0 }, { 0, 0 }, "depth", sp_depth, t_schema, sch_distance },
    { { 2, 0 }, { 0, 0 }, "depth", sp_depth, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "description", sp_description, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "description", sp_description, t_text },
    { { 2, 0 }, { 0, 0 }, "diagnosis", sp_diagnosis, t_schema, sch_medicalcondition },
    { { 2, 0 }, { 0, 0 }, "diagram", sp_diagram, t_schema, sch_imageobject },
    { { 3, 5 }, { 0, 0 }, "diet", sp_diet, t_schema, sch_diet },
    { { 2, 0 }, { 0, 0 }, "dietFeatures", sp_dietfeatures, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "dietFeatures", sp_dietfeatures, t_text },
    { { 2, 0 }, { 0, 0 }, "differentialDiagnosis", sp_differentialdiagnosis, t_schema, sch_ddxelement },
    { { 2, 0 }, { 0, 0 }, "director", sp_director, t_schema, sch_person },
    { { 3, 0 }, { 0, 0 }, "disambiguatingDescription", sp_disambiguatingdescription, t_schema, sch_text },
    { { 3, 0 }, { 0, 0 }, "disambiguatingDescription", sp_disambiguatingdescription, t_text },
    { { 2, 0 }, { 0, 0 }, "discount", sp_discount, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "discount", sp_discount, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "discount", sp_discount, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "discount", sp_discount, t_text },
    { { 2, 0 }, { 0, 0 }, "discountCode", sp_discountcode, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "discountCode", sp_discountcode, t_text },
    { { 2, 0 }, { 0, 0 }, "discountCurrency", sp_discountcurrency, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "discountCurrency", sp_discountcurrency, t_text },
    { { 2, 0 }, { 0, 0 }, "discusses", sp_discusses, t_schema, sch_creativework },
    { { 2, 0 }, { 0, 0 }, "discussionUrl", sp_discussionurl, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "discussionUrl", sp_discussionurl, t_url },
    { { 7, 0 }, { 0, 0 }, "diseasePreventionInfo", sp_diseasepreventioninfo, t_schema, sch_webcontent },
    { { 7, 0 }, { 0, 0 }, "diseasePreventionInfo", sp_diseasepreventioninfo, t_schema, sch_url },
    { { 7, 0 }, { 0, 0 }, "diseasePreventionInfo", sp_diseasepreventioninfo, t_url },
    { { 7, 0 }, { 0, 0 }, "diseaseSpreadStatistics", sp_diseasespreadstatistics, t_schema, sch_dataset },
    { { 7, 0 }, { 0, 0 }, "diseaseSpreadStatistics", sp_diseasespreadstatistics, t_schema, sch_observation },
    { { 7, 0 }, { 0, 0 }, "diseaseSpreadStatistics", sp_diseasespreadstatistics, t_schema, sch_webcontent },
    { { 7, 0 }, { 0, 0 }, "diseaseSpreadStatistics", sp_diseasespreadstatistics, t_schema, sch_url },
    { { 7, 0 }, { 0, 0 }, "diseaseSpreadStatistics", sp_diseasespreadstatistics, t_url },
    { { 2, 0 }, { 0, 0 }, "dissolutionDate", sp_dissolutiondate, t_schema, sch_date },
    { { 2, 0 }, { 0, 0 }, "dissolutionDate", sp_dissolutiondate, t_just_date },
    { { 2, 0 }, { 0, 0 }, "distance", sp_distance, t_schema, sch_distance },
    { { 2, 0 }, { 0, 0 }, "distinguishingSign", sp_distinguishingsign, t_schema, sch_medicalsignorsymptom },
    { { 2, 0 }, { 0, 0 }, "distribution", sp_distribution, t_schema, sch_datadownload },
    { { 3, 5 }, { 0, 0 }, "diversityPolicy", sp_diversitypolicy, t_schema, sch_creativework },
    { { 3, 5 }, { 0, 0 }, "diversityPolicy", sp_diversitypolicy, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "diversityPolicy", sp_diversitypolicy, t_url },
    { { 3, 5 }, { 0, 0 }, "diversityStaffingReport", sp_diversitystaffingreport, t_schema, sch_article },
    { { 3, 5 }, { 0, 0 }, "diversityStaffingReport", sp_diversitystaffingreport, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "diversityStaffingReport", sp_diversitystaffingreport, t_url },
    { { 3, 5 }, { 0, 0 }, "documentation", sp_documentation, t_schema, sch_creativework },
    { { 3, 5 }, { 0, 0 }, "documentation", sp_documentation, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "documentation", sp_documentation, t_url },
    { { 8, 0 }, { 0, 0 }, "doesNotShip", sp_doesnotship, t_schema, sch_boolean },
    { { 8, 0 }, { 0, 0 }, "doesNotShip", sp_doesnotship, t_bool },
    { { 2, 0 }, { 0, 0 }, "domainIncludes", sp_domainincludes, t_schema, sch_class },
    { { 3, 5 }, { 0, 0 }, "domiciledMortgage", sp_domiciledmortgage, t_schema, sch_boolean },
    { { 3, 5 }, { 0, 0 }, "domiciledMortgage", sp_domiciledmortgage, t_bool },
    { { 2, 0 }, { 0, 0 }, "doorTime", sp_doortime, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "doorTime", sp_doortime, t_datetime },
    { { 3, 8 }, { 0, 0 }, "doorTime", sp_doortime, t_schema, sch_time },
    { { 3, 8 }, { 0, 0 }, "doorTime", sp_doortime, t_just_time },
    { { 2, 0 }, { 0, 0 }, "dosageForm", sp_dosageform, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "dosageForm", sp_dosageform, t_text },
    { { 2, 0 }, { 0, 0 }, "doseSchedule", sp_doseschedule, t_schema, sch_doseschedule },
    { { 2, 0 }, { 0, 0 }, "doseUnit", sp_doseunit, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "doseUnit", sp_doseunit, t_text },
    { { 2, 0 }, { 0, 0 }, "doseValue", sp_dosevalue, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "doseValue", sp_dosevalue, t_fixedpoint },
    { { 3, 5 }, { 0, 0 }, "doseValue", sp_dosevalue, t_schema, sch_quantitativevalue },
    { { 3, 5 }, { 0, 0 }, "downPayment", sp_downpayment, t_schema, sch_number },
    { { 3, 5 }, { 0, 0 }, "downPayment", sp_downpayment, t_fixedpoint },
    { { 3, 5 }, { 0, 0 }, "downPayment", sp_downpayment, t_schema, sch_monetaryamount },
    { { 2, 0 }, { 0, 0 }, "downloadUrl", sp_downloadurl, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "downloadUrl", sp_downloadurl, t_url },
    { { 2, 0 }, { 0, 0 }, "downvoteCount", sp_downvotecount, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "downvoteCount", sp_downvotecount, t_integer },
    { { 2, 0 }, { 0, 0 }, "drainsTo", sp_drainsto, t_schema, sch_vessel },
    { { 2, 0 }, { 0, 0 }, "driveWheelConfiguration", sp_drivewheelconfiguration, t_schema, sch_drivewheelconfigurationvalue },
    { { 2, 0 }, { 0, 0 }, "driveWheelConfiguration", sp_drivewheelconfiguration, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "driveWheelConfiguration", sp_drivewheelconfiguration, t_text },
    { { 2, 0 }, { 0, 0 }, "dropoffLocation", sp_dropofflocation, t_schema, sch_place },
    { { 2, 0 }, { 0, 0 }, "dropoffTime", sp_dropofftime, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "dropoffTime", sp_dropofftime, t_datetime },
    { { 2, 0 }, { 0, 0 }, "drug", sp_drug, t_schema, sch_drug },
    { { 2, 0 }, { 0, 0 }, "drugClass", sp_drugclass, t_schema, sch_drugclass },
    { { 2, 0 }, { 0, 0 }, "drugUnit", sp_drugunit, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "drugUnit", sp_drugunit, t_text },
    { { 2, 0 }, { 0, 0 }, "duns", sp_duns, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "duns", sp_duns, t_text },
    { { 2, 0 }, { 0, 0 }, "duplicateTherapy", sp_duplicatetherapy, t_schema, sch_medicaltherapy },
    { { 2, 0 }, { 0, 0 }, "duration", sp_duration, t_duration },
    { { 2, 0 }, { 0, 0 }, "durationOfWarranty", sp_durationofwarranty, t_schema, sch_quantitativevalue },
    { { 3, 3 }, { 0, 0 }, "duringMedia", sp_duringmedia, t_schema, sch_mediaobject },
    { { 3, 4 }, { 0, 0 }, "duringMedia", sp_duringmedia, t_schema, sch_url },
    { { 3, 4 }, { 0, 0 }, "duringMedia", sp_duringmedia, t_url },
    { { 3, 5 }, { 0, 0 }, "earlyPrepaymentPenalty", sp_earlyprepaymentpenalty, t_schema, sch_monetaryamount },
    { { 8, 0 }, { 0, 0 }, "editEIDR", sp_editeidr, t_schema, sch_text },
    { { 8, 0 }, { 0, 0 }, "editEIDR", sp_editeidr, t_text },
    { { 8, 0 }, { 0, 0 }, "editEIDR", sp_editeidr, t_schema, sch_url },
    { { 8, 0 }, { 0, 0 }, "editEIDR", sp_editeidr, t_url },
    { { 2, 0 }, { 0, 0 }, "editor", sp_editor, t_schema, sch_person },
    { { 3, 5 }, { 0, 0 }, "educationCredentialAwarded", sp_educationcredentialawarded, t_schema, sch_educationaloccupationalcredential },
    { { 3, 5 }, { 0, 0 }, "educationCredentialAwarded", sp_educationcredentialawarded, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "educationCredentialAwarded", sp_educationcredentialawarded, t_text },
    { { 3, 5 }, { 0, 0 }, "educationCredentialAwarded", sp_educationcredentialawarded, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "educationCredentialAwarded", sp_educationcredentialawarded, t_url },
    { { 3, 5 }, { 0, 0 }, "educationRequirements", sp_educationrequirements, t_schema, sch_educationaloccupationalcredential },
    { { 3, 6 }, { 0, 0 }, "educationRequirements", sp_educationrequirements, t_schema, sch_text },
    { { 3, 6 }, { 0, 0 }, "educationRequirements", sp_educationrequirements, t_text },
    { { 2, 0 }, { 0, 0 }, "educationalAlignment", sp_educationalalignment, t_schema, sch_alignmentobject },
    { { 3, 9 }, { 0, 0 }, "educationalCredentialAwarded", sp_educationalcredentialawarded, t_schema, sch_educationaloccupationalcredential },
    { { 3, 9 }, { 0, 0 }, "educationalCredentialAwarded", sp_educationalcredentialawarded, t_schema, sch_text },
    { { 3, 9 }, { 0, 0 }, "educationalCredentialAwarded", sp_educationalcredentialawarded, t_text },
    { { 3, 9 }, { 0, 0 }, "educationalCredentialAwarded", sp_educationalcredentialawarded, t_schema, sch_url },
    { { 3, 9 }, { 0, 0 }, "educationalCredentialAwarded", sp_educationalcredentialawarded, t_url },
    { { 2, 0 }, { 0, 0 }, "educationalFramework", sp_educationalframework, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "educationalFramework", sp_educationalframework, t_text },
    { { 3, 5 }, { 0, 0 }, "educationalLevel", sp_educationallevel, t_schema, sch_definedterm },
    { { 3, 5 }, { 0, 0 }, "educationalLevel", sp_educationallevel, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "educationalLevel", sp_educationallevel, t_text },
    { { 3, 5 }, { 0, 0 }, "educationalLevel", sp_educationallevel, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "educationalLevel", sp_educationallevel, t_url },
    { { 6, 0 }, { 0, 0 }, "educationalProgramMode", sp_educationalprogrammode, t_schema, sch_text },
    { { 6, 0 }, { 0, 0 }, "educationalProgramMode", sp_educationalprogrammode, t_text },
    { { 6, 0 }, { 0, 0 }, "educationalProgramMode", sp_educationalprogrammode, t_schema, sch_url },
    { { 6, 0 }, { 0, 0 }, "educationalProgramMode", sp_educationalprogrammode, t_url },
    { { 2, 0 }, { 0, 0 }, "educationalRole", sp_educationalrole, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "educationalRole", sp_educationalrole, t_text },
    { { 2, 0 }, { 0, 0 }, "educationalUse", sp_educationaluse, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "educationalUse", sp_educationaluse, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "educationalUse", sp_educationaluse, t_text },
    { { 10, 0 }, { 0, 0 }, "eduQuestionType", sp_eduquestiontype, t_text },
    { { 2, 0 }, { 0, 0 }, "elevation", sp_elevation, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "elevation", sp_elevation, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "elevation", sp_elevation, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "elevation", sp_elevation, t_text },
    { { 2, 0 }, { 0, 0 }, "eligibileCustomerType", sp_eligibilecustomertype, t_schema, sch_businessentitytype },
    { { 8, 0 }, { 0, 0 }, "eligibilityToWorkRequirement", sp_eligibilitytoworkrequirement, t_schema, sch_text },
    { { 8, 0 }, { 0, 0 }, "eligibilityToWorkRequirement", sp_eligibilitytoworkrequirement, t_text },
    { { 2, 0 }, { 0, 0 }, "eligibleCustomerType", sp_eligiblecustomertype, t_schema, sch_businessentitytype },
    { { 2, 0 }, { 0, 0 }, "eligibleDuration", sp_eligibleduration, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "eligibleQuantity", sp_eligiblequantity, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "eligibleRegion", sp_eligibleregion, t_schema, sch_geoshape },
    { { 2, 0 }, { 0, 0 }, "eligibleRegion", sp_eligibleregion, t_schema, sch_place },
    { { 2, 0 }, { 0, 0 }, "eligibleRegion", sp_eligibleregion, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "eligibleRegion", sp_eligibleregion, t_text },
    { { 2, 0 }, { 0, 0 }, "eligibleTransactionVolume", sp_eligibletransactionvolume, t_schema, sch_pricespecification },
    { { 2, 0 }, { 0, 0 }, "email", sp_email, t_email },
    { { 2, 0 }, { 0, 0 }, "embedUrl", sp_embedurl, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "embedUrl", sp_embedurl, t_url },
    { { 3, 5 }, { 0, 0 }, "emmissionsCO2", sp_emmissionsco2, t_schema, sch_number },
    { { 3, 5 }, { 0, 0 }, "emmissionsCO2", sp_emmissionsco2, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "employee", sp_employee, t_schema, sch_person },
    { { 6, 0 }, { 0, 0 }, "employerOverview", sp_employeroverview, t_schema, sch_text },
    { { 6, 0 }, { 0, 0 }, "employerOverview", sp_employeroverview, t_text },
    { { 2, 0 }, { 0, 0 }, "employmentType", sp_employmenttype, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "employmentType", sp_employmenttype, t_text },
    { { 4, 0 }, { 0, 0 }, "employmentUnit", sp_employmentunit, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "encodesCreativeWork", sp_encodescreativework, t_schema, sch_creativework },
    { { 2, 0 }, { 0, 0 }, "encoding", sp_encoding, t_schema, sch_mediaobject },
    { { 2, 0 }, { 0, 0 }, "encodingFormat", sp_encodingformat, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "encodingFormat", sp_encodingformat, t_text },
    { { 3, 4 }, { 0, 0 }, "encodingFormat", sp_encodingformat, t_schema, sch_url },
    { { 3, 4 }, { 0, 0 }, "encodingFormat", sp_encodingformat, t_url },
    { { 2, 0 }, { 0, 0 }, "encodingType", sp_encodingtype, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "encodingType", sp_encodingtype, t_text },
    { { 2, 0 }, { 0, 0 }, "endDate", sp_enddate, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "endDate", sp_enddate, t_datetime },
    { { 6, 0 }, { 0, 0 }, "endDate", sp_enddate, t_schema, sch_date },
    { { 6, 0 }, { 0, 0 }, "endDate", sp_enddate, t_just_date },
    { { 3, 5 }, { 0, 0 }, "endOffset", sp_endoffset, t_schema, sch_number },
    { { 3, 5 }, { 0, 0 }, "endOffset", sp_endoffset, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "endTime", sp_endtime, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "endTime", sp_endtime, t_datetime },
    { { 3, 8 }, { 0, 0 }, "endTime", sp_endtime, t_schema, sch_time },
    { { 3, 8 }, { 0, 0 }, "endTime", sp_endtime, t_just_time },
    { { 2, 0 }, { 0, 0 }, "endorsee", sp_endorsee, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "endorsee", sp_endorsee, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "endorsers", sp_endorsers, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "endorsers", sp_endorsers, t_schema, sch_person },
    { { 10, 0 }, { 0, 0 }, "energyEfficiencyScaleMax", sp_energyefficiencyscalemax, t_schema, sch_euenergyefficiencyenumeration },
    { { 10, 0 }, { 0, 0 }, "energyEfficiencyScaleMin", sp_energyefficiencyscalemin, t_schema, sch_euenergyefficiencyenumeration },
    { { 3, 5 }, { 0, 0 }, "engineDisplacement", sp_enginedisplacement, t_schema, sch_quantitativevalue },
    { { 3, 5 }, { 0, 0 }, "enginePower", sp_enginepower, t_schema, sch_quantitativevalue },
    { { 3, 5 }, { 0, 0 }, "engineType", sp_enginetype, t_schema, sch_qualitativevalue },
    { { 3, 5 }, { 0, 0 }, "engineType", sp_enginetype, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "engineType", sp_enginetype, t_text },
    { { 3, 5 }, { 0, 0 }, "engineType", sp_enginetype, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "engineType", sp_enginetype, t_url },
    { { 2, 0 }, { 0, 0 }, "entertainmentBusiness", sp_entertainmentbusiness, t_schema, sch_entertainmentbusiness },
    { { 2, 0 }, { 0, 0 }, "epidemiology", sp_epidemiology, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "epidemiology", sp_epidemiology, t_text },
    { { 2, 0 }, { 0, 0 }, "episode", sp_episode, t_schema, sch_episode },
    { { 2, 0 }, { 0, 0 }, "episodeNumber", sp_episodenumber, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "episodeNumber", sp_episodenumber, t_integer },
    { { 2, 0 }, { 0, 0 }, "episodeNumber", sp_episodenumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "episodeNumber", sp_episodenumber, t_text },
    { { 2, 0 }, { 0, 0 }, "equal", sp_equal, t_schema, sch_qualitativevalue },
    { { 2, 0 }, { 0, 0 }, "error", sp_error, t_schema, sch_thing },
    { { 3, 3 }, { 0, 0 }, "estimatedCost", sp_estimatedcost, t_schema, sch_monetaryamount },
    { { 3, 3 }, { 0, 0 }, "estimatedCost", sp_estimatedcost, t_schema, sch_text },
    { { 3, 3 }, { 0, 0 }, "estimatedCost", sp_estimatedcost, t_text },
    { { 2, 0 }, { 0, 0 }, "estimatedFlightDuration", sp_estimatedflightduration, t_schema, sch_duration },
    { { 2, 0 }, { 0, 0 }, "estimatedFlightDuration", sp_estimatedflightduration, t_duration },
    { { 2, 0 }, { 0, 0 }, "estimatedFlightDuration", sp_estimatedflightduration, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "estimatedFlightDuration", sp_estimatedflightduration, t_text },
    { { 3, 7 }, { 0, 0 }, "estimatedSalary", sp_estimatedsalary, t_schema, sch_number },
    { { 3, 7 }, { 0, 0 }, "estimatedSalary", sp_estimatedsalary, t_fixedpoint },
    { { 3, 7 }, { 0, 0 }, "estimatedSalary", sp_estimatedsalary, t_schema, sch_monetaryamount },
    { { 3, 5 }, { 0, 0 }, "estimatedSalary", sp_estimatedsalary, t_schema, sch_monetaryamountdistribution },
    { { 2, 0 }, { 0, 0 }, "estimatesRiskOf", sp_estimatesriskof, t_schema, sch_medicalentity },
    { { 3, 5 }, { 0, 0 }, "ethicsPolicy", sp_ethicspolicy, t_schema, sch_creativework },
    { { 3, 5 }, { 0, 0 }, "ethicsPolicy", sp_ethicspolicy, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "ethicsPolicy", sp_ethicspolicy, t_url },
    { { 2, 0 }, { 0, 0 }, "event", sp_event, t_schema, sch_event },
    { { 7, 0 }, { 0, 0 }, "eventAttendanceMode", sp_eventattendancemode, t_schema, sch_eventattendancemodeenumeration },
    { { 2, 0 }, { 0, 0 }, "eventSchedule", sp_eventschedule, t_schema, sch_schedule },
    { { 2, 0 }, { 0, 0 }, "eventStatus", sp_eventstatus, t_schema, sch_eventstatustype },
    { { 2, 0 }, { 0, 0 }, "evidenceLevel", sp_evidencelevel, t_schema, sch_medicalevidencelevel },
    { { 2, 0 }, { 0, 0 }, "evidenceOrigin", sp_evidenceorigin, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "evidenceOrigin", sp_evidenceorigin, t_text },
    { { 2, 0 }, { 0, 0 }, "exampleOfWork", sp_exampleofwork, t_schema, sch_creativework },
    { { 3, 5 }, { 0, 0 }, "exceptDate", sp_exceptdate, t_schema, sch_datetime },
    { { 3, 5 }, { 0, 0 }, "exceptDate", sp_exceptdate, t_datetime },
    { { 3, 5 }, { 0, 0 }, "exceptDate", sp_exceptdate, t_schema, sch_date },
    { { 3, 5 }, { 0, 0 }, "exceptDate", sp_exceptdate, t_just_date },
    { { 3, 5 }, { 0, 0 }, "exchangeRateSpread", sp_exchangeratespread, t_schema, sch_number },
    { { 3, 5 }, { 0, 0 }, "exchangeRateSpread", sp_exchangeratespread, t_fixedpoint },
    { { 3, 5 }, { 0, 0 }, "exchangeRateSpread", sp_exchangeratespread, t_schema, sch_monetaryamount },
    { { 2, 0 }, { 0, 0 }, "executableLibraryName", sp_executablelibraryname, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "executableLibraryName", sp_executablelibraryname, t_text },
    { { 2, 0 }, { 0, 0 }, "exerciseCourse", sp_exercisecourse, t_schema, sch_place },
    { { 2, 0 }, { 0, 0 }, "exercisePlan", sp_exerciseplan, t_schema, sch_exerciseplan },
    { { 2, 0 }, { 0, 0 }, "exerciseRelatedDiet", sp_exerciserelateddiet, t_schema, sch_diet },
    { { 2, 0 }, { 0, 0 }, "exerciseType", sp_exercisetype, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "exerciseType", sp_exercisetype, t_text },
    { { 2, 0 }, { 0, 0 }, "exifData", sp_exifdata, t_schema, sch_propertyvalue },
    { { 2, 0 }, { 0, 0 }, "exifData", sp_exifdata, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "exifData", sp_exifdata, t_text },
    { { 2, 0 }, { 0, 0 }, "expectedArrivalFrom", sp_expectedarrivalfrom, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "expectedArrivalFrom", sp_expectedarrivalfrom, t_datetime },
    { { 3, 8 }, { 0, 0 }, "expectedArrivalFrom", sp_expectedarrivalfrom, t_schema, sch_date },
    { { 3, 8 }, { 0, 0 }, "expectedArrivalFrom", sp_expectedarrivalfrom, t_just_date },
    { { 2, 0 }, { 0, 0 }, "expectedArrivalUntil", sp_expectedarrivaluntil, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "expectedArrivalUntil", sp_expectedarrivaluntil, t_datetime },
    { { 3, 8 }, { 0, 0 }, "expectedArrivalUntil", sp_expectedarrivaluntil, t_schema, sch_date },
    { { 3, 8 }, { 0, 0 }, "expectedArrivalUntil", sp_expectedarrivaluntil, t_just_date },
    { { 2, 0 }, { 0, 0 }, "expectedPrognosis", sp_expectedprognosis, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "expectedPrognosis", sp_expectedprognosis, t_text },
    { { 2, 0 }, { 0, 0 }, "expectsAcceptanceOf", sp_expectsacceptanceof, t_schema, sch_offer },
    { { 2, 0 }, { 0, 0 }, "expeienceRequirements", sp_expeiencerequirements, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "expeienceRequirements", sp_expeiencerequirements, t_text },
    { { 3, 5 }, { 0, 0 }, "experienceRequirements", sp_experiencerequirements, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "experienceRequirements", sp_experiencerequirements, t_text },
    { { 2, 0 }, { 0, 0 }, "expires", sp_expires, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "expires", sp_expires, t_datetime },
    { { 2, 0 }, { 0, 0 }, "exportConsiderations", sp_exportconsiderations, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "exportConsiderations", sp_exportconsiderations, t_text },
    { { 2, 0 }, { 0, 0 }, "familyName", sp_familyname, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "familyName", sp_familyname, t_text },
    { { 2, 0 }, { 0, 0 }, "fatContent", sp_fatcontent, t_schema, sch_mass },
    { { 2, 0 }, { 0, 0 }, "faxNumber", sp_faxnumber, t_tel },
    { { 2, 0 }, { 0, 0 }, "featureList", sp_featurelist, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "featureList", sp_featurelist, t_text },
    { { 2, 0 }, { 0, 0 }, "featureList", sp_featurelist, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "featureList", sp_featurelist, t_url },
    { { 3, 0 }, { 0, 0 }, "feesandcommissionsspecification", sp_feesandcommissionsspecification, t_text },
    { { 3, 0 }, { 0, 0 }, "feesandcommissionsspecification", sp_feesandcommissionsspecification, t_url },
    { { 2, 0 }, { 0, 0 }, "fiberContent", sp_fibrecontent, t_schema, sch_mass },
    { { 2, 0 }, { 3, 3 }, "fileFormat", sp_fileformat, t_schema, sch_text },
    { { 2, 0 }, { 3, 3 }, "fileFormat", sp_fileformat, t_text },
    { { 2, 0 }, { 0, 0 }, "fileSize", sp_filesize, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "fileSize", sp_filesize, t_text },
    { { 6, 0 }, { 0, 0 }, "financialAidEligible", sp_financialaideligible, t_schema, sch_definedterm },
    { { 6, 0 }, { 0, 0 }, "financialAidEligible", sp_financialaideligible, t_schema, sch_text },
    { { 6, 0 }, { 0, 0 }, "financialAidEligible", sp_financialaideligible, t_text },
    { { 3, 5 }, { 0, 0 }, "firstAppearance", sp_firstappearance, t_schema, sch_creativework },
    { { 2, 0 }, { 0, 0 }, "firstPerformance", sp_firstperformance, t_schema, sch_event },
    { { 2, 0 }, { 0, 0 }, "flightDistance", sp_flightdistance, t_schema, sch_distance },
    { { 2, 0 }, { 0, 0 }, "flightDistance", sp_flightdistance, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "flightDistance", sp_flightdistance, t_text },
    { { 2, 0 }, { 0, 0 }, "flightNumber", sp_flightnumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "flightNumber", sp_flightnumber, t_text },
    { { 5, 0 }, { 0, 0 }, "floorLevel", sp_floorlevel, t_schema, sch_text },
    { { 5, 0 }, { 0, 0 }, "floorLevel", sp_floorlevel, t_text },
    { { 3, 5 }, { 0, 0 }, "floorLimit", sp_floorlimit, t_schema, sch_monetaryamount },
    { { 7, 0 }, { 0, 0 }, "floorSize", sp_floorsize, t_schema, sch_qualitativevalue },
    { { 3, 1 }, { 0, 0 }, "floorSize", sp_floorsize, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "followee", sp_followee, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "followee", sp_followee, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "follows", sp_follows, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "followup", sp_followup, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "followup", sp_followup, t_text },
    { { 2, 0 }, { 0, 0 }, "foodEstablishment", sp_foodestablishment, t_schema, sch_foodestablishment },
    { { 2, 0 }, { 0, 0 }, "foodEstablishment", sp_foodestablishment, t_schema, sch_place },
    { { 2, 0 }, { 0, 0 }, "foodEvent", sp_foodevent, t_schema, sch_foodevent },
    { { 2, 0 }, { 0, 0 }, "foodWarning", sp_foodwarning, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "foodWarning", sp_foodwarning, t_text },
    { { 2, 0 }, { 0, 0 }, "founder", sp_founder, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "foundingDate", sp_foundingdate, t_schema, sch_date },
    { { 2, 0 }, { 0, 0 }, "foundingDate", sp_foundingdate, t_just_date },
    { { 2, 0 }, { 0, 0 }, "foundingLocation", sp_foundinglocation, t_schema, sch_place },
    { { 8, 0 }, { 0, 0 }, "freeShippingThreshold", sp_freeshippingthreshold, t_schema, sch_deliverychargespecification },
    { { 8, 0 }, { 0, 0 }, "freeShippingThreshold", sp_freeshippingthreshold, t_schema, sch_monetaryamount },
    { { 2, 0 }, { 0, 0 }, "frequency", sp_frequency, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "frequency", sp_frequency, t_text },
    { { 2, 0 }, { 0, 0 }, "fromLocation", sp_fromlocation, t_schema, sch_place },
    { { 3, 5 }, { 0, 0 }, "fuelCapacity", sp_fuelcapacity, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "fuelConsumption", sp_fuelconsumption, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "fuelEfficiency", sp_fuelefficiency, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "fueltype", sp_fueltype, t_schema, sch_qualitativevalue },
    { { 2, 0 }, { 0, 0 }, "fueltype", sp_fueltype, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "fueltype", sp_fueltype, t_text },
    { { 2, 0 }, { 0, 0 }, "fueltype", sp_fueltype, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "fueltype", sp_fueltype, t_url },
    { { 3, 5 }, { 0, 0 }, "funcionalClass", sp_funcionalclass, t_schema, sch_medicalentity },
    { { 2, 0 }, { 0, 0 }, "funcionalClass", sp_funcionalclass, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "funcionalClass", sp_funcionalclass, t_text },
    { { 2, 0 }, { 6, 0 }, "function", sp_function, t_schema, sch_text },
    { { 2, 0 }, { 6, 0 }, "function", sp_function, t_text },
    { { 3, 5 }, { 0, 0 }, "fundedItem", sp_fundeditem, t_schema, sch_thing },
    { { 3, 1 }, { 0, 0 }, "funder", sp_funder, t_schema, sch_organisation },
    { { 3, 1 }, { 0, 0 }, "funder", sp_funder, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "game", sp_game, t_schema, sch_videogame },
    { { 2, 0 }, { 0, 0 }, "gameItem", sp_gameitem, t_schema, sch_thing },
    { { 2, 0 }, { 0, 0 }, "gameLocation", sp_gamelocation, t_schema, sch_place },
    { { 2, 0 }, { 0, 0 }, "gameLocation", sp_gamelocation, t_schema, sch_postaladdress },
    { { 2, 0 }, { 0, 0 }, "gameLocation", sp_gamelocation, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "gameLocation", sp_gamelocation, t_url },
    { { 2, 0 }, { 0, 0 }, "gamePlatform", sp_gameplatform, t_schema, sch_thing },
    { { 2, 0 }, { 0, 0 }, "gamePlatform", sp_gameplatform, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "gamePlatform", sp_gameplatform, t_text },
    { { 2, 0 }, { 0, 0 }, "gamePlatform", sp_gameplatform, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "gamePlatform", sp_gameplatform, t_url },
    { { 2, 0 }, { 0, 0 }, "gameServer", sp_gameserver, t_schema, sch_gameserver },
    { { 2, 0 }, { 0, 0 }, "gameTip", sp_gametip, t_schema, sch_creativework },
    { { 3, 0 }, { 0, 0 }, "gender", sp_gender, t_schema, sch_gendertype },
    { { 2, 0 }, { 0, 0 }, "gender", sp_gender, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "gender", sp_gender, t_text },
    { { 2, 0 }, { 0, 0 }, "genre", sp_genre, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "genre", sp_genre, t_text },
    { { 2, 0 }, { 0, 0 }, "genre", sp_genre, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "genre", sp_genre, t_url },
    { { 2, 0 }, { 0, 0 }, "geo", sp_geo, t_schema, sch_geocoordinates },
    { { 2, 0 }, { 0, 0 }, "geo", sp_geo, t_schema, sch_geoshape },
    { { 3, 5 }, { 0, 0 }, "geoContains", sp_geocontains, t_schema, sch_geospatialgeometry },
    { { 3, 5 }, { 0, 0 }, "geoContains", sp_geocontains, t_schema, sch_place },
    { { 3, 5 }, { 0, 0 }, "geoCoveredBy", sp_geocoveredby, t_schema, sch_geospatialgeometry },
    { { 3, 5 }, { 0, 0 }, "geoCoveredBy", sp_geocoveredby, t_schema, sch_place },
    { { 3, 5 }, { 0, 0 }, "geoCovers", sp_geocovers, t_schema, sch_geospatialgeometry },
    { { 3, 5 }, { 0, 0 }, "geoCovers", sp_geocovers, t_schema, sch_place },
    { { 3, 5 }, { 0, 0 }, "geoCrosses", sp_geocrosses, t_schema, sch_geospatialgeometry },
    { { 3, 5 }, { 0, 0 }, "geoCrosses", sp_geocrosses, t_schema, sch_place },
    { { 3, 5 }, { 0, 0 }, "geoDisjoint", sp_geodisjoint, t_schema, sch_geospatialgeometry },
    { { 3, 5 }, { 0, 0 }, "geoDisjoint", sp_geodisjoint, t_schema, sch_place },
    { { 3, 5 }, { 0, 0 }, "geoEquals", sp_geoequals, t_schema, sch_geospatialgeometry },
    { { 3, 5 }, { 0, 0 }, "geoEquals", sp_geoequals, t_schema, sch_place },
    { { 3, 5 }, { 0, 0 }, "geoIntersects", sp_geointersects, t_schema, sch_geospatialgeometry },
    { { 3, 5 }, { 0, 0 }, "geoIntersects", sp_geointersects, t_schema, sch_place },
    { { 2, 2 }, { 0, 0 }, "geoMidpoint", sp_geomidpoint, t_schema, sch_geocoordinates },
    { { 3, 5 }, { 0, 0 }, "geoOverlaps", sp_geooverlaps, t_schema, sch_geospatialgeometry },
    { { 3, 5 }, { 0, 0 }, "geoOverlaps", sp_geooverlaps, t_schema, sch_place },
    { { 2, 2 }, { 0, 0 }, "geoRadius", sp_georadius, t_schema, sch_number },
    { { 2, 2 }, { 0, 0 }, "geoRadius", sp_georadius, t_fixedpoint },
    { { 2, 2 }, { 0, 0 }, "geoRadius", sp_georadius, t_schema, sch_distance },
    { { 2, 2 }, { 0, 0 }, "geoRadius", sp_georadius, t_schema, sch_text },
    { { 2, 2 }, { 0, 0 }, "geoRadius", sp_georadius, t_text },
    { { 3, 5 }, { 0, 0 }, "geoTouches", sp_geotouches, t_schema, sch_geospatialgeometry },
    { { 3, 5 }, { 0, 0 }, "geoTouches", sp_geotouches, t_schema, sch_place },
    { { 3, 5 }, { 0, 0 }, "geoWithin", sp_geowithin, t_schema, sch_geospatialgeometry },
    { { 3, 5 }, { 0, 0 }, "geoWithin", sp_geowithin, t_schema, sch_place },
    { { 2, 0 }, { 0, 0 }, "geographicArea", sp_geographicarea, t_schema, sch_administrativearea },
    { { 7, 0 }, { 0, 0 }, "gettingTestedInfo", sp_gettingtestedinfo, t_schema, sch_webcontent },
    { { 7, 0 }, { 0, 0 }, "gettingTestedInfo", sp_gettingtestedinfo, t_schema, sch_url },
    { { 7, 0 }, { 0, 0 }, "gettingTestedInfo", sp_gettingtestedinfo, t_url },
    { { 2, 0 }, { 0, 0 }, "givenName", sp_givenname, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "givenName", sp_givenname, t_text },
    { { 2, 0 }, { 0, 0 }, "globalLocationNumber", sp_globallocationnumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "globalLocationNumber", sp_globallocationnumber, t_text },
    { { 7, 4 }, { 0, 0 }, "governmentBenefitsInfo", sp_governmentbenefitsinfo, t_schema, sch_governmentservice },
    { { 3, 5 }, { 0, 0 }, "gracePeriod", sp_graceperiod, t_schema, sch_duration },
    { { 3, 5 }, { 0, 0 }, "gracePeriod", sp_graceperiod, t_duration },
    { { 3, 0 }, { 0, 0 }, "grantee", sp_grantee, t_schema, sch_audience },
    { { 3, 0 }, { 0, 0 }, "grantee", sp_grantee, t_schema, sch_contactpoint },
    { { 3, 0 }, { 0, 0 }, "grantee", sp_grantee, t_schema, sch_organisation },
    { { 3, 0 }, { 0, 0 }, "grantee", sp_grantee, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "greater", sp_greater, t_schema, sch_qualitativevalue },
    { { 2, 0 }, { 0, 0 }, "greaterOrEqual", sp_greaterorequal, t_schema, sch_qualitativevalue },
    { { 3, 8 }, { 0, 0 }, "gtin", sp_gtin, t_schema, sch_text },
    { { 3, 8 }, { 0, 0 }, "gtin", sp_gtin, t_text },
    { { 2, 0 }, { 0, 0 }, "gtin12", sp_gtin12, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "gtin12", sp_gtin12, t_text },
    { { 2, 0 }, { 0, 0 }, "gtin13", sp_gtin13, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "gtin13", sp_gtin13, t_text },
    { { 2, 0 }, { 0, 0 }, "gtin14", sp_gtin14, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "gtin14", sp_gtin14, t_text },
    { { 2, 0 }, { 0, 0 }, "gtin8", sp_gtin8, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "gtin8", sp_gtin8, t_text },
    { { 2, 0 }, { 0, 0 }, "guideline", sp_guideline, t_schema, sch_medicalguideline },
    { { 2, 0 }, { 0, 0 }, "guidelineDate", sp_guidelinedate, t_schema, sch_date },
    { { 2, 0 }, { 0, 0 }, "guidelineDate", sp_guidelinedate, t_just_date },
    { { 2, 0 }, { 0, 0 }, "guidelineSubject", sp_guidelinesubject, t_schema, sch_medicalentity },
    { { 8, 0 }, { 0, 0 }, "handlingTime", sp_handlingtime, t_schema, sch_quantitativevalue },
    { { 3, 5 }, { 0, 0 }, "hasBroadcastChannel", sp_hasbroadcastchannel, t_schema, sch_broadcastchannel },
    { { 3, 5 }, { 0, 0 }, "hasCategoryCode", sp_hascategorycode, t_schema, sch_categorycode },
    { { 3, 4 }, { 0, 0 }, "hasCourseInstance", sp_hascourseinstance, t_schema, sch_courseinstance },
    { { 10, 0 }, { 0, 0 }, "hasCourse", sp_hascourse, t_schema, sch_course },
    { { 3, 9 }, { 0, 0 }, "hasCredential", sp_hascredential, t_schema, sch_educationaloccupationalcredential },
    { { 3, 5 }, { 0, 0 }, "hasDefinedTerm", sp_hasdefinedterm, t_schema, sch_definedterm },
    { { 2, 0 }, { 0, 0 }, "hasDeliveryMethod", sp_hasdeliverymethod, t_schema, sch_deliverymethod },
    { { 3, 0 }, { 0, 0 }, "hasDigitalDocumentPermission", sp_hasdigitaldocumentpermission, t_schema, sch_digitaldocumentpermission },
    { { 7, 0 }, { 0, 0 }, "hasDriveThroughService", sp_hasdrivethroughservice, t_schema, sch_boolean },
    { { 7, 0 }, { 0, 0 }, "hasDriveThroughService", sp_hasdrivethroughservice, t_bool },
    { { 10, 0 }, { 0, 0 }, "hasEnergyConsumptionDetails", sp_hasenergyconsumptiondetails, t_schema, sch_energyconsumptiondetails },
    { { 10, 0 }, { 0, 0 }, "hasEnergyEfficiencyCategory", sp_hasenergyefficiencycategory, t_schema, sch_energyefficiencyenumeration },
    { { 5, 0 }, { 0, 0 }, "hasHealthAspect", sp_hashealthaspect, t_schema, sch_healthaspectenumeration },
    { { 2, 0 }, { 0, 0 }, "hasMap", sp_hasmap, t_schema, sch_map },
    { { 2, 0 }, { 0, 0 }, "hasMap", sp_hasmap, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "hasMap", sp_hasmap, t_url },
    { { 3, 2 }, { 0, 0 }, "hasMenu", sp_hasmenu, t_schema, sch_menu },
    { { 3, 2 }, { 0, 0 }, "hasMenu", sp_hasmenu, t_url },
    { { 3, 2 }, { 0, 0 }, "hasMenu", sp_hasmenu, t_text },
    { { 3, 3 }, { 0, 0 }, "hasMenuItem", sp_hasmenuitem, t_schema, sch_menuitem },
    { { 3, 3 }, { 0, 0 }, "hasMenuSection", sp_hasmenusection, t_schema, sch_menusection },
    { { 6, 0 }, { 0, 0 }, "hasMerchantReturnPolicy", sp_hasmerchantreturnpolicy, t_schema, sch_merchantreturnpolicy },
    { { 3, 5 }, { 0, 0 }, "hasOccupation", sp_hasoccupation, t_schema, sch_occupation },
    { { 2, 2 }, { 0, 0 }, "hasOfferCatalog", sp_hasoffercatalogue, t_schema, sch_offercatalogue },
    { { 2, 0 }, { 0, 0 }, "hasPOS", sp_haspos, t_schema, sch_place },
    { { 2, 0 }, { 0, 0 }, "hasPart", sp_haspart, t_schema, sch_creativework },
    { { 3, 8 }, { 0, 0 }, "hasProductReturnPolicy", sp_hasproductreturnpolicy, t_schema, sch_productreturnpolicy },
    { { 9, 0 }, { 0, 0 }, "hasVariant", sp_hasvariant, t_schema, sch_product },
    { { 2, 0 }, { 0, 0 }, "headline", sp_headline, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "headline", sp_headline, t_text },
    { { 2, 0 }, { 0, 0 }, "healthCondition", sp_healthcondition, t_schema, sch_medicalcondition },
    { { 3, 5 }, { 0, 0 }, "healthPlanCoinsuranceOption", sp_healthplancoinsuranceoption, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "healthPlanCoinsuranceOption", sp_healthplancoinsuranceoption, t_text },
    { { 3, 5 }, { 0, 0 }, "healthPlanCoinsuranceRate", sp_healthplancoinsurancerate, t_schema, sch_number },
    { { 3, 5 }, { 0, 0 }, "healthPlanCoinsuranceRate", sp_healthplancoinsurancerate, t_fixedpoint },
    { { 3, 5 }, { 0, 0 }, "healthPlanCopay", sp_healthplancopay, t_schema, sch_pricespecification },
    { { 3, 5 }, { 0, 0 }, "healthPlanCopayOption", sp_healthplancopayoption, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "healthPlanCopayOption", sp_healthplancopayoption, t_text },
    { { 3, 5 }, { 0, 0 }, "healthPlanCostSharing", sp_healthplancostsharing, t_schema, sch_boolean },
    { { 3, 5 }, { 0, 0 }, "healthPlanCostSharing", sp_healthplancostsharing, t_bool },
    { { 3, 5 }, { 0, 0 }, "healthPlanDrugOption", sp_healthplandrugoption, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "healthPlanDrugOption", sp_healthplandrugoption, t_text },
    { { 3, 5 }, { 0, 0 }, "healthPlanDrugTier", sp_healthplandrugtier, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "healthPlanDrugTier", sp_healthplandrugtier, t_text },
    { { 3, 5 }, { 0, 0 }, "healthPlanId", sp_healthplanid, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "healthPlanId", sp_healthplanid, t_text },
    { { 3, 5 }, { 0, 0 }, "healthPlanMarketingUrl", sp_healthplanmarketingurl, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "healthPlanMarketingUrl", sp_healthplanmarketingurl, t_url },
    { { 3, 5 }, { 0, 0 }, "healthPlanNetworkId", sp_dystopianhealthplannetworkid, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "healthPlanNetworkId", sp_dystopianhealthplannetworkid, t_text },
    { { 3, 5 }, { 0, 0 }, "healthPlanNetworkId", sp_healthplannetworkid, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "healthPlanNetworkId", sp_healthplannetworkid, t_text },
    { { 3, 5 }, { 0, 0 }, "healthPlanNetworkTier", sp_healthplannetworktier, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "healthPlanNetworkTier", sp_healthplannetworktier, t_text },
    { { 3, 5 }, { 0, 0 }, "healthPlanPharmacyCategory", sp_healthplanpharmacycategory, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "healthPlanPharmacyCategory", sp_healthplanpharmacycategory, t_text },
    { { 7, 3 }, { 0, 0 }, "healthcareReportingData", sp_healthcarereportingdata, t_schema, sch_cdcpmdrecord },
    { { 7, 3 }, { 0, 0 }, "healthcareReportingData", sp_healthcarereportingdata, t_schema, sch_dataset },
    { { 2, 0 }, { 0, 0 }, "height", sp_height, t_schema, sch_distance },
    { { 2, 0 }, { 0, 0 }, "height", sp_height, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "highPrice", sp_highprice, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "highPrice", sp_highprice, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "hiringOrganization", sp_hiringorganization, t_schema, sch_organisation },
    { { 3, 5 }, { 0, 0 }, "holdingArchive", sp_holdingarchive, t_schema, sch_archiveorganisation },
    { { 2, 0 }, { 0, 0 }, "homeLocation", sp_homelocation, t_schema, sch_contactpoint },
    { { 2, 0 }, { 0, 0 }, "homeLocation", sp_homelocation, t_schema, sch_place },
    { { 2, 0 }, { 0, 0 }, "homeTeam", sp_hometeam, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "homeTeam", sp_hometeam, t_schema, sch_sportsteam },
    { { 2, 0 }, { 0, 0 }, "honourificPrefix", sp_honourificprefix, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "honourificPrefix", sp_honourificprefix, t_text },
    { { 2, 0 }, { 0, 0 }, "honourificSuffix", sp_honourificsuffix, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "honourificSuffix", sp_honourificsuffix, t_text },
    { { 2, 0 }, { 0, 0 }, "hospitalAffiliation", sp_hospitalaffiliation, t_schema, sch_hospital },
    { { 2, 0 }, { 0, 0 }, "hostingOrganization", sp_hostingorganisation, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "hoursAvailable", sp_hoursavailable, t_schema, sch_openinghoursspecification },
    { { 2, 0 }, { 0, 0 }, "howPerformed", sp_howperformed, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "howPerformed", sp_howperformed, t_text },
    { { 2, 0 }, { 0, 0 }, "httpMethod", sp_httpmethod, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "httpMethod", sp_httpmethod, t_text },
    { { 2, 0 }, { 0, 0 }, "iataCode", sp_iatacode, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "iataCode", sp_iatacode, t_text },
    { { 3, 2 }, { 0, 0 }, "identifier", sp_identifier, t_schema, sch_propertyvalue },
    { { 3, 2 }, { 0, 0 }, "identifier", sp_identifier, t_schema, sch_text },
    { { 3, 2 }, { 0, 0 }, "identifier", sp_identifier, t_text },
    { { 3, 2 }, { 0, 0 }, "identifier", sp_identifier, t_schema, sch_url },
    { { 3, 2 }, { 0, 0 }, "identifier", sp_identifier, t_url },
    { { 2, 0 }, { 0, 0 }, "identifyingExam", sp_identifyingexam, t_schema, sch_physicalexam },
    { { 2, 0 }, { 0, 0 }, "identifyingTest", sp_identifyingtest, t_schema, sch_medicaltest },
    { { 2, 0 }, { 0, 0 }, "illustrator", sp_illustrator, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "image", sp_image, t_schema, sch_imageobject },
    { { 2, 0 }, { 0, 0 }, "image", sp_image, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "image", sp_image, t_url },
    { { 2, 0 }, { 0, 0 }, "imagingTechnique", sp_imagingtechnique, t_schema, sch_medicalimagingtechnique },
    { { 2, 0 }, { 0, 0 }, "inAlbum", sp_inalbum, t_schema, sch_musicalbum },
    { { 2, 0 }, { 0, 0 }, "inBroadcastLineup", sp_inbroadcastlineup, t_schema, sch_cableorsatelliteservice },
    { { 3, 5 }, { 0, 0 }, "inCodeSet", sp_incodeset, t_schema, sch_categorycodeset },
    { { 3, 5 }, { 0, 0 }, "inCodeSet", sp_incodeset, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "inCodeSet", sp_incodeset, t_url },
    { { 3, 5 }, { 0, 0 }, "inDefinedTermSet", sp_indefinedtermset, t_schema, sch_definedtermset },
    { { 3, 5 }, { 0, 0 }, "inDefinedTermSet", sp_indefinedtermset, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "inDefinedTermSet", sp_indefinedtermset, t_url },
    { { 2, 0 }, { 0, 0 }, "inLanguage", sp_inlanguage, t_schema, sch_language },
    { { 2, 0 }, { 0, 0 }, "inLanguage", sp_inlanguage, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "inLanguage", sp_inlanguage, t_text },
    { { 2, 0 }, { 0, 0 }, "inPlaylist", sp_inplaylist, t_schema, sch_musicplaylist },
    { { 9, 0 }, { 0, 0 }, "inProductGroupWithID", sp_inproductgroupwithid },
    { { 6, 0 }, { 0, 0 }, "inStoreReturnsOffered", sp_instorereturnsoffered, t_schema, sch_boolean },
    { { 6, 0 }, { 0, 0 }, "inStoreReturnsOffered", sp_instorereturnsoffered, t_bool },
    { { 3, 5 }, { 0, 0 }, "inSupportOf", sp_insupportof, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "inSupportOf", sp_insupportof, t_text },
    { { 2, 0 }, { 0, 0 }, "incentiveCompensation", sp_incentivecompensation, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "incentiveCompensation", sp_incentivecompensation, t_text },
    { { 2, 0 }, { 0, 0 }, "includedComposition", sp_includedcomposition, t_schema, sch_musiccomposition },
    { { 2, 0 }, { 0, 0 }, "includedDataCatalog", sp_includeddatacatalog, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "includedDataCatalog", sp_includeddatacatalog, t_datetime },
    { { 3, 5 }, { 0, 0 }, "includedInHealthInsurancePlan", sp_includedinhealthinsuranceplan, t_schema, sch_dystopianhealthinsuranceplan },
    { { 2, 0 }, { 0, 0 }, "includedRiskFactor", sp_includedriskfactor, t_schema, sch_medicalriskfactor },
    { { 3, 5 }, { 0, 0 }, "includesAttraction", sp_includesattraction, t_schema, sch_touristattraction },
    { { 3, 5 }, { 0, 0 }, "includesHealthPlanFormulary", sp_includeshealthplanformulary, t_schema, sch_dystopianhealthplanformulary },
    { { 3, 5 }, { 0, 0 }, "includesHealthPlanNetwork", sp_includeshealthplannetwork, t_schema, sch_dystopianhealthplannetwork },
    { { 2, 0 }, { 0, 0 }, "includesObject", sp_includesobject, t_schema, sch_typeandquantitynode },
    { { 2, 0 }, { 0, 0 }, "increasesRiskOf", sp_increasesriskof, t_schema, sch_medicalentity },
    { { 2, 0 }, { 6, 0 }, "indication", sp_indication, t_schema, sch_medicalindication },
    { { 6, 0 }, { 0, 0 }, "industry", sp_industry, t_schema, sch_definedterm },
    { { 2, 0 }, { 0, 0 }, "industry", sp_industry, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "industry", sp_industry, t_text },
    { { 2, 0 }, { 0, 0 }, "ineligibleRegion", sp_ineligibleregion, t_schema, sch_geoshape },
    { { 2, 0 }, { 0, 0 }, "ineligibleRegion", sp_ineligibleregion, t_schema, sch_place },
    { { 2, 0 }, { 0, 0 }, "ineligibleRegion", sp_ineligibleregion, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "ineligibleRegion", sp_ineligibleregion, t_text },
    { { 2, 0 }, { 0, 0 }, "infectiousAgent", sp_infectiousagent, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "infectiousAgent", sp_infectiousagent, t_text },
    { { 2, 0 }, { 0, 0 }, "infectiousAgentClass", sp_infectiousagentclass, t_schema, sch_infectiousagentclass },
    { { 3, 5 }, { 0, 0 }, "inker", sp_inker, t_schema, sch_person },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "insertion", sp_insertion, t_schema, sch_anatomicalstructure },
    { { 2, 0 }, { 0, 0 }, "installUrl", sp_installurl, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "installUrl", sp_installurl, t_url },
    { { 3, 4 }, { 0, 0 }, "instructor", sp_instructor, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "instrument", sp_instrument, t_schema, sch_thing },
    { { 3, 5 }, { 0, 0 }, "intensity", sp_intensity, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "intensity", sp_intensity, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "intensity", sp_intensity, t_text },
    { { 2, 0 }, { 0, 0 }, "interactingDrug", sp_interactingdrug, t_schema, sch_drug },
    { { 2, 0 }, { 0, 0 }, "interactionService", sp_interactionservice, t_schema, sch_softwareapplication },
    { { 2, 0 }, { 0, 0 }, "interactionService", sp_interactionservice, t_schema, sch_website },
    { { 2, 1 }, { 0, 0 }, "interactionStatistic", sp_interactionstatistic, t_schema, sch_interactioncounter },
    { { 2, 0 }, { 0, 0 }, "interactionType", sp_interactiontype, t_schema, sch_action, SP_VALUE_TYPENAME },
    { { 2, 0 }, { 0, 0 }, "interactivityType", sp_interactivitytype, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "interactivityType", sp_interactivitytype, t_text },
    { { 3, 0 }, { 0, 0 }, "interestrate", sp_interestrate, t_schema, sch_number },
    { { 3, 0 }, { 0, 0 }, "interestrate", sp_interestrate, t_fixedpoint },
    { { 3, 0 }, { 0, 0 }, "interestrate", sp_interestrate, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "inventoryLevel", sp_inventorylevel, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "inverseOf", sp_inverseof, t_schema, sch_property },
    { { 3, 5 }, { 0, 0 }, "isAcceptingNewPatients", sp_isacceptingnewpatients, t_schema, sch_boolean },
    { { 3, 5 }, { 0, 0 }, "isAcceptingNewPatients", sp_isacceptingnewpatients, t_bool },
    { { 2, 0 }, { 0, 0 }, "isAccessibleForFree", sp_isaccessibleforfree, t_schema, sch_boolean },
    { { 2, 0 }, { 0, 0 }, "isAccessibleForFree", sp_isaccessibleforfree, t_bool },
    { { 2, 0 }, { 0, 0 }, "isAccessoryOrSparePartFor", sp_isaccessoryorsparepartfor, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "isAccessoryOrSparePartFor", sp_isaccessoryorsparepartfor, t_text },
    { { 2, 0 }, { 0, 0 }, "isAvailableGenerally", sp_isavailablegenerally, t_schema, sch_boolean },
    { { 2, 0 }, { 0, 0 }, "isAvailableGenerally", sp_isavailablegenerally, t_bool },
    { { 3, 0 }, { 0, 0 }, "isBasedOn", sp_isbasedon, t_schema, sch_creativework },
    { { 3, 0 }, { 0, 0 }, "isBasedOn", sp_isbasedon, t_schema, sch_product },
    { { 3, 0 }, { 0, 0 }, "isBasedOn", sp_isbasedon, t_schema, sch_url },
    { { 3, 0 }, { 0, 0 }, "isBasedOn", sp_isbasedon, t_url },
    { { 2, 0 }, { 0, 0 }, "isBasedOnUrl", sp_isbasedonurl, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "isBasedOnUrl", sp_isbasedonurl, t_url },
    { { 2, 0 }, { 0, 0 }, "isConsumableFor", sp_isconsumablefor, t_schema, sch_product },
    { { 2, 0 }, { 0, 0 }, "isFamilyFriendly", sp_isfamilyfriendly, t_schema, sch_boolean },
    { { 2, 0 }, { 0, 0 }, "isFamilyFriendly", sp_isfamilyfriendly, t_bool },
    { { 2, 0 }, { 0, 0 }, "isGift", sp_isgift, t_schema, sch_boolean },
    { { 2, 0 }, { 0, 0 }, "isGift", sp_isgift, t_bool },
    { { 2, 0 }, { 0, 0 }, "isLiveBroadcast", sp_islivebroadcast, t_schema, sch_boolean },
    { { 2, 0 }, { 0, 0 }, "isLiveBroadcast", sp_islivebroadcast, t_bool },
    { { 2, 0 }, { 0, 0 }, "isPartOf", sp_ispartof, t_schema, sch_creativework },
    { { 6, 0 }, { 0, 0 }, "isPartOf", sp_ispartof, t_schema, sch_url },
    { { 6, 0 }, { 0, 0 }, "isPartOf", sp_ispartof, t_url },
    { { 6, 0 }, { 0, 0 }, "isPlanForApartment", sp_isplanforapartment, t_schema, sch_accommodation },
    { { 2, 0 }, { 0, 0 }, "isProprietary", sp_isproprietary, t_schema, sch_boolean },
    { { 2, 0 }, { 0, 0 }, "isProprietary", sp_isproprietary, t_bool },
    { { 2, 0 }, { 0, 0 }, "isRelatedTo", sp_isrelatedto, t_schema, sch_product },
    { { 3, 0 }, { 0, 0 }, "isRelatedTo", sp_isrelatedto, t_schema, sch_service },
    { { 6, 0 }, { 0, 0 }, "isResizable", sp_isresizable, t_schema, sch_boolean },
    { { 6, 0 }, { 0, 0 }, "isResizable", sp_isresizable, t_bool },
    { { 2, 0 }, { 0, 0 }, "isSimilarTo", sp_issimilarto, t_schema, sch_product },
    { { 3, 0 }, { 0, 0 }, "isSimilarTo", sp_issimilarto, t_schema, sch_service },
    { { 8, 0 }, { 0, 0 }, "isUnlabelledFallback", sp_isunlabelledfallback, t_bool },
    { { 9, 0 }, { 0, 0 }, "isVariantOf", sp_isvariantof, t_schema, sch_productgroup },
    { { 2, 0 }, { 0, 0 }, "isVariantOf", sp_isvariantof, t_schema, sch_productmodel },
    { { 2, 0 }, { 0, 0 }, "isbn", sp_isbn, t_isbn },
    { { 2, 0 }, { 0, 0 }, "isicV4", sp_isicv4, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "isicV4", sp_isicv4, t_text },
    { { 2, 0 }, { 0, 0 }, "isrcCode", sp_isrccode, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "isrcCode", sp_isrccode, t_text },
    { { 3, 5 }, { 0, 0 }, "issn", sp_issn, t_issn },
    { { 2, 0 }, { 0, 0 }, "issn", sp_issn, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "issn", sp_issn, t_text },
    { { 2, 0 }, { 0, 0 }, "issueNumber", sp_issuenumber, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "issueNumber", sp_issuenumber, t_integer },
    { { 2, 0 }, { 0, 0 }, "issueNumber", sp_issuenumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "issueNumber", sp_issuenumber, t_text },
    { { 2, 0 }, { 0, 0 }, "issuedBy", sp_issuedby, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "issuedThrough", sp_issuedthrough, t_schema, sch_service },
    { { 2, 0 }, { 0, 0 }, "iswcCode", sp_iswccode, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "iswcCode", sp_iswccode, t_text },
    { { 2, 0 }, { 0, 0 }, "item", sp_item, t_schema, sch_thing },
    { { 2, 0 }, { 0, 0 }, "itemCondition", sp_itemcondition, t_schema, sch_offeritemcondition },
    { { 2, 0 }, { 0, 0 }, "itemListElement", sp_itemlistelement, t_schema, sch_listitem },
    { { 2, 0 }, { 0, 0 }, "itemListElement", sp_itemlistelement, t_schema, sch_thing },
    { { 2, 0 }, { 0, 0 }, "itemListElement", sp_itemlistelement, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "itemListElement", sp_itemlistelement, t_text },
    { { 2, 0 }, { 0, 0 }, "itemListOrder", sp_itemlistorder, t_schema, sch_itemlistordertype },
    { { 2, 0 }, { 0, 0 }, "itemListOrder", sp_itemlistorder, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "itemListOrder", sp_itemlistorder, t_text },
    { { 3, 5 }, { 0, 0 }, "itemLocation", sp_itemlocation, t_schema, sch_place },
    { { 3, 5 }, { 0, 0 }, "itemLocation", sp_itemlocation, t_schema, sch_postaladdress },
    { { 3, 5 }, { 0, 0 }, "itemLocation", sp_itemlocation, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "itemLocation", sp_itemlocation, t_text },
    { { 2, 0 }, { 0, 0 }, "itemReviewed", sp_itemreviewed, t_schema, sch_thing },
    { { 2, 0 }, { 0, 0 }, "itemShipped", sp_itemshipped, t_schema, sch_product },
    { { 6, 0 }, { 0, 0 }, "itemoffered", sp_itemoffered, t_schema, sch_aggregateoffer },
    { { 6, 0 }, { 0, 0 }, "itemoffered", sp_itemoffered, t_schema, sch_creativework },
    { { 6, 0 }, { 0, 0 }, "itemoffered", sp_itemoffered, t_schema, sch_event },
    { { 6, 0 }, { 0, 0 }, "itemoffered", sp_itemoffered, t_schema, sch_menuitem },
    { { 2, 0 }, { 0, 0 }, "itemoffered", sp_itemoffered, t_schema, sch_product },
    { { 2, 2 }, { 0, 0 }, "itemoffered", sp_itemoffered, t_schema, sch_service },
    { { 6, 0 }, { 0, 0 }, "itemoffered", sp_itemoffered, t_schema, sch_trip },
    { { 3, 5 }, { 0, 0 }, "itinerary", sp_itinerary, t_schema, sch_itemlist },
    { { 3, 5 }, { 0, 0 }, "itinerary", sp_itinerary, t_schema, sch_place },
    { { 2, 0 }, { 0, 0 }, "jobBenefits", sp_jobbenefits, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "jobBenefits", sp_jobbenefits, t_text },
    { { 3, 8 }, { 0, 0 }, "jobImmediateStart", sp_jobimmediatestart, t_schema, sch_boolean },
    { { 3, 8 }, { 0, 0 }, "jobImmediateStart", sp_jobimmediatestart, t_bool },
    { { 2, 0 }, { 0, 0 }, "jobLocation", sp_joblocation, t_schema, sch_place },
    { { 3, 5 }, { 0, 0 }, "jobLocationType", sp_joblocationtype, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "jobLocationType", sp_joblocationtype, t_text },
    { { 3, 8 }, { 0, 0 }, "jobStartDate", sp_jobstartdate, t_schema, sch_date },
    { { 3, 8 }, { 0, 0 }, "jobStartDate", sp_jobstartdate, t_just_date },
    { { 3, 8 }, { 0, 0 }, "jobStartDate", sp_jobstartdate, t_schema, sch_text },
    { { 3, 8 }, { 0, 0 }, "jobStartDate", sp_jobstartdate, t_text },
    { { 3, 7 }, { 0, 0 }, "jobTitle", sp_jobtitle, t_schema, sch_definedterm },
    { { 2, 0 }, { 0, 0 }, "jobTitle", sp_jobtitle, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "jobTitle", sp_jobtitle, t_text },
    { { 7, 4 }, { 0, 0 }, "jurisdiction", sp_jurisdiction, t_schema, sch_administrativearea },
    { { 7, 4 }, { 0, 0 }, "jurisdiction", sp_jurisdiction, t_schema, sch_text },
    { { 7, 4 }, { 0, 0 }, "jurisdiction", sp_jurisdiction, t_text },
    { { 10, 0 }, { 0, 0 }, "keywords", sp_keywords, t_schema, sch_definedterm },
    { { 10, 0 }, { 0, 0 }, "keywords", sp_keywords, t_schema, sch_url },
    { { 10, 0 }, { 0, 0 }, "keywords", sp_keywords, t_url },
    { { 2, 0 }, { 0, 0 }, "keywords", sp_keywords, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "keywords", sp_keywords, t_text },
    { { 2, 0 }, { 0, 0 }, "knownVehicleDamages", sp_knownvehicledamages, t_text },
    { { 2, 0 }, { 0, 0 }, "knows", sp_knows, t_schema, sch_person },
    { { 3, 5 }, { 0, 0 }, "knowsAbout", sp_knowsabout, t_schema, sch_thing },
    { { 3, 5 }, { 0, 0 }, "knowsAbout", sp_knowsabout, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "knowsAbout", sp_knowsabout, t_text },
    { { 3, 5 }, { 0, 0 }, "knowsAbout", sp_knowsabout, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "knowsAbout", sp_knowsabout, t_url },
    { { 3, 5 }, { 0, 0 }, "knowsLanguage", sp_knowslanguage, t_schema, sch_language },
    { { 3, 5 }, { 0, 0 }, "knowsLanguage", sp_knowslanguage, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "knowsLanguage", sp_knowslanguage, t_url },
    { { 2, 0 }, { 0, 0 }, "labelDetails", sp_labeldetails, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "labelDetails", sp_labeldetails, t_url },
    { { 2, 0 }, { 0, 0 }, "landlord", sp_landlord, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "landlord", sp_landlord, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "lastReviewed", sp_lastreviewed, t_schema, sch_date },
    { { 2, 0 }, { 0, 0 }, "lastReviewed", sp_lastreviewed, t_just_date },
    { { 2, 0 }, { 0, 0 }, "latitude", sp_latitude, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "latitude", sp_latitude, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "latitude", sp_latitude, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "latitude", sp_latitude, t_text },
    { { 10, 0 }, { 0, 0 }, "layoutImage", sp_layoutimage, t_schema, sch_imageobject },
    { { 10, 0 }, { 0, 0 }, "layoutImage", sp_layoutimage, t_schema, sch_url },
    { { 10, 0 }, { 0, 0 }, "layoutImage", sp_layoutimage, t_url },
    { { 2, 0 }, { 0, 0 }, "learningResourceType", sp_learningresourcetype, t_text },
    { { 5, 0 }, { 0, 0 }, "leaseLength", sp_leaselength, t_schema, sch_duration },
    { { 5, 0 }, { 0, 0 }, "leaseLength", sp_leaselength, t_duration },
    { { 5, 0 }, { 0, 0 }, "leaseLength", sp_leaselength, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "legalName", sp_legalname, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "legalName", sp_legalname, t_text },
    { { 3, 5 }, { 0, 0 }, "legalStatus", sp_legalstatus, t_schema, sch_druglegalstatus },
    { { 3, 5 }, { 0, 0 }, "legalStatus", sp_legalstatus, t_schema, sch_medicalenumeration },
    { { 2, 0 }, { 0, 0 }, "legalStatus", sp_legalstatus, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "legalStatus", sp_legalstatus, t_text },
    { { 3, 5 }, { 0, 0 }, "legislationApplies", sp_legislationapplies, t_schema, sch_legislation },
    { { 3, 5 }, { 0, 0 }, "legislationChanges", sp_legislationchanges, t_schema, sch_legislation },
    { { 3, 5 }, { 0, 0 }, "legislationConsolidates", sp_legislationconsolidates, t_schema, sch_legislation },
    { { 3, 5 }, { 0, 0 }, "legislationDate", sp_legislationdate, t_schema, sch_date },
    { { 3, 5 }, { 0, 0 }, "legislationDate", sp_legislationdate, t_just_date },
    { { 3, 5 }, { 0, 0 }, "legislationDateVersion", sp_legislationdateversion, t_schema, sch_date },
    { { 3, 5 }, { 0, 0 }, "legislationDateVersion", sp_legislationdateversion, t_just_date },
    { { 3, 5 }, { 0, 0 }, "legislationIdentifier", sp_legislationidentifier, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "legislationIdentifier", sp_legislationidentifier, t_text },
    { { 3, 5 }, { 0, 0 }, "legislationIdentifier", sp_legislationidentifier, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "legislationIdentifier", sp_legislationidentifier, t_url },
    { { 3, 5 }, { 0, 0 }, "legislationJurisdiction", sp_legislationjurisdiction, t_schema, sch_administrativearea },
    { { 3, 5 }, { 0, 0 }, "legislationJurisdiction", sp_legislationjurisdiction, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "legislationJurisdiction", sp_legislationjurisdiction, t_text },
    { { 3, 5 }, { 0, 0 }, "legislationLegalForce", sp_legislationlegalforce, t_schema, sch_legalforcestatus },
    { { 3, 5 }, { 0, 0 }, "legislationLegalValue", sp_legislationlegalvalue, t_schema, sch_legalvaluelevel },
    { { 3, 5 }, { 0, 0 }, "legislationPassedBy", sp_legislationpassedby, t_schema, sch_organisation },
    { { 3, 5 }, { 0, 0 }, "legislationPassedBy", sp_legislationpassedby, t_schema, sch_person },
    { { 3, 5 }, { 0, 0 }, "legislationResponsible", sp_legislationresponsible, t_schema, sch_organisation },
    { { 3, 5 }, { 0, 0 }, "legislationResponsible", sp_legislationresponsible, t_schema, sch_person },
    { { 3, 5 }, { 0, 0 }, "legislationTransposes", sp_legislationtransposes, t_schema, sch_legislation },
    { { 3, 5 }, { 0, 0 }, "legislationType", sp_legislationtype, t_schema, sch_categorycode },
    { { 3, 5 }, { 0, 0 }, "legislationType", sp_legislationtype, t_text },
    { { 3, 5 }, { 0, 0 }, "legislationType", sp_legislationtype, t_text },
    { { 3, 0 }, { 0, 0 }, "leiCode", sp_leicode, t_text },
    { { 3, 0 }, { 0, 0 }, "leiCode", sp_leicode, t_text },
    { { 3, 5 }, { 0, 0 }, "lender", sp_lender, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "lender", sp_lender, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "lesser", sp_lesser, t_schema, sch_qualitativevalue },
    { { 2, 0 }, { 0, 0 }, "lesserOrEqual", sp_lesserorequal, t_schema, sch_qualitativevalue },
    { { 3, 5 }, { 0, 0 }, "letterer", sp_letterer, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "license", sp_license, t_schema, sch_creativework },
    { { 2, 0 }, { 0, 0 }, "license", sp_license, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "license", sp_license, t_url },
    { { 2, 0 }, { 0, 0 }, "line", sp_line, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "line", sp_line, t_text },
    { { 3, 5 }, { 0, 0 }, "linkRelationship", sp_linkrelationship, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "linkRelationship", sp_linkrelationship, t_text },
    { { 2, 1 }, { 0, 0 }, "liveBlogUpdate", sp_liveblogupdate, t_schema, sch_blogposting },
    { { 3, 5 }, { 0, 0 }, "loanMortgagaMandateAmount", sp_loanmortgagamandateamount, t_schema, sch_monetaryamount },
    { { 3, 5 }, { 0, 0 }, "loanPaymentAmount", sp_loanpaymentamount, t_schema, sch_monetaryamount },
    { { 3, 5 }, { 0, 0 }, "loanPaymentFrequency", sp_loanpaymentfrequency, t_schema, sch_number },
    { { 3, 5 }, { 0, 0 }, "loanPaymentFrequency", sp_loanpaymentfrequency, t_fixedpoint },
    { { 3, 5 }, { 0, 0 }, "loanRepaymentForm", sp_loanrepaymentform, t_schema, sch_repaymentspecification },
    { { 3, 0 }, { 0, 0 }, "loanTerm", sp_loanterm, t_schema, sch_quantitativevalue },
    { { 3, 5 }, { 0, 0 }, "loanType", sp_loantype, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "loanType", sp_loantype, t_text },
    { { 3, 5 }, { 0, 0 }, "loanType", sp_loantype, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "loanType", sp_loantype, t_url },
    { { 2, 0 }, { 0, 0 }, "location", sp_location, t_schema, sch_place },
    { { 2, 0 }, { 0, 0 }, "location", sp_location, t_schema, sch_postaladdress },
    { { 7, 0 }, { 0, 0 }, "location", sp_location, t_schema, sch_virtuallocation },
    { { 2, 2 }, { 0, 0 }, "location", sp_location, t_schema, sch_text },
    { { 2, 2 }, { 0, 0 }, "location", sp_location, t_text },
    { { 2, 2 }, { 0, 0 }, "locationCreated", sp_locationcreated, t_schema, sch_place },
    { { 2, 0 }, { 0, 0 }, "lodgingUnitDescription", sp_lodgingunitdescription, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "lodgingUnitDescription", sp_lodgingunitdescription, t_text },
    { { 2, 0 }, { 0, 0 }, "lodgingUnitType", sp_lodgingunittype, t_schema, sch_qualitativevalue },
    { { 2, 0 }, { 0, 0 }, "lodgingUnitType", sp_lodgingunittype, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "lodgingUnitType", sp_lodgingunittype, t_text },
    { { 2, 0 }, { 0, 0 }, "logo", sp_logo, t_schema, sch_imageobject },
    { { 2, 0 }, { 0, 0 }, "logo", sp_logo, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "logo", sp_logo, t_url },
    { { 2, 0 }, { 0, 0 }, "longitude", sp_longitude, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "longitude", sp_longitude, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "longitude", sp_longitude, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "longitude", sp_longitude, t_text },
    { { 2, 0 }, { 0, 0 }, "loser", sp_loser, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "lowPrice", sp_lowprice, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "lowPrice", sp_lowprice, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "lowPrice", sp_lowprice, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "lowPrice", sp_lowprice, t_text },
    { { 2, 0 }, { 0, 0 }, "lyricist", sp_lyricist, t_schema, sch_person },
    { { 2, 1 }, { 0, 0 }, "lyrics", sp_lyrics, t_schema, sch_creativework },
    { { 2, 0 }, { 0, 0 }, "mainContentOfPage", sp_maincontentofpage, t_schema, sch_webpageelement },
    { { 2, 0 }, { 0, 0 }, "mainEntity", sp_mainentity, t_schema, sch_thing },
    { { 2, 0 }, { 0, 0 }, "mainEntityOfPage", sp_mainentityofpage, t_schema, sch_creativework },
    { { 2, 0 }, { 0, 0 }, "mainEntityOfPage", sp_mainentityofpage, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "mainEntityOfPage", sp_mainentityofpage, t_url },
    { { 6, 0 }, { 0, 0 }, "maintainer", sp_maintainer, t_schema, sch_organisation },
    { { 6, 0 }, { 0, 0 }, "maintainer", sp_maintainer, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "makesOffer", sp_makesoffer, t_schema, sch_offer },
    { { 2, 0 }, { 0, 0 }, "manufacturer", sp_manufacturer, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "maptype", sp_maptype, t_schema, sch_mapcategorytype },
    { { 3, 9 }, { 0, 0 }, "marginOfError", sp_marginoferror, t_schema, sch_datetime },
    { { 3, 9 }, { 0, 0 }, "marginOfError", sp_marginoferror, t_datetime },
    { { 3, 5 }, { 0, 0 }, "masthead", sp_masthead, t_schema, sch_creativework },
    { { 3, 5 }, { 0, 0 }, "masthead", sp_masthead, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "masthead", sp_masthead, t_url },
    { { 3, 2 }, { 0, 0 }, "material", sp_material, t_schema, sch_product },
    { { 3, 2 }, { 0, 0 }, "material", sp_material, t_schema, sch_text },
    { { 3, 2 }, { 0, 0 }, "material", sp_material, t_text },
    { { 3, 2 }, { 0, 0 }, "material", sp_material, t_schema, sch_url },
    { { 3, 2 }, { 0, 0 }, "material", sp_material, t_url },
    { { 3, 5 }, { 0, 0 }, "materialExtent", sp_materialextent, t_schema, sch_quantitativevalue },
    { { 3, 5 }, { 0, 0 }, "materialExtent", sp_materialextent, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "materialExtent", sp_materialextent, t_text },
    { { 2, 0 }, { 0, 0 }, "maxPrice", sp_maxprice, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "maxPrice", sp_maxprice, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "maxValue", sp_maxvalue, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "maxValue", sp_maxvalue, t_fixedpoint },
    { { 3, 1 }, { 0, 0 }, "maximumAttendeeCapacity", sp_maximumattendeecapacity, t_schema, sch_integer },
    { { 3, 1 }, { 0, 0 }, "maximumAttendeeCapacity", sp_maximumattendeecapacity, t_integer },
    { { 6, 0 }, { 0, 0 }, "maximumEnrollment", sp_maximumenrollment, t_schema, sch_integer },
    { { 6, 0 }, { 0, 0 }, "maximumEnrollment", sp_maximumenrollment, t_integer },
    { { 2, 0 }, { 0, 0 }, "maximumIntake", sp_maximumintake, t_schema, sch_maximumdoseschedule },
    { { 7, 0 }, { 0, 0 }, "maximumPhysicalAttendeeCapacity", sp_maximumphysicalattendeecapacity, t_schema, sch_integer },
    { { 7, 0 }, { 0, 0 }, "maximumPhysicalAttendeeCapacity", sp_maximumphysicalattendeecapacity, t_integer },
    { { 7, 0 }, { 0, 0 }, "maximumVirtualAttendeeCapacity", sp_maximumvirtualattendeecapacity, t_schema, sch_integer },
    { { 7, 0 }, { 0, 0 }, "maximumVirtualAttendeeCapacity", sp_maximumvirtualattendeecapacity, t_integer },
    { { 2, 0 }, { 0, 0 }, "mealService", sp_mealservice, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "mealService", sp_mealservice, t_text },
    { { 3, 9 }, { 0, 0 }, "measuredProperty", sp_measuredproperty, t_schema, sch_property },
    { { 3, 9 }, { 0, 0 }, "measuredValue", sp_measuredvalue, t_generic },
    { { 3, 5 }, { 0, 0 }, "measurementTechnique", sp_measurementtechnique, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "measurementTechnique", sp_measurementtechnique, t_text },
    { { 3, 5 }, { 0, 0 }, "measurementTechnique", sp_measurementtechnique, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "measurementTechnique", sp_measurementtechnique, t_url },
    { { 2, 0 }, { 0, 0 }, "mechanismOfAction", sp_mechanismofaction, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "mechanismOfAction", sp_mechanismofaction, t_text },
    { { 7, 0 }, { 0, 0 }, "mediaAuthenticityCategory", sp_mediaauthenticitycategory, t_schema, sch_mediamanipulationratingenumeration },
    { { 3, 5 }, { 0, 0 }, "median", sp_median, t_schema, sch_number },
    { { 3, 5 }, { 0, 0 }, "median", sp_median, t_fixedpoint },
    { { 9, 0 }, { 0, 0 }, "medicalAudience", sp_medicalaudience, t_schema, sch_medicalaudience },
    { { 9, 0 }, { 0, 0 }, "medicalAudience", sp_medicalaudience, t_schema, sch_medicalaudiencetype },
    { { 2, 0 }, { 0, 0 }, "medicalSpeciality", sp_medicalspeciality, t_schema, sch_medicalspeciality },
    { { 9, 0 }, { 0, 0 }, "medicalaudience", sp_aspect, t_schema, sch_medicalaudience },
    { { 9, 0 }, { 0, 0 }, "medicalaudience", sp_aspect, t_schema, sch_medicalaudiencetype },
    { { 2, 0 }, { 0, 0 }, "medicineSystem", sp_medicinesystem, t_schema, sch_medicinesystem },
    { { 3, 5 }, { 0, 0 }, "meetsEmissionStandard", sp_meetsemissionstandard, t_schema, sch_qualitativevalue },
    { { 3, 5 }, { 0, 0 }, "meetsEmissionStandard", sp_meetsemissionstandard, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "meetsEmissionStandard", sp_meetsemissionstandard, t_text },
    { { 3, 5 }, { 0, 0 }, "meetsEmissionStandard", sp_meetsemissionstandard, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "meetsEmissionStandard", sp_meetsemissionstandard, t_url },
    { { 2, 0 }, { 0, 0 }, "member", sp_member, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "member", sp_member, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "memberOf", sp_memberof, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "memberOf", sp_memberof, t_schema, sch_programmemembership },
    { { 2, 0 }, { 0, 0 }, "membershipNumber", sp_membershipnumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "membershipNumber", sp_membershipnumber, t_text },
    { { 3, 5 }, { 0, 0 }, "membershipPointsEarned", sp_membershippointsearned, t_fixedpoint },
    { { 3, 5 }, { 0, 0 }, "membershipPointsEarned", sp_membershippointsearned, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "memoryRequirements", sp_memoryrequirements, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "memoryRequirements", sp_memoryrequirements, t_text },
    { { 2, 0 }, { 0, 0 }, "memoryRequirements", sp_memoryrequirements, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "memoryRequirements", sp_memoryrequirements, t_url },
    { { 2, 0 }, { 0, 0 }, "mentions", sp_mentions, t_schema, sch_thing },
    { { 3, 2 }, { 0, 0 }, "menu", sp_menu, t_schema, sch_menu },
    { { 2, 0 }, { 0, 0 }, "menu", sp_menu, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "menu", sp_menu, t_text },
    { { 2, 0 }, { 0, 0 }, "menu", sp_menu, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "menu", sp_menu, t_url },
    { { 3, 5 }, { 0, 0 }, "menuAddOn", sp_menuaddon, t_schema, sch_menuitem },
    { { 3, 5 }, { 0, 0 }, "menuAddOn", sp_menuaddon, t_schema, sch_menusection },
    { { 6, 0 }, { 0, 0 }, "merchantReturnDays", sp_merchantreturndays, t_schema, sch_integer },
    { { 6, 0 }, { 0, 0 }, "merchantReturnDays", sp_merchantreturndays, t_integer },
    { { 6, 0 }, { 0, 0 }, "merchantReturnLink", sp_merchantreturnlink, t_schema, sch_url },
    { { 6, 0 }, { 0, 0 }, "merchantReturnLink", sp_merchantreturnlink, t_url },
    { { 3, 0 }, { 0, 0 }, "messageAttachment", sp_messageattachment, t_schema, sch_creativework },
    { { 2, 0 }, { 0, 0 }, "mileageFromOdometer", sp_mileagefromodometer, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "minPrice", sp_minprice, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "minPrice", sp_minprice, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "minValue", sp_minvalue, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "minValue", sp_minvalue, t_fixedpoint },
    { { 9, 0 }, { 0, 0 }, "minimumMonthlyRepaymentAmount", sp_minimummonthlyrepaymentamount, t_schema, sch_number },
    { { 9, 0 }, { 0, 0 }, "minimumMonthlyRepaymentAmount", sp_minimummonthlyrepaymentamount, t_fixedpoint },
    { { 9, 0 }, { 0, 0 }, "minimumMonthlyRepaymentAmount", sp_minimummonthlyrepaymentamount, t_schema, sch_monetaryamount },
    { { 3, 0 }, { 0, 0 }, "minimumPaymentDue", sp_minimumpaymentdue, t_schema, sch_monetaryamount },
    { { 2, 0 }, { 0, 0 }, "minimumPaymentDue", sp_minimumpaymentdue, t_schema, sch_pricespecification },
    { { 3, 5 }, { 0, 0 }, "missionCoveragePrioritiesPolicy", sp_missioncoverageprioritiespolicy, t_schema, sch_creativework },
    { { 3, 5 }, { 0, 0 }, "missionCoveragePrioritiesPolicy", sp_missioncoverageprioritiespolicy, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "missionCoveragePrioritiesPolicy", sp_missioncoverageprioritiespolicy, t_url },
    { { 2, 0 }, { 0, 0 }, "model", sp_model, t_schema, sch_productmodel },
    { { 2, 0 }, { 0, 0 }, "model", sp_model, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "model", sp_model, t_text },
    { { 3, 5 }, { 0, 0 }, "modelDate", sp_modeldate, t_schema, sch_date },
    { { 3, 5 }, { 0, 0 }, "modelDate", sp_modeldate, t_just_date },
    { { 2, 0 }, { 0, 0 }, "modifiedTime", sp_modifiedtime, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "modifiedTime", sp_modifiedtime, t_datetime },
    { { 2, 0 }, { 0, 0 }, "mpn", sp_mpn, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "mpn", sp_mpn, t_text },
    { { 2, 0 }, { 0, 0 }, "multipleValues", sp_multiplevalues, t_schema, sch_boolean },
    { { 2, 0 }, { 0, 0 }, "multipleValues", sp_multiplevalues, t_bool },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "muscleAction", sp_muscleaction, t_schema, sch_text },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "muscleAction", sp_muscleaction, t_text },
    { { 2, 0 }, { 0, 0 }, "musicArrangement", sp_musicarrangement, t_schema, sch_musiccomposition },
    { { 2, 0 }, { 0, 0 }, "musicBy", sp_musicby, t_schema, sch_musicgroup },
    { { 2, 0 }, { 0, 0 }, "musicBy", sp_musicby, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "musicCompositionForm", sp_musiccompositionform, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "musicCompositionForm", sp_musiccompositionform, t_text },
    { { 2, 0 }, { 0, 0 }, "musicalKey", sp_musicalkey, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "musicalKey", sp_musicalkey, t_text },
    { { 2, 0 }, { 0, 0 }, "musicreleaseformat", sp_musicreleaseformat, t_schema, sch_musicreleaseformattype },
    { { 2, 0 }, { 0, 0 }, "naics", sp_naics, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "naics", sp_naics, t_text },
    { { 2, 0 }, { 0, 0 }, "name", sp_name, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "name", sp_name, t_text },
    { { 2, 0 }, { 0, 0 }, "nationality", sp_nationality, t_schema, sch_country },
    { { 2, 0 }, { 0, 0 }, "naturalProgression", sp_naturalprogression, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "naturalProgression", sp_naturalprogression, t_text },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "nerve", sp_nerve, t_schema, sch_nerve },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "nerveMotor", sp_nervemotor, t_schema, sch_muscle },
    { { 3, 0 }, { 0, 0 }, "netWorth", sp_networth, t_schema, sch_monetaryamount },
    { { 2, 0 }, { 0, 0 }, "netWorth", sp_networth, t_schema, sch_pricespecification },
    { { 7, 0 }, { 0, 0 }, "newUpdatesAndGuideLines", sp_newupdatesandguidelines, t_schema, sch_webcontent },
    { { 7, 0 }, { 0, 0 }, "newUpdatesAndGuideLines", sp_newupdatesandguidelines, t_schema, sch_url },
    { { 7, 0 }, { 0, 0 }, "newUpdatesAndGuideLines", sp_newupdatesandguidelines, t_url },
    { { 2, 0 }, { 0, 0 }, "nextItem", sp_nextitem, t_schema, sch_listitem },
    { { 3, 5 }, { 0, 0 }, "noBylinesPolicy", sp_nobylinespolicy, t_schema, sch_creativework },
    { { 3, 5 }, { 0, 0 }, "noBylinesPolicy", sp_nobylinespolicy, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "noBylinesPolicy", sp_nobylinespolicy, t_url },
    { { 2, 0 }, { 0, 0 }, "nonEqual", sp_nonequal, t_schema, sch_qualitativevalue },
    { { 2, 0 }, { 0, 0 }, "nonPropriatryName", sp_nonpropriatryname, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "nonPropriatryName", sp_nonpropriatryname, t_text },
    { { 2, 0 }, { 0, 0 }, "nonProprietaryName", sp_nonproprietaryname, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "nonProprietaryName", sp_nonproprietaryname, t_text },
    { { 8, 0 }, { 0, 0 }, "nonprofitStatus", sp_nonprofitstatus, t_schema, sch_nonprofittype },
    { { 3, 5 }, { 0, 0 }, "normalRange", sp_normalrange, t_schema, sch_medicalenumeration },
    { { 2, 0 }, { 0, 0 }, "normalRange", sp_normalrange, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "normalRange", sp_normalrange, t_text },
    { { 3, 5 }, { 0, 0 }, "nsn", sp_nsn, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "nsn", sp_nsn, t_text },
    { { 2, 0 }, { 0, 0 }, "numAdults", sp_numadults, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "numAdults", sp_numadults, t_integer },
    { { 2, 0 }, { 0, 0 }, "numAdults", sp_numadults, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "numChildren", sp_numchildren, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "numChildren", sp_numchildren, t_integer },
    { { 2, 0 }, { 0, 0 }, "numChildren", sp_numchildren, t_schema, sch_quantitativevalue },
    { { 3, 9 }, { 0, 0 }, "numConstraints", sp_numconstraints, t_schema, sch_integer },
    { { 3, 9 }, { 0, 0 }, "numConstraints", sp_numconstraints, t_integer },
    { { 2, 0 }, { 0, 0 }, "numTracks", sp_numtracks, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "numTracks", sp_numtracks, t_integer },
    { { 6, 0 }, { 0, 0 }, "numberOfAccommodationUnits", sp_numberofaccommodationunits, t_schema, sch_qualitativevalue },
    { { 6, 0 }, { 0, 0 }, "numberOfAccommodationUnits", sp_numberofaccommodationunits, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "numberOfAirbags", sp_numberofairbags, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "numberOfAirbags", sp_numberofairbags, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "numberOfAirbags", sp_numberofairbags, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "numberOfAirbags", sp_numberofairbags, t_text },
    { { 6, 0 }, { 0, 0 }, "numberOfAvailableAccommodationUnits", sp_numberofavailableaccommodationunits, t_schema, sch_qualitativevalue },
    { { 6, 0 }, { 0, 0 }, "numberOfAvailableAccommodationUnits", sp_numberofavailableaccommodationunits, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "numberOfAxles", sp_numberofaxles, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "numberOfAxles", sp_numberofaxles, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "numberOfAxles", sp_numberofaxles, t_fixedpoint },
    { { 5, 0 }, { 0, 0 }, "numberOfBathroomsTotal", sp_numberofbathroomstotal, t_schema, sch_integer },
    { { 5, 0 }, { 0, 0 }, "numberOfBathroomsTotal", sp_numberofbathroomstotal, t_integer },
    { { 7, 0 }, { 0, 0 }, "numberOfBedrooms", sp_numberofbedrooms, t_schema, sch_number },
    { { 7, 0 }, { 0, 0 }, "numberOfBedrooms", sp_numberofbedrooms, t_fixedpoint },
    { { 7, 0 }, { 0, 0 }, "numberOfBedrooms", sp_numberofbedrooms, t_schema, sch_qualitativevalue },
    { { 7, 0 }, { 0, 0 }, "numberOfBedrooms", sp_numberofbedrooms, t_schema, sch_quantitativevalue },
    { { 3, 1 }, { 0, 0 }, "numberOfBeds", sp_numberofbeds, t_schema, sch_number },
    { { 3, 1 }, { 0, 0 }, "numberOfBeds", sp_numberofbeds, t_fixedpoint },
    { { 6, 0 }, { 0, 0 }, "numberOfCredits", sp_numberofcredits, t_schema, sch_integer },
    { { 6, 0 }, { 0, 0 }, "numberOfCredits", sp_numberofcredits, t_integer },
    { { 6, 0 }, { 0, 0 }, "numberOfCredits", sp_numberofcredits, t_schema, sch_structuredvalue },
    { { 2, 1 }, { 0, 0 }, "numberOfDoors", sp_numberofdoors, t_schema, sch_number },
    { { 2, 1 }, { 0, 0 }, "numberOfDoors", sp_numberofdoors, t_fixedpoint },
    { { 2, 1 }, { 0, 0 }, "numberOfDoors", sp_numberofdoors, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "numberOfEmployees", sp_numberofemployees, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "numberOfEpisodes", sp_numberofepisodes, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "numberOfEpisodes", sp_numberofepisodes, t_integer },
    { { 2, 0 }, { 0, 0 }, "numberOfForwardgears", sp_numberofforwardgears, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "numberOfForwardgears", sp_numberofforwardgears, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "numberOfForwardgears", sp_numberofforwardgears, t_schema, sch_quantitativevalue },
    { { 5, 0 }, { 0, 0 }, "numberOfFullBathrooms", sp_numberoffullbathrooms, t_schema, sch_number },
    { { 5, 0 }, { 0, 0 }, "numberOfFullBathrooms", sp_numberoffullbathrooms, t_fixedpoint },
    { { 6, 0 }, { 0, 0 }, "numberOfFullBathrooms", sp_numberoffullbathrooms, t_schema, sch_integer },
    { { 6, 0 }, { 0, 0 }, "numberOfFullBathrooms", sp_numberoffullbathrooms, t_integer },
    { { 2, 0 }, { 0, 0 }, "numberOfItems", sp_numberofitems, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "numberOfItems", sp_numberofitems, t_integer },
    { { 3, 5 }, { 0, 0 }, "numberOfLoanPayments", sp_numberofloanpayments, t_schema, sch_number },
    { { 3, 5 }, { 0, 0 }, "numberOfLoanPayments", sp_numberofloanpayments, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "numberOfPages", sp_numberofpages, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "numberOfPages", sp_numberofpages, t_integer },
    { { 6, 0 }, { 0, 0 }, "numberOfPartialBathrooms", sp_numberofpartialbathrooms, t_schema, sch_number },
    { { 6, 0 }, { 0, 0 }, "numberOfPartialBathrooms", sp_numberofpartialbathrooms, t_fixedpoint },
    { { 6, 0 }, { 0, 0 }, "numberOfPartialBathrooms", sp_numberofpartialbathrooms, t_schema, sch_integer },
    { { 6, 0 }, { 0, 0 }, "numberOfPartialBathrooms", sp_numberofpartialbathrooms, t_integer },
    { { 2, 0 }, { 0, 0 }, "numberOfPlayers", sp_numberofplayers, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "numberOfPreviousowners", sp_numberofpreviousowners, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "numberOfPreviousowners", sp_numberofpreviousowners, t_schema, sch_quantitativevalue },
    { { 3, 1 }, { 0, 0 }, "numberOfRooms", sp_numberofrooms, t_schema, sch_number },
    { { 3, 1 }, { 0, 0 }, "numberOfRooms", sp_numberofrooms, t_fixedpoint },
    { { 3, 1 }, { 0, 0 }, "numberOfRooms", sp_numberofrooms, t_schema, sch_number },
    { { 3, 1 }, { 0, 0 }, "numberOfRooms", sp_numberofrooms, t_fixedpoint },
    { { 6, 0 }, { 0, 0 }, "numberOfRooms", sp_numberofrooms, t_schema, sch_integer },
    { { 6, 0 }, { 0, 0 }, "numberOfRooms", sp_numberofrooms, t_integer },
    { { 6, 0 }, { 0, 0 }, "numberOfRooms", sp_numberofrooms, t_schema, sch_qualitativevalue },
    { { 3, 1 }, { 0, 0 }, "numberOfRooms", sp_numberofrooms, t_schema, sch_quantitativevalue  },
    { { 3, 1 }, { 0, 0 }, "numberOfRooms", sp_numberofrooms, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "numberOfSeasons", sp_numberofseasons, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "numberOfSeasons", sp_numberofseasons, t_integer },
    { { 2, 0 }, { 0, 0 }, "numberedPosition", sp_numberedposition, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "numberedPosition", sp_numberedposition, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "nutrition", sp_nutrition, t_schema, sch_nutritioninformation },
    { { 2, 0 }, { 0, 0 }, "object", sp_object, t_schema, sch_thing },
    { { 3, 9 }, { 0, 0 }, "observationDate", sp_observationdate, t_schema, sch_datetime },
    { { 3, 9 }, { 0, 0 }, "observationDate", sp_observationdate, t_datetime },
    { { 3, 9 }, { 0, 0 }, "observedNode", sp_observednode, t_schema, sch_statisticalpopulation },
    { { 2, 0 }, { 0, 0 }, "ocaoCode", sp_ocaocode, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "ocaoCode", sp_ocaocode, t_text },
    { { 3, 1 }, { 0, 0 }, "occupancy", sp_occupancy, t_schema, sch_quantitativevalue },
    { { 3, 5 }, { 0, 0 }, "occupationLocation", sp_occupationlocation, t_schema, sch_administrativearea },
    { { 7, 0 }, { 0, 0 }, "occupationalCategory", sp_occupationalcategory, t_schema, sch_categorycode },
    { { 2, 0 }, { 0, 0 }, "occupationalCategory", sp_occupationalcategory, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "occupationalCategory", sp_occupationalcategory, t_text },
    { { 3, 9 }, { 0, 0 }, "occupationalCredentialAwarded", sp_occupationalcredentialawarded, t_schema, sch_educationaloccupationalcredential },
    { { 3, 9 }, { 0, 0 }, "occupationalCredentialAwarded", sp_occupationalcredentialawarded, t_schema, sch_text },
    { { 3, 9 }, { 0, 0 }, "occupationalCredentialAwarded", sp_occupationalcredentialawarded, t_text },
    { { 3, 9 }, { 0, 0 }, "occupationalCredentialAwarded", sp_occupationalcredentialawarded, t_schema, sch_url },
    { { 3, 9 }, { 0, 0 }, "occupationalCredentialAwarded", sp_occupationalcredentialawarded, t_url },
    { { 2, 0 }, { 0, 0 }, "offerCount", sp_offercount, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "offerCount", sp_offercount, t_integer },
    { { 2, 2 }, { 0, 0 }, "offeredBy", sp_offeredby, t_schema, sch_organisation },
    { { 2, 2 }, { 0, 0 }, "offeredBy", sp_offeredby, t_schema, sch_person },
    { { 6, 0 }, { 0, 0 }, "offers", sp_offers, t_schema, sch_demand },
    { { 2, 0 }, { 0, 0 }, "offers", sp_offers, t_schema, sch_offer },
    { { 3, 5 }, { 0, 0 }, "offersPrescriptionByMail", sp_offersprescriptionbymail, t_schema, sch_boolean },
    { { 3, 5 }, { 0, 0 }, "offersPrescriptionByMail", sp_offersprescriptionbymail, t_bool },
    { { 2, 0 }, { 0, 0 }, "openingHours", sp_openinghours, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "openingHours", sp_openinghours, t_text },
    { { 2, 0 }, { 0, 0 }, "openingHoursSpecification", sp_openinghoursspecification, t_schema, sch_openinghoursspecification },
    { { 2, 0 }, { 0, 0 }, "opens", sp_opens, t_schema, sch_time },
    { { 2, 0 }, { 0, 0 }, "opens", sp_opens, t_just_time },
    { { 2, 0 }, { 0, 0 }, "operatingSystem", sp_operatingsystem, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "operatingSystem", sp_operatingsystem, t_text },
    { { 2, 0 }, { 0, 0 }, "opponent", sp_opponent, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "orderDate", sp_orderdate, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "orderDate", sp_orderdate, t_datetime },
    { { 3, 8 }, { 0, 0 }, "orderDate", sp_orderdate, t_schema, sch_date },
    { { 3, 8 }, { 0, 0 }, "orderDate", sp_orderdate, t_just_date },
    { { 2, 0 }, { 0, 0 }, "orderDelivery", sp_orderdelivery, t_schema, sch_parceldelivery },
    { { 2, 0 }, { 0, 0 }, "orderItemNumber", sp_orderitemnumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "orderItemNumber", sp_orderitemnumber, t_text },
    { { 2, 0 }, { 0, 0 }, "orderItemStatus", sp_orderitemstatus, t_schema, sch_orderstatus },
    { { 2, 0 }, { 0, 0 }, "orderNumber", sp_ordernumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "orderNumber", sp_ordernumber, t_text },
    { { 2, 0 }, { 0, 0 }, "orderQuantity", sp_orderquantity, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "orderQuantity", sp_orderquantity, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "orderStatus", sp_orderstatus, t_schema, sch_orderstatus },
    { { 2, 0 }, { 0, 0 }, "orderedItem", sp_ordereditem, t_schema, sch_orderitem },
    { { 2, 0 }, { 0, 0 }, "orderedItem", sp_ordereditem, t_schema, sch_product },
    { { 3, 6 }, { 0, 0 }, "orderedItem", sp_ordereditem, t_schema, sch_service },
    { { 2, 0 }, { 0, 0 }, "organiser", sp_organiser, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "organiser", sp_organiser, t_schema, sch_person },
    { { 2, 0, SV_NOT_3034 }, { 6, 0 }, "origin", sp_origin, t_schema, sch_anatomicalstructure },
    { { 2, 0 }, { 0, 0 }, "originSddress", sp_originaddress, t_schema, sch_postaladdress },
    { { 2, 0 }, { 0, 0 }, "originatesFrom", sp_originatesfrom, t_schema, sch_vessel },
    { { 3, 5 }, { 0, 0 }, "outcome", sp_outcome, t_schema, sch_medicalentity },
    { { 2, 0 }, { 0, 0 }, "outcome", sp_outcome, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "outcome", sp_outcome, t_text },
    { { 2, 0 }, { 0, 0 }, "overdosage", sp_overdosage, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "overdosage", sp_overdosage, t_text },
    { { 2, 0 }, { 0, 0 }, "overview", sp_overview, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "overview", sp_overview, t_text },
    { { 2, 0 }, { 0, 0 }, "ownedFrom", sp_ownedfrom, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "ownedFrom", sp_ownedfrom, t_datetime },
    { { 2, 0 }, { 0, 0 }, "ownedThrough", sp_ownedthrough, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "ownedThrough", sp_ownedthrough, t_datetime },
    { { 3, 5 }, { 0, 0 }, "ownershipFundingInfo", sp_ownershipfundinginfo, t_schema, sch_aboutpage },
    { { 3, 5 }, { 0, 0 }, "ownershipFundingInfo", sp_ownershipfundinginfo, t_schema, sch_creativework },
    { { 3, 5 }, { 0, 0 }, "ownershipFundingInfo", sp_ownershipfundinginfo, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "ownershipFundingInfo", sp_ownershipfundinginfo, t_text },
    { { 3, 5 }, { 0, 0 }, "ownershipFundingInfo", sp_ownershipfundinginfo, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "ownershipFundingInfo", sp_ownershipfundinginfo, t_url },
    { { 2, 0 }, { 0, 0 }, "owns", sp_owns, t_schema, sch_ownershipinfo },
    { { 2, 0 }, { 0, 0 }, "owns", sp_owns, t_schema, sch_product },
    { { 2, 0 }, { 0, 0 }, "pageEnd", sp_pageend, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "pageEnd", sp_pageend, t_integer },
    { { 2, 0 }, { 0, 0 }, "pageEnd", sp_pageend, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "pageEnd", sp_pageend, t_text },
    { { 2, 0 }, { 0, 0 }, "pageStart", sp_pagestart, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "pageStart", sp_pagestart, t_integer },
    { { 2, 0 }, { 0, 0 }, "pageStart", sp_pagestart, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "pageStart", sp_pagestart, t_text },
    { { 2, 0 }, { 0, 0 }, "pagination", sp_pagination, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "pagination", sp_pagination, t_text },
    { { 2, 0 }, { 0, 0 }, "parent", sp_parent, t_schema, sch_person },
    { { 2, 0 }, { 9, 0 }, "parentItem", sp_parentitem, t_schema, sch_question },
    { { 10, 0 }, { 0, 0 }, "parentItem", sp_parentitem, t_schema, sch_comment },
    { { 2, 0 }, { 0, 0 }, "parentOrganization", sp_parentorganisation, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "parentService", sp_parentservice,  t_schema, sch_broadcastservice },
    { { 2, 0 }, { 0, 0 }, "partOfEpisode", sp_partofepisode, t_schema, sch_episode },
    { { 2, 0 }, { 0, 0 }, "partOfInvoice", sp_partofinvoice, t_schema, sch_invoice },
    { { 2, 0 }, { 0, 0 }, "partOfSeason", sp_partofseason, t_schema, sch_creativeworkseason },
    { { 2, 0 }, { 0, 0 }, "partOfSeries", sp_partofseries, t_schema, sch_creativeworkseries },
    { { 2, 0 }, { 0, 0 }, "partOfSystem", sp_partofsystem, t_schema, sch_anatomicalsystem },
    { { 3, 5 }, { 0, 0 }, "partOfTrip", sp_partoftrip, t_schema, sch_trip },
    { { 2, 0 }, { 0, 0 }, "participant", sp_participant, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "participant", sp_participant, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "partofOrder", sp_partoforder, t_schema, sch_order },
    { { 2, 0 }, { 0, 0 }, "partySize", sp_partysize, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "partySize", sp_partysize, t_integer },
    { { 2, 0 }, { 0, 0 }, "partySize", sp_partysize, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "passengerPriorityStatus", sp_passengerprioritystatus, t_schema, sch_qualitativevalue },
    { { 2, 0 }, { 0, 0 }, "passengerPriorityStatus", sp_passengerprioritystatus, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "passengerPriorityStatus", sp_passengerprioritystatus, t_text },
    { { 2, 0 }, { 0, 0 }, "passengerSequenceNumber", sp_passengersequencenumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "passengerSequenceNumber", sp_passengersequencenumber, t_text },
    { { 2, 0 }, { 0, 0 }, "pathophysiology", sp_pathophysiology, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "pathophysiology", sp_pathophysiology, t_text },
    { { 9, 0 }, { 0, 0 }, "pattern", sp_pattern, t_schema, sch_definedterm },
    { { 9, 0 }, { 0, 0 }, "pattern", sp_pattern, t_schema, sch_text },
    { { 9, 0 }, { 0, 0 }, "pattern", sp_pattern, t_text },
    { { 3, 5 }, { 0, 0 }, "payload", sp_payload, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "paymentAccepted", sp_paymentaccepted, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "paymentAccepted", sp_paymentaccepted, t_text },
    { { 2, 0 }, { 2, 0 }, "paymentDue", sp_paymentdue, t_schema, sch_datetime },
    { { 2, 0 }, { 2, 0 }, "paymentDue", sp_paymentdue, t_datetime },
    { { 2, 1 }, { 0, 0 }, "paymentDueDate", sp_paymentduedate, t_schema, sch_datetime },
    { { 2, 1 }, { 0, 0 }, "paymentDueDate", sp_paymentduedate, t_datetime },
    { { 3, 8 }, { 0, 0 }, "paymentDueDate", sp_paymentduedate, t_schema, sch_date },
    { { 3, 8 }, { 0, 0 }, "paymentDueDate", sp_paymentduedate, t_just_date },
    { { 2, 0 }, { 0, 0 }, "paymentMethod", sp_paymentmethod, t_schema, sch_paymentmethod },
    { { 2, 0 }, { 0, 0 }, "paymentMethodId", sp_paymentmethodid, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "paymentMethodId", sp_paymentmethodid, t_text },
    { { 2, 0 }, { 0, 0 }, "paymentStatus", sp_paymentstatus, t_schema, sch_paymentstatustype },
    { { 2, 0 }, { 0, 0 }, "paymentStatus", sp_paymentstatus, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "paymentStatus", sp_paymentstatus, t_text },
    { { 2, 0 }, { 0, 0 }, "paymentUrl", sp_paymenturl, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "paymentUrl", sp_paymenturl, t_url },
    { { 3, 5 }, { 0, 0 }, "penciler", sp_penciler, t_schema, sch_person },
    { { 3, 5 }, { 0, 0 }, "percentile10", sp_percentile10, t_schema, sch_number },
    { { 3, 5 }, { 0, 0 }, "percentile10", sp_percentile10, t_fixedpoint },
    { { 3, 5 }, { 0, 0 }, "percentile25", sp_percentile25, t_schema, sch_number },
    { { 3, 5 }, { 0, 0 }, "percentile25", sp_percentile25, t_fixedpoint },
    { { 3, 5 }, { 0, 0 }, "percentile75", sp_percentile75, t_schema, sch_number },
    { { 3, 5 }, { 0, 0 }, "percentile75", sp_percentile75, t_fixedpoint },
    { { 3, 5 }, { 0, 0 }, "percentile90", sp_percentile90, t_schema, sch_number },
    { { 3, 5 }, { 0, 0 }, "percentile90", sp_percentile90, t_fixedpoint },
    { { 3, 3 }, { 0, 0 }, "performTime", sp_performtime, t_schema, sch_duration },
    { { 3, 3 }, { 0, 0 }, "performTime", sp_performtime, t_duration },
    { { 2, 0 }, { 0, 0 }, "performer", sp_performer, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "performer", sp_performer, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "performerIn", sp_performerin, t_schema, sch_event },
    { { 3, 0 }, { 0, 0 }, "permissionType", sp_permissiontype, t_schema, sch_digitaldocumentpermissiontype },
    { { 2, 0 }, { 0, 0 }, "permissions", sp_permissions, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "permissions", sp_permissions, t_text },
    { { 2, 0 }, { 0, 0 }, "permitAudience", sp_permitaudience, t_schema, sch_audience },
    { { 3, 1 }, { 0, 0 }, "permittedUsage", sp_permittedusage, t_schema, sch_text },
    { { 3, 1 }, { 0, 0 }, "permittedUsage", sp_permittedusage, t_text },
    { { 3, 1 }, { 0, 0 }, "petsAllowed", sp_petsallowed, t_schema, sch_text },
    { { 3, 1 }, { 0, 0 }, "petsAllowed", sp_petsallowed, t_text },
    { { 3, 1 }, { 0, 0 }, "petsAllowed", sp_petsallowed, t_schema, sch_boolean },
    { { 3, 1 }, { 0, 0 }, "petsAllowed", sp_petsallowed, t_bool },
    { { 2, 0 }, { 0, 0 }, "phase", sp_phase, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "phase", sp_phase, t_text },
    { { 6, 0 }, { 0, 0 }, "phoneticText", sp_phonetictext, t_schema, sch_text },
    { { 6, 0 }, { 0, 0 }, "phoneticText", sp_phonetictext, t_text },
    { { 2, 0 }, { 0, 0 }, "photo", sp_photo, t_schema, sch_imageobject },
    { { 2, 0 }, { 0, 0 }, "photo", sp_photo, t_schema, sch_photograph },
    { { 6, 0 }, { 0, 0 }, "physicalRequirement", sp_physicalrequirement, t_schema, sch_definedterm },
    { { 6, 0 }, { 0, 0 }, "physicalRequirement", sp_physicalrequirement, t_schema, sch_text },
    { { 6, 0 }, { 0, 0 }, "physicalRequirement", sp_physicalrequirement, t_text },
    { { 6, 0 }, { 0, 0 }, "physicalRequirement", sp_physicalrequirement, t_schema, sch_url },
    { { 6, 0 }, { 0, 0 }, "physicalRequirement", sp_physicalrequirement, t_url },
    { { 2, 0 }, { 0, 0 }, "physiologicalBenefits", sp_physiologicalbenefits, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "physiologicalBenefits", sp_physiologicalbenefits, t_text },
    { { 2, 0 }, { 0, 0 }, "pickupLocation", sp_pickuplocation, t_schema, sch_place },
    { { 2, 0 }, { 0, 0 }, "pickupTime", sp_pickuptime, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "pickupTime", sp_pickuptime, t_datetime },
    { { 2, 0 }, { 0, 0 }, "playMode", sp_playmode, t_schema, sch_gameplaymode },
    { { 2, 0 }, { 0, 0 }, "playerType", sp_playertype, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "playerType", sp_playertype, t_text },
    { { 2, 0 }, { 0, 0 }, "playersOnline", sp_playersonline, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "playersOnline", sp_playersonline, t_integer },
    { { 2, 0 }, { 0, 0 }, "polygon", sp_polygon, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "polygon", sp_polygon, t_text },
    { { 2, 0 }, { 0, 0 }, "population", sp_population, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "population", sp_population, t_text },
    { { 3, 9 }, { 0, 0 }, "populationType", sp_populationtype, t_schema, sch_class },
    { { 2, 0 }, { 0, 0 }, "position", sp_position, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "position", sp_position, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "position", sp_position, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "position", sp_position, t_integer },
    { { 2, 0 }, { 0, 0 }, "position", sp_position, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "position", sp_position, t_text },
    { { 2, 0 }, { 0, 0 }, "possibleComplication", sp_possiblecomplication, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "possibleComplication", sp_possiblecomplication, t_text },
    { { 2, 0 }, { 0, 0 }, "possibleTreatment", sp_possibletreatment, t_schema, sch_medicaltherapy },
    { { 2, 0 }, { 0, 0 }, "postOfficeBoxNumber", sp_postofficeboxnumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "postOfficeBoxNumber", sp_postofficeboxnumber, t_text },
    { { 2, 0 }, { 0, 0 }, "postOp", sp_postop, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "postOp", sp_postop, t_text },
    { { 2, 0 }, { 0, 0 }, "postalCode", sp_postalcode, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "postalCode", sp_postalcode, t_text },
    { { 8, 0 }, { 0, 0 }, "postalCodeBegin", sp_postalcodebegin, t_schema, sch_text },
    { { 8, 0 }, { 0, 0 }, "postalCodeBegin", sp_postalcodebegin, t_text },
    { { 8, 0 }, { 0, 0 }, "postalCodeEnd", sp_postalcodeend, t_schema, sch_text },
    { { 8, 0 }, { 0, 0 }, "postalCodeEnd", sp_postalcodeend, t_text },
    { { 8, 0 }, { 0, 0 }, "postalCodePrefix", sp_postalcodeprefix, t_schema, sch_text },
    { { 8, 0 }, { 0, 0 }, "postalCodePrefix", sp_postalcodeprefix, t_text },
    { { 8, 0 }, { 0, 0 }, "postalCodeRange", sp_postalcoderange, t_schema, sch_postalcoderangespecification },
    { { 2, 0 }, { 0, 0 }, "potentialAction", sp_potentialaction, t_schema, sch_action },
    { { 2, 0 }, { 0, 0 }, "preOp", sp_preop, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "preOp", sp_preop, t_text },
    { { 2, 0 }, { 0, 0 }, "predecessorOf", sp_predecessorof, t_schema, sch_productmodel },
    { { 2, 0 }, { 0, 0 }, "pregnancyCategory", sp_pregnancycategory, t_schema, sch_drugpregnancycategory },
    { { 2, 0 }, { 0, 0 }, "pregnancyWarning", sp_pregnancywarning, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "pregnancyWarning", sp_pregnancywarning, t_text },
    { { 2, 0 }, { 0, 0 }, "prepTime", sp_preptime, t_schema, sch_duration },
    { { 2, 0 }, { 0, 0 }, "prepTime", sp_preptime, t_duration },
    { { 3, 5 }, { 0, 0 }, "preparation", sp_preparation, t_schema, sch_medicalentity },
    { { 2, 0 }, { 0, 0 }, "preparation", sp_preparation, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "preparation", sp_preparation, t_text },
    { { 2, 0 }, { 0, 0 }, "prescribingInfo", sp_prescribinginfo, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "prescribingInfo", sp_prescribinginfo, t_url },
    { { 2, 0 }, { 0, 0 }, "prescriptionStatus", sp_prescriptionstatus, t_schema, sch_drugprescriptionstatus },
    { { 3, 5 }, { 0, 0 }, "prescriptionStatus", sp_prescriptionstatus, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "prescriptionStatus", sp_prescriptionstatus, t_text },
    { { 2, 0 }, { 0, 0 }, "previousItem", sp_previousitem, t_schema, sch_listitem },
    { { 2, 0 }, { 0, 0 }, "previousStartDate", sp_previousstartdate, t_schema, sch_date },
    { { 2, 0 }, { 0, 0 }, "previousStartDate", sp_previousstartdate, t_just_date },
    { { 2, 0 }, { 0, 0 }, "price", sp_price, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "price", sp_price, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "price", sp_price, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "price", sp_price, t_text },
    { { 3, 0 }, { 0, 0 }, "priceComponent", sp_pricecomponent, t_schema, sch_unitpricespecification },
    { { 2, 0 }, { 0, 0 }, "priceCurrency", sp_pricecurrency, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "priceCurrency", sp_pricecurrency, t_text },
    { { 2, 0 }, { 0, 0 }, "priceRange", sp_pricerange, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "priceRange", sp_pricerange, t_text },
    { { 2, 0 }, { 0, 0 }, "priceSpecification", sp_pricespecification, t_schema, sch_pricespecification },
    { { 2, 0 }, { 0, 0 }, "priceType", sp_pricetype, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "priceType", sp_pricetype, t_text },
    { { 2, 0 }, { 0, 0 }, "priceValidUntil", sp_pricevaliduntil, t_schema, sch_date },
    { { 2, 0 }, { 0, 0 }, "priceValidUntil", sp_pricevaliduntil, t_just_date },
    { { 2, 0 }, { 0, 0 }, "primaryImageOfPage", sp_primaryimageofpage, t_schema, sch_imageobject },
    { { 2, 0 }, { 0, 0 }, "primaryPrevention", sp_primaryprevention, t_schema, sch_medicaltherapy },
    { { 2, 0 }, { 0, 0 }, "printColumn", sp_printcolumn, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "printColumn", sp_printcolumn, t_text },
    { { 2, 0 }, { 0, 0 }, "printEdition", sp_printedition, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "printEdition", sp_printedition, t_text },
    { { 2, 0 }, { 0, 0 }, "printPage", sp_printpage, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "printPage", sp_printpage, t_text },
    { { 2, 0 }, { 0, 0 }, "printSection", sp_printsection, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "printSection", sp_printsection, t_text },
    { { 2, 0 }, { 0, 0 }, "procedure", sp_procedure, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "procedure", sp_procedure, t_text },
    { { 2, 0 }, { 0, 0 }, "procedureType", sp_proceduretype, t_schema, sch_medicalproceduretype },
    { { 2, 0 }, { 0, 0 }, "processingTime", sp_processingtime, t_schema, sch_duration },
    { { 2, 0 }, { 0, 0 }, "processingTime", sp_processingtime, t_duration },
    { { 2, 0 }, { 0, 0 }, "processorRequirements", sp_processorrequirements, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "processorRequirements", sp_processorrequirements, t_text },
    { { 2, 0 }, { 0, 0 }, "producer", sp_producer, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "producer", sp_producer, t_schema, sch_person },
    { { 9, 0 }, { 0, 0 }, "productGroupID", sp_productgroupid, t_schema, sch_text },
    { { 9, 0 }, { 0, 0 }, "productGroupID", sp_productgroupid, t_text },
    { { 2, 0 }, { 0, 0 }, "productID", sp_productid, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "productID", sp_productid, t_text },
    { { 2, 0 }, { 0, 0 }, "productSupported", sp_productsupported, t_schema, sch_product },
    { { 2, 0 }, { 0, 0 }, "productSupported", sp_productsupported, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "productSupported", sp_productsupported, t_text },
    { { 2, 0 }, { 0, 0 }, "productionCompany", sp_productioncompany, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "productionDate", sp_productiondate, t_schema, sch_date },
    { { 2, 0 }, { 0, 0 }, "productionDate", sp_productiondate, t_just_date },
    { { 2, 0 }, { 0, 0 }, "proficiencyLevel", sp_proficiencylevel, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "proficiencyLevel", sp_proficiencylevel, t_text },
    { { 2, 0 }, { 0, 0 }, "programMembershipUse", sp_programmemembershipused, t_schema, sch_programmemembership },
    { { 2, 0 }, { 0, 0 }, "programName", sp_programmename, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "programName", sp_programmename, t_text },
    { { 3, 9 }, { 0, 0 }, "programPrequisites", sp_programprequisites, t_schema, sch_alignmentobject },
    { { 3, 9 }, { 0, 0 }, "programPrequisites", sp_programprequisites, t_schema, sch_course },
    { { 3, 9 }, { 0, 0 }, "programPrequisites", sp_programprequisites, t_schema, sch_educationaloccupationalcredential },
    { { 3, 9 }, { 0, 0 }, "programPrequisites", sp_programprequisites, t_schema, sch_text },
    { { 3, 9 }, { 0, 0 }, "programPrequisites", sp_programprequisites, t_text },
    { { 7, 0 }, { 0, 0 }, "programType", sp_programtype, t_schema, sch_definedterm },
    { { 7, 0 }, { 0, 0 }, "programType", sp_programtype, t_schema, sch_text },
    { { 7, 0 }, { 0, 0 }, "programType", sp_programtype, t_text },
    { { 3, 0 }, { 0, 0 }, "programmingLanguage", sp_programminglanguage, t_schema, sch_computerlanguage },
    { { 2, 0 }, { 0, 0 }, "programmingLanguage", sp_programminglanguage, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "programmingLanguage", sp_programminglanguage, t_text },
    { { 2, 0 }, { 0, 0 }, "programmingModel", sp_programmingmodel, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "programmingModel", sp_programmingmodel, t_text },
    { { 2, 0 }, { 0, 0 }, "propertyID", sp_propertyid, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "propertyID", sp_propertyid, t_text },
    { { 2, 0 }, { 0, 0 }, "propertyID", sp_propertyid, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "propertyID", sp_propertyid, t_url },
    { { 3, 5 }, { 0, 0 }, "propriatryName", sp_propriatryname, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "propriatryName", sp_propriatryname, t_text },
    { { 2, 0 }, { 0, 0 }, "proprietaryName", sp_proprietaryname, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "proprietaryName", sp_proprietaryname, t_text },
    { { 2, 0 }, { 0, 0 }, "proteinContent", sp_proteincontent, t_schema, sch_mass },
    { { 2, 0 }, { 0, 0 }, "provider", sp_provider, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "provider", sp_provider, t_schema, sch_person },
    { { 2, 2 }, { 0, 0 }, "providerMobility", sp_providermobility, t_schema, sch_text },
    { { 2, 2 }, { 0, 0 }, "providerMobility", sp_providermobility, t_text },
    { { 2, 0 }, { 0, 0 }, "providesBroadcastService", sp_providesbroadcastservice, t_schema, sch_broadcastservice },
    { { 2, 0 }, { 0, 0 }, "providesService", sp_providesservice, t_schema, sch_service },
    { { 3, 3 }, { 0, 0 }, "publicAccess", sp_publicaccess, t_schema, sch_boolean },
    { { 3, 3 }, { 0, 0 }, "publicAccess", sp_publicaccess, t_bool },
    { { 7, 0 }, { 0, 0 }, "publicTransportClosuresInfo", sp_publictransportclosuresinfo, t_schema, sch_webcontent },
    { { 7, 0 }, { 0, 0 }, "publicTransportClosuresInfo", sp_publictransportclosuresinfo, t_schema, sch_url },
    { { 7, 0 }, { 0, 0 }, "publicTransportClosuresInfo", sp_publictransportclosuresinfo, t_url },
    { { 2, 0 }, { 0, 0 }, "publication", sp_publication, t_schema, sch_publicationevent },
    { { 2, 0 }, { 0, 0 }, "publicationType", sp_publicationtype, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "publicationType", sp_publicationtype, t_text },
    { { 3, 5 }, { 0, 0 }, "publishedBy", sp_publishedby, t_schema, sch_organisation },
    { { 3, 5 }, { 0, 0 }, "publishedBy", sp_publishedby, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "publishedOn", sp_publishedon, t_schema, sch_broadcastservice },
    { { 2, 0 }, { 0, 0 }, "publisher", sp_publisher, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "publisher", sp_publisher, t_schema, sch_person },
    { { 3, 5 }, { 0, 0 }, "publisherImprint", sp_publisherimprint, t_schema, sch_organisation },
    { { 3, 3 }, { 0, 0 }, "publishingPrinciples", sp_publishingprinciples, t_schema, sch_creativework },
    { { 2, 0 }, { 0, 0 }, "publishingPrinciples", sp_publishingprinciples, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "publishingPrinciples", sp_publishingprinciples, t_url },
    { { 2, 0 }, { 0, 0 }, "purchaseDate", sp_purchasedate, t_schema, sch_date },
    { { 2, 0 }, { 0, 0 }, "purchaseDate", sp_purchasedate, t_just_date },
    { { 2, 0 }, { 0, 0 }, "purpose", sp_purpose, t_schema, sch_medicaldevicepurpose },
    { { 2, 0 }, { 6, 0 }, "purpose", sp_purpose, t_schema, sch_medicaldevicepurpose },
    { { 2, 0 }, { 0, 0 }, "purpose", sp_purpose, t_schema, sch_thing },
    { { 2, 0 }, { 6, 0 }, "purpose", sp_purpose, t_schema, sch_thing },
    { { 3, 5 }, { 0, 0 }, "qualifications", sp_qualifications, t_schema, sch_educationaloccupationalcredential },
    { { 2, 0 }, { 0, 0 }, "qualifications", sp_qualifications, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "qualifications", sp_qualifications, t_text },
    { { 7, 0 }, { 0, 0 }, "quarantineGuidelines", sp_quarantineguidelines, t_schema, sch_webcontent },
    { { 7, 0 }, { 0, 0 }, "quarantineGuidelines", sp_quarantineguidelines, t_schema, sch_url },
    { { 7, 0 }, { 0, 0 }, "quarantineGuidelines", sp_quarantineguidelines, t_url },
    { { 2, 0 }, { 0, 0 }, "query", sp_query, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "query", sp_query, t_text },
    { { 2, 0 }, { 0, 0 }, "quest", sp_quest, t_schema, sch_thing },
    { { 2, 0 }, { 0, 0 }, "question", sp_question, t_schema, sch_question },
    { { 2, 0 }, { 0, 0 }, "rangeIncludes", sp_rangeincludes, t_schema, sch_class },
    { { 2, 0 }, { 0, 0 }, "ratingCount", sp_ratingcount, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "ratingCount", sp_ratingcount, t_integer },
    { { 3, 9 }, { 0, 0 }, "ratingExplanation", sp_ratingexplanation, t_schema, sch_text },
    { { 3, 9 }, { 0, 0 }, "ratingExplanation", sp_ratingexplanation, t_text },
    { { 3, 1 }, { 0, 0 }, "ratingValue", sp_ratingvalue, t_schema, sch_number },
    { { 3, 1 }, { 0, 0 }, "ratingValue", sp_ratingvalue, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "ratingValue", sp_ratingvalue, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "ratingValue", sp_ratingvalue, t_text },
    { { 3, 5 }, { 0, 0 }, "readBy", sp_readby, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "readonlyValue", sp_readonlyvalue, t_schema, sch_boolean },
    { { 2, 0 }, { 0, 0 }, "readonlyValue", sp_readonlyvalue, t_bool },
    { { 2, 0 }, { 0, 0 }, "realEstateAgent", sp_realestateagent, t_schema, sch_realestateagent },
    { { 2, 0 }, { 0, 0 }, "recipe", sp_recipe, t_schema, sch_recipe },
    { { 2, 0 }, { 0, 0 }, "recipeCategory", sp_recipecategory, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "recipeCategory", sp_recipecategory, t_text },
    { { 2, 0 }, { 0, 0 }, "recipeCuisine", sp_recipecuisine, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "recipeCuisine", sp_recipecuisine, t_text },
    { { 2, 0 }, { 0, 0 }, "recipeIngredient", sp_recipeingredient, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "recipeIngredient", sp_recipeingredient, t_text },
    { { 3, 3 }, { 0, 0 }, "recipeInstructions", sp_recipeinstructions, t_schema, sch_creativework },
    { { 2, 0 }, { 0, 0 }, "recipeInstructions", sp_recipeinstructions, t_schema, sch_itemlist },
    { { 2, 0 }, { 0, 0 }, "recipeInstructions", sp_recipeinstructions, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "recipeInstructions", sp_recipeinstructions, t_text },
    { { 3, 3 }, { 0, 0 }, "recipeYield", sp_recipeyield, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "recipeYield", sp_recipeyield, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "recipeYield", sp_recipeyield, t_text },
    { { 2, 0 }, { 0, 0 }, "recipient", sp_recipient, t_schema, sch_audience },
    { { 3, 3 }, { 0, 0 }, "recipient", sp_recipient, t_schema, sch_contactpoint },
    { { 2, 0 }, { 0, 0 }, "recipient", sp_recipient, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "recipient", sp_recipient, t_schema, sch_person },
    { { 3, 5 }, { 0, 0 }, "recognisedBy", sp_recognisedby, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "recognisingAuthority", sp_recognisingauthority, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "recommendationStrength", sp_recommendationstrength, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "recommendationStrength", sp_recommendationstrength, t_text },
    { { 2, 0 }, { 0, 0 }, "recommendedIntake", sp_recommendedintake, t_schema, sch_recommendeddoseschedule },
    { { 2, 0 }, { 0, 0 }, "recordLabel", sp_recordlabel, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "recordedAs", sp_recordedas, t_schema, sch_musicrecording },
    { { 2, 0 }, { 0, 0 }, "recordedAt", sp_recordedat, t_schema, sch_event },
    { { 2, 0 }, { 0, 0 }, "recordedIn", sp_recordedin, t_schema, sch_creativework },
    { { 2, 0 }, { 0, 0 }, "recordingOf", sp_recordingof, t_schema, sch_musiccomposition },
    { { 2, 0 }, { 0, 0 }, "recordingOf", sp_recordingof, t_schema, sch_musiccomposition },
    { { 3, 5 }, { 0, 0 }, "recourseLoan", sp_recourseloan, t_schema, sch_boolean },
    { { 3, 5 }, { 0, 0 }, "recourseLoan", sp_recourseloan, t_bool },
    { { 3, 0 }, { 0, 0 }, "referenceQuantity", sp_referencequantity, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "referencesOrder", sp_referencesorder, t_schema, sch_order },
    { { 6, 0 }, { 0, 0 }, "refundType", sp_refundtype, t_schema, sch_refundtypeenumeration },
    { { 2, 0 }, { 0, 0 }, "regionDrained", sp_regiondrained, t_schema, sch_anatomicalstructure },
    { { 2, 0 }, { 0, 0 }, "regionDrained", sp_regiondrained, t_schema, sch_anatomicalsystem },
    { { 2, 0 }, { 0, 0 }, "regionsAllowed", sp_regionsallowed, t_schema, sch_place },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "relatedAnatomy", sp_relatedanatomy, t_schema, sch_anatomicalstructure },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "relatedAnatomy", sp_relatedanatomy, t_schema, sch_anatomicalsystem },
    { { 2, 0 }, { 0, 0 }, "relatedCondition", sp_relatedcondition, t_schema, sch_medicalcondition },
    { { 2, 0 }, { 0, 0 }, "relatedDrug", sp_relateddrug, t_schema, sch_drug },
    { { 2, 0 }, { 0, 0 }, "relatedLink", sp_relatedlink, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "relatedLink", sp_relatedlink, t_url },
    { { 2, 0 }, { 0, 0 }, "relatedStructure", sp_relatedstructure, t_schema, sch_anatomicalstructure },
    { { 2, 0 }, { 0, 0 }, "relatedTherapy", sp_relatedtherapy, t_schema, sch_medicaltherapy },
    { { 2, 0 }, { 0, 0 }, "relatedTo", sp_relatedto, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "releaseDate", sp_releasedate, t_schema, sch_date },
    { { 2, 0 }, { 0, 0 }, "releaseDate", sp_releasedate, t_just_date },
    { { 2, 0 }, { 0, 0 }, "releaseNotes", sp_releasenotes, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "releaseNotes", sp_releasenotes, t_text },
    { { 2, 0 }, { 0, 0 }, "releaseNotes", sp_releasenotes, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "releaseNotes", sp_releasenotes, t_url },
    { { 2, 0 }, { 0, 0 }, "releaseOf", sp_releaseof, t_schema, sch_musicalbum },
    { { 2, 0 }, { 0, 0 }, "releasedEvent", sp_releasedevent, t_schema, sch_publicationevent },
    { { 3, 5 }, { 0, 0 }, "relevantOccupation", sp_relevantoccupation, t_schema, sch_occupation },
    { { 2, 0 }, { 0, 0 }, "relevantSpeciality", sp_relevantspeciality, t_schema, sch_medicalspeciality },
    { { 3, 1 }, { 0, 0 }, "remainingAttendeeCapacity", sp_remainingattendeecapacity, t_integer },
    { { 3, 5 }, { 0, 0 }, "renegotiableLoan", sp_renegotiableloan, t_schema, sch_boolean },
    { { 3, 5 }, { 0, 0 }, "renegotiableLoan", sp_renegotiableloan, t_bool },
    { { 3, 5 }, { 0, 0 }, "repeatCount", sp_repeatcount, t_schema, sch_integer },
    { { 3, 5 }, { 0, 0 }, "repeatCount", sp_repeatcount, t_integer },
    { { 3, 5 }, { 0, 0 }, "repeatFrequency", sp_repeatfrequency, t_schema, sch_duration },
    { { 3, 5 }, { 0, 0 }, "repeatFrequency", sp_repeatfrequency, t_duration },
    { { 3, 5 }, { 0, 0 }, "repeatFrequency", sp_repeatfrequency, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "repeatFrequency", sp_repeatfrequency, t_text },
    { { 2, 0 }, { 0, 0 }, "repetitions", sp_repetitions, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "repetitions", sp_repetitions, t_fixedpoint },
    { { 3, 5 }, { 0, 0 }, "repetitions", sp_repetitions, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "replacee", sp_replacee, t_schema, sch_thing },
    { { 2, 0 }, { 0, 0 }, "replacer", sp_replacer, t_schema, sch_thing },
    { { 2, 0 }, { 0, 0 }, "replyToUrl", sp_replytourl, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "replyToUrl", sp_replytourl, t_url },
    { { 2, 1 }, { 0, 0 }, "reportNumber", sp_reportnumber, t_schema, sch_text },
    { { 2, 1 }, { 0, 0 }, "reportNumber", sp_reportnumber, t_text },
    { { 2, 0 }, { 0, 0 }, "representativeOfPage", sp_representativeofpage, t_schema, sch_boolean },
    { { 2, 0 }, { 0, 0 }, "representativeOfPage", sp_representativeofpage, t_bool },
    { { 3, 0 }, { 0, 0 }, "requiredCollateral", sp_requiredcollateral, t_schema, sch_thing },
    { { 3, 0 }, { 0, 0 }, "requiredCollateral", sp_requiredcollateral, t_schema, sch_text },
    { { 3, 0 }, { 0, 0 }, "requiredCollateral", sp_requiredcollateral, t_text },
    { { 2, 0 }, { 0, 0 }, "requiredGender", sp_requiredgender, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "requiredGender", sp_requiredgender, t_text },
    { { 2, 0 }, { 0, 0 }, "requiredMaxAge", sp_requiredmaxage, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "requiredMaxAge", sp_requiredmaxage, t_integer },
    { { 2, 0 }, { 0, 0 }, "requiredMinAge", sp_requiredminage, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "requiredMinAge", sp_requiredminage, t_integer },
    { { 3, 3 }, { 0, 0 }, "requiredQuantity", sp_requiredquantity, t_schema, sch_number },
    { { 3, 3 }, { 0, 0 }, "requiredQuantity", sp_requiredquantity, t_fixedpoint },
    { { 3, 3 }, { 0, 0 }, "requiredQuantity", sp_requiredquantity, t_schema, sch_quantitativevalue },
    { { 3, 3 }, { 0, 0 }, "requiredQuantity", sp_requiredquantity, t_schema, sch_text },
    { { 3, 3 }, { 0, 0 }, "requiredQuantity", sp_requiredquantity, t_text },
    { { 3, 5 }, { 0, 0 }, "requiresSubscription", sp_requiressubscription, t_schema, sch_mediasubscription },
    { { 2, 0 }, { 0, 0 }, "requiresSubscription", sp_requiressubscription, t_schema, sch_boolean },
    { { 2, 0 }, { 0, 0 }, "requiresSubscription", sp_requiressubscription, t_bool },
    { { 2, 0 }, { 0, 0 }, "reservationFor", sp_reservationfor, t_schema, sch_thing },
    { { 2, 0 }, { 0, 0 }, "reservationId", sp_reservationid, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "reservationId", sp_reservationid, t_text },
    { { 2, 0 }, { 0, 0 }, "reservationStatus", sp_reservationstatus, t_schema, sch_reservationstatustype },
    { { 2, 0 }, { 0, 0 }, "reservedTicket", sp_reservedticket, t_schema, sch_ticket },
    { { 2, 0 }, { 0, 0 }, "responsibilities", sp_responsibilities, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "responsibilities", sp_responsibilities, t_text },
    { { 3, 5 }, { 0, 0 }, "restPeriods", sp_restperiods, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "restPeriods", sp_restperiods, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "restPeriods", sp_restperiods, t_text },
    { { 2, 0 }, { 0, 0 }, "result", sp_result, t_schema, sch_thing },
    { { 2, 0 }, { 0, 0 }, "resultComment", sp_resultcomment, t_schema, sch_comment },
    { { 2, 0 }, { 0, 0 }, "resultReview", sp_resultreview, t_schema, sch_review },
    { { 6, 0 }, { 0, 0 }, "returnFees", sp_returnfees, t_schema, sch_returnfeesenumeration },
    { { 6, 0 }, { 0, 0 }, "returnPolicyCategory", sp_returnpolicycategory, t_schema, sch_merchantreturnenumeration },
    { { 2, 0 }, { 0, 0 }, "review", sp_review, t_schema, sch_review },
    { { 3, 5 }, { 0, 0 }, "reviewAspect", sp_reviewaspect, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "reviewAspect", sp_reviewaspect, t_text },
    { { 2, 0 }, { 0, 0 }, "reviewBody", sp_reviewbody, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "reviewBody", sp_reviewbody, t_text },
    { { 2, 0 }, { 0, 0 }, "reviewCount", sp_reviewcount, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "reviewCount", sp_reviewcount, t_integer },
    { { 2, 0 }, { 0, 0 }, "reviewRating", sp_reviewrating, t_schema, sch_rating },
    { { 2, 0 }, { 0, 0 }, "reviewedBy", sp_reviewedby, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "reviewedBy", sp_reviewedby, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "riskFactor", sp_riskfactor, t_schema, sch_medicalriskfactor},
    { { 2, 0 }, { 0, 0 }, "risks", sp_risks, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "risks", sp_risks, t_text },
    { { 2, 0 }, { 0, 0 }, "roleName", sp_rolename, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "roleName", sp_rolename, t_text },
    { { 2, 0 }, { 0, 0 }, "roleName", sp_rolename, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "roleName", sp_rolename, t_url },
    { { 3, 5 }, { 0, 0 }, "roofLoad", sp_roofload, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "rsvpresponse", sp_rsvpresponse, t_schema, sch_rsvpresponsetype },
    { { 2, 0 }, { 0, 0 }, "runsTo", sp_runsto, t_schema, sch_vessel },
    { { 2, 0 }, { 0, 0 }, "runtimePlatform", sp_runtimeplatform, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "runtimePlatform", sp_runtimeplatform, t_text },
    { { 3, 5 }, { 0, 0 }, "rxcui", sp_rxcui, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "rxcui", sp_rxcui, t_text },
    { { 2, 0 }, { 0, 0 }, "safetyConsideration", sp_safetyconsideration, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "safetyConsideration", sp_safetyconsideration, t_text },
    { { 2, 0 }, { 0, 0 }, "salaryCurrency", sp_salarycurrency, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "salaryCurrency", sp_salarycurrency, t_text },
    { { 3, 9 }, { 0, 0 }, "salaryUponCompletion", sp_salaryuponcompletion, t_schema, sch_monetaryamountdistribution },
    { { 2, 0 }, { 0, 0 }, "sameAs", sp_sameas, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "sameAs", sp_sameas, t_url },
    { { 2, 0 }, { 0, 0 }, "saturatedFatContent", sp_saturatedfatcontent, t_schema, sch_mass },
    { { 2, 0 }, { 0, 0 }, "scheduledPaymentDate", sp_scheduledpaymentdate, t_schema, sch_date },
    { { 2, 0 }, { 0, 0 }, "scheduledPaymentDate", sp_scheduledpaymentdate, t_just_date },
    { { 2, 0 }, { 0, 0 }, "scheduledTime", sp_scheduledtime, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "scheduledTime", sp_scheduledtime, t_datetime },
    { { 2, 0 }, { 0, 0 }, "schemaVersion", sp_schemaversion, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "schemaVersion", sp_schemaversion, t_text },
    { { 2, 0 }, { 0, 0 }, "schemaVersion", sp_schemaversion, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "schemaVersion", sp_schemaversion, t_url },
    { { 7, 0 }, { 0, 0 }, "schoolClosuresInfo", sp_schoolclosuresinfo, t_schema, sch_webcontent },
    { { 7, 0 }, { 0, 0 }, "schoolClosuresInfo", sp_schoolclosuresinfo, t_schema, sch_url },
    { { 7, 0 }, { 0, 0 }, "schoolClosuresInfo", sp_schoolclosuresinfo, t_url },
    { { 2, 0 }, { 0, 0 }, "screenCount", sp_screencount, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "screenCount", sp_screencount, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "screenshot", sp_screenshot, t_schema, sch_imageobject },
    { { 2, 0 }, { 0, 0 }, "screenshot", sp_screenshot, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "screenshot", sp_screenshot, t_url },
    { { 3, 5 }, { 0, 0 }, "sdDatePublished", sp_sddatepublished, t_schema, sch_datetime },
    { { 3, 5 }, { 0, 0 }, "sdDatePublished", sp_sddatepublished, t_datetime },
    { { 3, 5 }, { 0, 0 }, "sdLicense", sp_sdlicense, t_schema, sch_creativework },
    { { 3, 5 }, { 0, 0 }, "sdLicense", sp_sdlicense, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "sdLicense", sp_sdlicense, t_url },
    { { 3, 5 }, { 0, 0 }, "sdPublisher", sp_sdpublisher, t_schema, sch_organisation },
    { { 3, 5 }, { 0, 0 }, "sdPublisher", sp_sdpublisher, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "seasonNumber", sp_seasonnumber, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "seasonNumber", sp_seasonnumber, t_integer },
    { { 2, 0 }, { 0, 0 }, "seasonNumber", sp_seasonnumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "seasonNumber", sp_seasonnumber, t_text },
    { { 2, 0 }, { 0, 0 }, "seatNumber", sp_seatnumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "seatNumber", sp_seatnumber, t_text },
    { { 2, 0 }, { 0, 0 }, "seatRow", sp_seatrow, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "seatRow", sp_seatrow, t_text },
    { { 2, 0 }, { 0, 0 }, "seatSection", sp_seatsection, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "seatSection", sp_seatsection, t_text },
    { { 3, 5 }, { 0, 0 }, "seatingCapacity", sp_seatingcapacity, t_schema, sch_number },
    { { 3, 5 }, { 0, 0 }, "seatingCapacity", sp_seatingcapacity, t_fixedpoint },
    { { 3, 5 }, { 0, 0 }, "seatingCapacity", sp_seatingcapacity, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "seatingType", sp_seatingtype, t_schema, sch_qualitativevalue },
    { { 2, 0 }, { 0, 0 }, "seatingType", sp_seatingtype, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "seatingType", sp_seatingtype, t_text },
    { { 2, 0 }, { 0, 0 }, "secondaryPrevention", sp_secondaryprevention, t_schema, sch_medicaltherapy },
    { { 6, 0 }, { 0, 0 }, "securityClearanceRequirement", sp_securityclearancerequirement, t_schema, sch_text },
    { { 6, 0 }, { 0, 0 }, "securityClearanceRequirement", sp_securityclearancerequirement, t_text },
    { { 6, 0 }, { 0, 0 }, "securityClearanceRequirement", sp_securityclearancerequirement, t_schema, sch_url },
    { { 6, 0 }, { 0, 0 }, "securityClearanceRequirement", sp_securityclearancerequirement, t_url },
    { { 2, 0 }, { 0, 0 }, "securityScreening", sp_securityscreening, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "securityScreening", sp_securityscreening, t_text },
    { { 2, 0 }, { 0, 0 }, "seeks", sp_seeks, t_schema, sch_demand },
    { { 2, 0 }, { 0, 0 }, "seller", sp_seller, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "seller", sp_seller, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "sender", sp_sender, t_schema, sch_audience },
    { { 2, 0 }, { 0, 0 }, "sender", sp_sender, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "sender", sp_sender, t_schema, sch_person },
    { { 6, 0 }, { 0, 0 }, "sensoryClearanceRequirement", sp_sensoryclearancerequirement, t_schema, sch_definedterm },
    { { 6, 0 }, { 0, 0 }, "sensoryClearanceRequirement", sp_sensoryclearancerequirement, t_schema, sch_text },
    { { 6, 0 }, { 0, 0 }, "sensoryClearanceRequirement", sp_sensoryclearancerequirement, t_text },
    { { 6, 0 }, { 0, 0 }, "sensoryClearanceRequirement", sp_sensoryclearancerequirement, t_schema, sch_url },
    { { 6, 0 }, { 0, 0 }, "sensoryClearanceRequirement", sp_sensoryclearancerequirement, t_url },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "sensoryUnit", sp_sensoryunit, t_schema, sch_anatomicalstructure },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "sensoryUnit", sp_sensoryunit, t_schema, sch_superficialanatomy },
    { { 2, 0 }, { 0, 0 }, "serialNumber", sp_serialnumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "serialNumber", sp_serialnumber, t_text },
    { { 2, 0 }, { 0, 0 }, "seriousAdverseOutcome", sp_seriousadverseoutcome, t_schema, sch_medicalentity },
    { { 2, 0 }, { 0, 0 }, "serverStatus", sp_serverstatus, t_schema, sch_gameserverstatus },
    { { 2, 0 }, { 0, 0 }, "servesCuisine", sp_servescuisine, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "servesCuisine", sp_servescuisine, t_text },
    { { 2, 0 }, { 0, 0 }, "serviceArea", sp_servicearea, t_schema, sch_administrativearea },
    { { 2, 0 }, { 0, 0 }, "serviceLocation", sp_servicelocation, t_schema, sch_place },
    { { 2, 0 }, { 0, 0 }, "serviceOperator", sp_serviceoperator, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "serviceOutput", sp_serviceoutput, t_schema, sch_thing },
    { { 2, 0 }, { 0, 0 }, "servicePhone", sp_servicephone, t_schema, sch_contactpoint },
    { { 2, 0 }, { 0, 0 }, "servicePostalAddress", sp_servicepostaladdress, t_schema, sch_postaladdress },
    { { 2, 0 }, { 0, 0 }, "serviceSmsNumber", sp_servicesmsnumber, t_schema, sch_contactpoint },
    { { 7, 4 }, { 0, 0 }, "serviceType", sp_servicetype, t_schema, sch_governmentbenefitstype },
    { { 2, 0 }, { 0, 0 }, "serviceType", sp_servicetype, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "serviceType", sp_servicetype, t_text },
    { { 2, 0 }, { 0, 0 }, "serviceUrl", sp_serviceurl, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "serviceUrl", sp_serviceurl, t_url },
    { { 2, 0 }, { 0, 0 }, "servingSize", sp_servingsize, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "servingSize", sp_servingsize, t_text },
    { { 2, 1 }, { 0, 0 }, "sharedContent", sp_sharedcontent, t_schema, sch_creativework },
    { { 7, 2 }, { 0, 0 }, "shippingDestination", sp_shippingdestination, t_schema, sch_definedregion },
    { { 8, 0 }, { 0, 0 }, "shippingLabel", sp_shippinglabel, t_schema, sch_text },
    { { 8, 0 }, { 0, 0 }, "shippingLabel", sp_shippinglabel, t_text },
    { { 8, 0 }, { 0, 0 }, "shippingRate", sp_shippingrate, t_schema, sch_monetaryamount },
    { { 8, 0 }, { 0, 0 }, "shippingSettingsLink", sp_shippingsettingslink, t_schema, sch_url },
    { { 8, 0 }, { 0, 0 }, "shippingSettingsLink", sp_shippingsettingslink, t_url },
    { { 2, 0 }, { 0, 0 }, "sibling", sp_sibling, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "signDetected", sp_signdetected, t_schema, sch_medicalsign },
    { { 2, 0 }, { 0, 0 }, "signOrSymptom", sp_signorsymptom, t_schema, sch_medicalsignorsymptom},
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "significance", sp_significance, t_schema, sch_text },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "significance", sp_significance, t_text },
    { { 2, 0 }, { 0, 0 }, "significantLink", sp_significantlink, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "significantLink", sp_significantlink, t_url },
    { { 9, 0 }, { 0, 0 }, "size", sp_size, t_schema, sch_definedterm },
    { { 9, 0 }, { 0, 0 }, "size", sp_size, t_schema, sch_quantitativevalue },
    { { 9, 0 }, { 0, 0 }, "size", sp_size, t_schema, sch_text },
    { { 9, 0 }, { 0, 0 }, "size", sp_size, t_text },
    { { 5, 0 }, { 0, 0 }, "skills", sp_skills, t_schema, sch_definedterm },
    { { 2, 0 }, { 0, 0 }, "skills", sp_skills, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "skills", sp_skills, t_text },
    { { 2, 0 }, { 0, 0 }, "sku", sp_sku, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "sku", sp_sku, t_text },
    { { 3, 5 }, { 0, 0 }, "slogan", sp_slogan, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "slogan", sp_slogan, t_text },
    { { 3, 1 }, { 0, 0 }, "smokingAllowed", sp_smokingallowed, t_schema, sch_boolean },
    { { 3, 1 }, { 0, 0 }, "smokingAllowed", sp_smokingallowed, t_bool },
    { { 2, 0 }, { 0, 0 }, "sodiumContent", sp_sodiumcontent, t_schema, sch_mass },
    { { 2, 0 }, { 0, 0 }, "softwareAddOn", sp_softwareaddon, t_schema, sch_softwareapplication },
    { { 2, 0 }, { 0, 0 }, "softwareHelp", sp_softwarehelp, t_schema, sch_creativework },
    { { 2, 0 }, { 0, 0 }, "softwareRequirements", sp_softwarerequirements, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "softwareRequirements", sp_softwarerequirements, t_text },
    { { 2, 0 }, { 0, 0 }, "softwareRequirements", sp_softwarerequirements, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "softwareRequirements", sp_softwarerequirements, t_url },
    { { 2, 0 }, { 0, 0 }, "softwareVersion", sp_softwareversion, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "softwareVersion", sp_softwareversion, t_text },
    { { 2, 0 }, { 6, 0 }, "source", sp_source, t_schema, sch_anatomicalstructure },
    { { 2, 0 }, { 0, 0 }, "sourceOrganization", sp_sourceorganisation, t_schema, sch_organisation },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "sourcedFrom", sp_sourcedfrom, t_schema, sch_brainstructure },
    { { 2, 0 }, { 0, 0 }, "spatial", sp_spatial, t_schema, sch_place },
    { { 3, 1 }, { 0, 0 }, "spatialCoverage", sp_spatialcoverage, t_schema, sch_place },
    { { 3, 5 }, { 0, 0 }, "speakable", sp_speakable, t_schema, sch_speakablespecification },
    { { 3, 5 }, { 0, 0 }, "speakable", sp_speakable, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "speakable", sp_speakable, t_url },
    { { 2, 0 }, { 0, 0 }, "specialCommitments", sp_specialcommitments, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "specialCommitments", sp_specialcommitments, t_text },
    { { 3, 0 }, { 0, 0 }, "specialOpeningHoursSpecification", sp_specialopeninghoursspecification, t_schema, sch_openinghoursspecification },
    { { 2, 0 }, { 0, 0 }, "specialty", sp_speciality, t_schema, sch_speciality },
    { { 6, 0 }, { 0, 0 }, "speechToTextMarkup", sp_speechtotextmarkup, t_schema, sch_text },
    { { 6, 0 }, { 0, 0 }, "speechToTextMarkup", sp_speechtotextmarkup, t_text },
    { { 3, 5 }, { 0, 0 }, "speed", sp_speed, t_schema, sch_quantitativevalue },
    { { 3, 5 }, { 0, 0 }, "spokenByCharacter", sp_spokenbycharacter, t_schema, sch_organisation },
    { { 3, 5 }, { 0, 0 }, "spokenByCharacter", sp_spokenbycharacter, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "sponsor", sp_sponsor, t_schema, sch_organisation },
    { { 3, 1 }, { 0, 0 }, "sponsor", sp_sponsor, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "sport", sp_sport, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "sport", sp_sport, t_text },
    { { 2, 0 }, { 0, 0 }, "sport", sp_sport, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "sport", sp_sport, t_url },
    { { 2, 0 }, { 0, 0 }, "sportsActivityLocation", sp_sportsactivitylocation, t_schema, sch_sportsactivitylocation },
    { { 2, 0 }, { 0, 0 }, "sportsEvent", sp_sportsevent, t_schema, sch_sportsevent },
    { { 2, 0 }, { 0, 0 }, "sportsTeam", sp_sportsteam, t_schema, sch_sportsteam },
    { { 2, 0 }, { 0, 0 }, "spouse", sp_spouse, t_schema, sch_person },
    { { 6, 0 }, { 0, 0 }, "sscheduleTimezone", sp_scheduletimezone, t_schema, sch_text },
    { { 6, 0 }, { 0, 0 }, "sscheduleTimezone", sp_scheduletimezone, t_text },
    { { 2, 0 }, { 0, 0 }, "stage", sp_stage, t_schema, sch_medicalconditionstage },
    { { 2, 0 }, { 0, 0 }, "stageAsNumber", sp_stageasnumber, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "stageAsNumber", sp_stageasnumber, t_fixedpoint },
    { { 3, 1 }, { 0, 0 }, "starRating", sp_starrating, t_schema, sch_rating },
    { { 2, 0 }, { 0, 0 }, "startDate", sp_startdate, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "startDate", sp_startdate, t_datetime },
    { { 6, 0 }, { 0, 0 }, "startDate", sp_startdate, t_schema, sch_date },
    { { 6, 0 }, { 0, 0 }, "startDate", sp_startdate, t_just_date },
    { { 3, 5 }, { 0, 0 }, "startOffset", sp_startoffset, t_schema, sch_number },
    { { 3, 5 }, { 0, 0 }, "startOffset", sp_startoffset, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "startTime", sp_starttime, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "startTime", sp_starttime, t_datetime },
    { { 3, 8 }, { 0, 0 }, "startTime", sp_starttime, t_schema, sch_time },
    { { 3, 8 }, { 0, 0 }, "startTime", sp_starttime, t_just_time },
    { { 3, 5 }, { 0, 0 }, "status", sp_status, t_schema, sch_eventstatustype },
    { { 2, 0 }, { 0, 0 }, "status", sp_status, t_schema, sch_medicalstudystatus },
    { { 3, 5 }, { 0, 0 }, "status", sp_status, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "status", sp_status, t_text },
    { { 2, 0 }, { 0, 0 }, "steeringPosition", sp_steeringposition, t_schema, sch_steeringpositionvalue },
    { { 2, 0 }, { 0, 0 }, "stepValue", sp_stepvalue, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "stepValue", sp_stepvalue, t_fixedpoint },
    { { 3, 4 }, { 0, 0 }, "step", sp_step, t_schema, sch_creativework },
    { { 3, 4 }, { 0, 0 }, "step", sp_step, t_schema, sch_howtosection },
    { { 3, 4 }, { 0, 0 }, "step", sp_step, t_schema, sch_itemlist },
    { { 3, 4 }, { 0, 0 }, "step", sp_step, t_schema, sch_text },
    { { 3, 4 }, { 0, 0 }, "step", sp_step, t_text },
    { { 3, 3 }, { 3, 3 }, "steps", sp_steps, t_schema, sch_creativework },
    { { 3, 3 }, { 3, 3 }, "steps", sp_steps, t_schema, sch_itemlist },
    { { 3, 3 }, { 3, 3 }, "steps", sp_steps, t_schema, sch_text },
    { { 3, 3 }, { 3, 3 }, "steps", sp_steps, t_text },
    { { 2, 0 }, { 0, 0 }, "storageRequirements", sp_storagerequirements, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "storageRequirements", sp_storagerequirements, t_text },
    { { 2, 0 }, { 0, 0 }, "storageRequirements", sp_storagerequirements, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "storageRequirements", sp_storagerequirements, t_url },
    { { 2, 0 }, { 0, 0 }, "streetAddress", sp_streetaddress, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "streetAddress", sp_streetaddress, t_text },
    { { 2, 0 }, { 0, 0 }, "strengthUnit", sp_strengthunit, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "strengthUnit", sp_strengthunit, t_text },
    { { 2, 0 }, { 0, 0 }, "strengthValue", sp_strengthvalue, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "strengthValue", sp_strengthvalue, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "structuralClass", sp_structuralclass, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "structuralClass", sp_structuralclass, t_text },
    { { 2, 0 }, { 0, 0 }, "study", sp_study, t_schema, sch_medicalstudy },
    { { 2, 0 }, { 0, 0 }, "studyDesign", sp_studydesign, t_schema, sch_medicalobservationalstudydesign },
    { { 2, 0 }, { 0, 0 }, "studyLocation", sp_studylocation, t_schema, sch_administrativearea },
    { { 2, 0 }, { 0, 0 }, "studySubject", sp_studysubject, t_schema, sch_medicalentity },
    { { 3, 5 }, { 0, 0 }, "stupidproperty", sp_stupidproperty, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "subEvent", sp_subevent, t_schema, sch_event },
    { { 2, 0 }, { 0, 0 }, "subOrganization", sp_suborganisation, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "subReservation", sp_subreservation, t_schema, sch_reservation },
    { { 2, 0 }, { 0, 0 }, "subStageSuffix", sp_substagesuffix, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "subStageSuffix", sp_substagesuffix, t_text },
    { { 2, 0 }, { 0, 0 }, "subStructure", sp_substructure, t_schema, sch_anatomicalstructure },
    { { 3, 5 }, { 0, 0 }, "subTrip", sp_subtrip, t_schema, sch_trip },
    { { 3, 5 }, { 0, 0 }, "subjectOf", sp_subjectof, t_schema, sch_creativework },
    { { 3, 5 }, { 0, 0 }, "subjectOf", sp_subjectof, t_schema, sch_event },
    { { 2, 0 }, { 0, 0 }, "subtitleLanguage", sp_subtitlelanguage, t_schema, sch_language },
    { { 2, 0 }, { 0, 0 }, "subtitleLanguage", sp_subtitlelanguage, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "subtitleLanguage", sp_subtitlelanguage, t_text },
    { { 2, 0 }, { 6, 0 }, "subtype", sp_subtype, t_schema, sch_text },
    { { 2, 0 }, { 6, 0 }, "subtype", sp_subtype, t_text },
    { { 2, 0 }, { 0, 0 }, "successorOf", sp_successorof, t_schema, sch_productmodel },
    { { 2, 0 }, { 0, 0 }, "sugarContent", sp_sugarcontent, t_schema, sch_mass },
    { { 2, 0 }, { 0, 0 }, "suggestedAnswer", sp_suggestedanswer, t_schema, sch_answer },
    { { 3, 4 }, { 0, 0 }, "suggestedAnswer", sp_suggestedanswer, t_schema, sch_itemlist },
    { { 2, 0 }, { 0, 0 }, "suggestedGender", sp_suggestedgender, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "suggestedGender", sp_suggestedgender, t_text },
    { { 2, 0 }, { 0, 0 }, "suggestedMaxAge", sp_suggestedmaxage, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "suggestedMaxAge", sp_suggestedmaxage, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "suggestedMinAge", sp_suggestedminage, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "suggestedMinAge", sp_suggestedminage, t_fixedpoint },
    { { 3, 0 }, { 0, 0 }, "suitableForDiet", sp_suitablefordiet, t_schema, sch_restricteddiet },
    { { 2, 0 }, { 0, 0 }, "superEvent", sp_superevent, t_schema, sch_event },
    { { 2, 0 }, { 0, 0 }, "supersededBy", sp_supersededby, t_schema, sch_class },
    { { 2, 0 }, { 0, 0 }, "supersededBy", sp_supersededby, t_schema, sch_enumeration },
    { { 2, 0 }, { 0, 0 }, "supersededBy", sp_supersededby, t_schema, sch_property },
    { { 3, 3 }, { 0, 0 }, "supply", sp_supply, t_schema, sch_howtosupply },
    { { 3, 3 }, { 0, 0 }, "supply", sp_supply, t_schema, sch_text },
    { { 3, 3 }, { 0, 0 }, "supply", sp_supply, t_text },
    { { 2, 0 }, { 0, 0 }, "supplyTo", sp_supplyto, t_schema, sch_anatomicalstructure },
    { { 2, 2 }, { 0, 0 }, "supportingData", sp_supportingdata, t_schema, sch_datafeed },
    { { 2, 0 }, { 0, 0 }, "suspersededBy", sp_suspersededby, t_schema, sch_class },
    { { 2, 0 }, { 0, 0 }, "suspersededBy", sp_suspersededby, t_schema, sch_enumeration },
    { { 2, 0 }, { 0, 0 }, "suspersededBy", sp_suspersededby, t_schema, sch_property },
    { { 2, 0 }, { 0, 0 }, "target", sp_target, t_schema, sch_entrypoint },
    { { 2, 0 }, { 0, 0 }, "targetCollection", sp_targetcollection, t_schema, sch_thing },
    { { 2, 0 }, { 0, 0 }, "targetDescription", sp_targetdescription, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "targetDescription", sp_targetdescription, t_text },
    { { 2, 0 }, { 0, 0 }, "targetName", sp_targetname, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "targetName", sp_targetname, t_text },
    { { 2, 0 }, { 0, 0 }, "targetPlatform", sp_targetplatform, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "targetPlatform", sp_targetplatform, t_text },
    { { 2, 0 }, { 0, 0 }, "targetPopulation", sp_targetpopulation, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "targetPopulation", sp_targetpopulation, t_text },
    { { 2, 0 }, { 0, 0 }, "targetUrl", sp_targeturl, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "targetUrl", sp_targeturl, t_url },
    { { 2, 0 }, { 0, 0 }, "taxID", sp_taxid, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "taxID", sp_taxid, t_text },
    { { 8, 0 }, { 0, 0 }, "teaches", sp_teaches, t_schema, sch_definedterm },
    { { 8, 0 }, { 0, 0 }, "teaches", sp_teaches, t_schema, sch_text },
    { { 8, 0 }, { 0, 0 }, "teaches", sp_teaches, t_text },
    { { 2, 0 }, { 0, 0 }, "telephone", sp_telephone, t_tel },
    { { 3, 5 }, { 0, 0 }, "temporal", sp_temporal, t_schema, sch_datetime },
    { { 3, 5 }, { 0, 0 }, "temporal", sp_temporal, t_datetime },
    { { 3, 5 }, { 0, 0 }, "temporal", sp_temporal, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "temporal", sp_temporal, t_text },
    { { 3, 1 }, { 0, 0 }, "temporalCoverage", sp_temporalcoverage, t_schema, sch_datetime },
    { { 3, 1 }, { 0, 0 }, "temporalCoverage", sp_temporalcoverage, t_datetime },
    { { 3, 1 }, { 0, 0 }, "temporalCoverage", sp_temporalcoverage, t_schema, sch_text },
    { { 3, 1 }, { 0, 0 }, "temporalCoverage", sp_temporalcoverage, t_text },
    { { 3, 1 }, { 0, 0 }, "temporalCoverage", sp_temporalcoverage, t_schema, sch_url },
    { { 3, 1 }, { 0, 0 }, "temporalCoverage", sp_temporalcoverage, t_url },
    { { 3, 5 }, { 0, 0 }, "termCode", sp_termcode, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "termCode", sp_termcode, t_text },
    { { 6, 0 }, { 0, 0 }, "termDuration", sp_termduration, t_schema, sch_duration },
    { { 6, 0 }, { 0, 0 }, "termDuration", sp_termduration, t_duration },
    { { 3, 5 }, { 0, 0 }, "termsOfService", sp_termsofservice, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "termsOfService", sp_termsofservice, t_text },
    { { 3, 5 }, { 0, 0 }, "termsOfService", sp_termsofservice, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "termsOfService", sp_termsofservice, t_url },
    { { 6, 0 }, { 0, 0 }, "termsPerYear", sp_termsperyear, t_schema, sch_number },
    { { 6, 0 }, { 0, 0 }, "termsPerYear", sp_termsperyear, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "text", sp_text, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "text", sp_text, t_text },
    { { 6, 0 }, { 0, 0 }, "textValue", sp_textvalue, t_schema, sch_text },
    { { 6, 0 }, { 0, 0 }, "textValue", sp_textvalue, t_text },
    { { 2, 0 }, { 0, 0 }, "thumbnail", sp_thumbnail, t_schema, sch_imageobject },
    { { 2, 0 }, { 0, 0 }, "thumbnailUrl", sp_thumbnailurl, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "thumbnailUrl", sp_thumbnailurl, t_url },
    { { 2, 0 }, { 0, 0 }, "tickerSymbol", sp_tickersymbol, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "tickerSymbol", sp_tickersymbol, t_text },
    { { 2, 0 }, { 0, 0 }, "ticketNumber", sp_ticketnumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "ticketNumber", sp_ticketnumber, t_text },
    { { 2, 0 }, { 0, 0 }, "ticketToken", sp_tickettoken, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "ticketToken", sp_tickettoken, t_text },
    { { 2, 0 }, { 0, 0 }, "ticketToken", sp_tickettoken, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "ticketToken", sp_tickettoken, t_url },
    { { 2, 0 }, { 0, 0 }, "ticketedSeat", sp_ticketedseat, t_schema, sch_seat },
    { { 6, 0 }, { 0, 0 }, "timeOfDay", sp_timeofday, t_schema, sch_text },
    { { 6, 0 }, { 0, 0 }, "timeOfDay", sp_timeofday, t_text },
    { { 2, 0 }, { 0, 0 }, "timeRequired", sp_timerequired, t_schema, sch_duration },
    { { 2, 0 }, { 0, 0 }, "timeRequired", sp_timerequired, t_duration },
    { { 3, 9 }, { 0, 0 }, "timeToComplete", sp_timetocomplete, t_schema, sch_duration },
    { { 3, 9 }, { 0, 0 }, "timeToComplete", sp_timetocomplete, t_duration },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "tissueSample", sp_tissuesample, t_schema, sch_text },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "tissueSample", sp_tissuesample, t_text },
    { { 2, 0 }, { 0, 0 }, "title", sp_title, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "title", sp_title, t_text },
    { { 8, 0 }, { 0, 0 }, "titleEIDR", sp_titleeidr, t_schema, sch_text },
    { { 8, 0 }, { 0, 0 }, "titleEIDR", sp_titleeidr, t_text },
    { { 8, 0 }, { 0, 0 }, "titleEIDR", sp_titleeidr, t_schema, sch_url },
    { { 8, 0 }, { 0, 0 }, "titleEIDR", sp_titleeidr, t_url },
    { { 2, 0 }, { 0, 0 }, "toLocation", sp_tolocation, t_schema, sch_place },
    { { 3, 3 }, { 0, 0 }, "toRecipient", sp_torecipient, t_schema, sch_audience },
    { { 3, 3 }, { 0, 0 }, "toRecipient", sp_torecipient, t_schema, sch_contactpoint },
    { { 3, 3 }, { 0, 0 }, "toRecipient", sp_torecipient, t_schema, sch_organisation },
    { { 3, 3 }, { 0, 0 }, "toRecipient", sp_torecipient, t_schema, sch_person },
    { { 3, 5 }, { 0, 0 }, "tongueWeight", sp_tongueweight, t_schema, sch_quantitativevalue },
    { { 3, 3 }, { 0, 0 }, "tool", sp_tool, t_schema, sch_howtotool },
    { { 3, 3 }, { 0, 0 }, "tool", sp_tool, t_schema, sch_text },
    { { 3, 3 }, { 0, 0 }, "tool", sp_tool, t_text },
    { { 3, 5 }, { 0, 0 }, "torque", sp_torque, t_schema, sch_quantitativevalue },
    { { 4, 0 }, { 0, 0 }, "totalJobOpenings", sp_totaljobopenings, t_schema, sch_integer },
    { { 4, 0 }, { 0, 0 }, "totalJobOpenings", sp_totaljobopenings, t_integer },
    { { 3, 0 }, { 0, 0 }, "totalPaymentDue", sp_totalpaymentdue, t_schema, sch_monetaryamount },
    { { 2, 0 }, { 0, 0 }, "totalPaymentDue", sp_totalpaymentdue, t_schema, sch_pricespecification },
    { { 2, 0 }, { 0, 0 }, "totalPrice", sp_totalprice, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "totalPrice", sp_totalprice, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "totalPrice", sp_totalprice, t_schema, sch_pricespecification },
    { { 2, 0 }, { 0, 0 }, "totalPrice", sp_totalprice, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "totalPrice", sp_totalprice, t_text },
    { { 2, 0 }, { 0, 0 }, "totalTime", sp_totaltime, t_schema, sch_duration },
    { { 2, 0 }, { 0, 0 }, "totalTime", sp_totaltime, t_duration },
    { { 7, 0 }, { 0, 0 }, "tourBookingPage", sp_tourbookingpage, t_schema, sch_url },
    { { 7, 0 }, { 0, 0 }, "tourBookingPage", sp_tourbookingpage, t_url },
    { { 3, 3 }, { 0, 0 }, "touristType", sp_touristtype, t_schema, sch_audience },
    { { 3, 3 }, { 0, 0 }, "touristType", sp_touristtype, t_schema, sch_text },
    { { 3, 3 }, { 0, 0 }, "touristType", sp_touristtype, t_text },
    { { 2, 0 }, { 0, 0 }, "track", sp_track, t_schema, sch_itemlist },
    { { 2, 0 }, { 0, 0 }, "track", sp_track, t_schema, sch_musicrecording },
    { { 2, 0 }, { 0, 0 }, "trackingNumber", sp_trackingnumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "trackingNumber", sp_trackingnumber, t_text },
    { { 2, 0 }, { 0, 0 }, "trackingUrl", sp_trackingurl, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "trackingUrl", sp_trackingurl, t_url },
    { { 2, 0 }, { 0, 0 }, "trailer", sp_trailer, t_schema, sch_videoobject },
    { { 3, 5 }, { 0, 0 }, "trailerWeight", sp_trailerweight, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "trainName", sp_trainname, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "trainName", sp_trainname, t_text },
    { { 2, 0 }, { 0, 0 }, "trainNumber", sp_trainnumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "trainNumber", sp_trainnumber, t_text },
    { { 3, 9 }, { 0, 0 }, "trainingSalary", sp_trainingsalary, t_schema, sch_monetaryamountdistribution },
    { { 2, 0 }, { 0, 0 }, "transFatContent", sp_transfatcontent, t_schema, sch_mass },
    { { 2, 0 }, { 0, 0 }, "transcript", sp_transcript, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "transcript", sp_transcript, t_text },
    { { 8, 0 }, { 0, 0 }, "transitTime", sp_transittime, t_schema, sch_quantitativevalue },
    { { 8, 0 }, { 0, 0 }, "transitTimeLabel", sp_transittimelabel, t_schema, sch_text },
    { { 8, 0 }, { 0, 0 }, "transitTimeLabel", sp_transittimelabel, t_text },
    { { 2, 0 }, { 0, 0 }, "translationOfWork", sp_translationofwork, t_schema, sch_creativework },
    { { 2, 0 }, { 0, 0 }, "translator", sp_translator, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "translator", sp_translator, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "transmissionMethod", sp_transmissionmethod, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "transmissionMethod", sp_transmissionmethod, t_text },
    { { 7, 0 }, { 0, 0 }, "travelBans", sp_travelbans, t_schema, sch_webcontent },
    { { 7, 0 }, { 0, 0 }, "travelBans", sp_travelbans, t_schema, sch_url },
    { { 7, 0 }, { 0, 0 }, "travelBans", sp_travelbans, t_url },
    { { 2, 0 }, { 0, 0 }, "trialDesign", sp_trialdesign, t_schema, sch_medicaltrialdesign },
    { { 2, 0 }, { 0, 0 }, "tributary", sp_tributary, t_schema, sch_anatomicalstructure },
    { { 3, 5 }, { 0, 0 }, "typeOfBed", sp_typeofbed, t_schema, sch_bedtype },
    { { 3, 1 }, { 0, 0 }, "typeOfBed", sp_typeofbed, t_schema, sch_text },
    { { 3, 1 }, { 0, 0 }, "typeOfBed", sp_typeofbed, t_text },
    { { 2, 0 }, { 0, 0 }, "typeOfGood", sp_typeofgood, t_schema, sch_product },
    { { 3, 1 }, { 0, 0 }, "typeOfGood", sp_typeofgood, t_schema, sch_service },
    { { 2, 0 }, { 0, 0 }, "typicalAgeRange", sp_typicalagerange, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "typicalAgeRange", sp_typicalagerange, t_text },
    { { 6, 0 }, { 0, 0 }, "typicalCreditsPerTerm", sp_typicalcreditsperterm, t_schema, sch_integer },
    { { 6, 0 }, { 0, 0 }, "typicalCreditsPerTerm", sp_typicalcreditsperterm, t_integer },
    { { 6, 0 }, { 0, 0 }, "typicalCreditsPerTerm", sp_typicalcreditsperterm, t_schema, sch_structuredvalue },
    { { 2, 0 }, { 0, 0 }, "typicalTest", sp_typicaltest, t_schema, sch_medicaltest },
    { { 2, 0 }, { 0, 0 }, "underName", sp_undername, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "underName", sp_undername, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "unitCode", sp_unitcode, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "unitCode", sp_unitcode, t_text },
    { { 2, 0 }, { 0, 0 }, "unitCode", sp_unitcode, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "unitCode", sp_unitcode, t_url },
    { { 2, 0 }, { 0, 0 }, "unitText", sp_unittext, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "unitText", sp_unittext, t_text },
    { { 3, 5 }, { 0, 0 }, "unnamedSourcesPolicy", sp_unnamedsourcespolicy, t_schema, sch_creativework },
    { { 3, 5 }, { 0, 0 }, "unnamedSourcesPolicy", sp_unnamedsourcespolicy, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "unnamedSourcesPolicy", sp_unnamedsourcespolicy, t_url },
    { { 2, 0 }, { 0, 0 }, "unsaturatedFatContent", sp_unsaturatedfatcontent, t_schema, sch_mass },
    { { 2, 0 }, { 0, 0 }, "uploadDate", sp_uploaddate, t_schema, sch_date },
    { { 2, 0 }, { 0, 0 }, "uploadDate", sp_uploaddate, t_just_date },
    { { 2, 0 }, { 0, 0 }, "upvoteCount", sp_upvotecount, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "upvoteCount", sp_upvotecount, t_integer },
    { { 2, 0 }, { 0, 0 }, "url", sp_url, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "url", sp_url, t_url },
    { { 2, 0 }, { 0, 0 }, "urlTemplate", sp_urltemplate, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "urlTemplate", sp_urltemplate, t_text },
    { { 7, 0 }, { 0, 0 }, "usageInfo", sp_usageinfo, t_schema, sch_creativework },
    { { 7, 0 }, { 0, 0 }, "usageInfo", sp_usageinfo, t_schema, sch_url },
    { { 7, 0 }, { 0, 0 }, "usageInfo", sp_usageinfo, t_url },
    { { 2, 0 }, { 0, 0 }, "usedToDiagnose", sp_usedtodiagnose, t_schema, sch_medicalcondition },
    { { 2, 0 }, { 0, 0 }, "userInteractionCount", sp_userinteractioncount, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "userInteractionCount", sp_userinteractioncount, t_integer },
    { { 2, 0 }, { 0, 0 }, "usesDevice", sp_usesdevice, t_schema, sch_medicaldevice },
    { { 3, 5 }, { 0, 0 }, "usesHealthPlanIdStandard", sp_useshealthplanidstandard, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "usesHealthPlanIdStandard", sp_useshealthplanidstandard, t_text },
    { { 3, 5 }, { 0, 0 }, "usesHealthPlanIdStandard", sp_useshealthplanidstandard, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "usesHealthPlanIdStandard", sp_useshealthplanidstandard, t_url },
    { { 2, 0 }, { 0, 0 }, "validFor", sp_validfor, t_schema, sch_duration },
    { { 2, 0 }, { 0, 0 }, "validFor", sp_validfor, t_duration },
    { { 2, 0 }, { 0, 0 }, "validFrom", sp_validfrom, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "validFrom", sp_validfrom, t_datetime },
    { { 2, 0 }, { 0, 0 }, "validIn", sp_validin, t_schema, sch_administrativearea },
    { { 2, 0 }, { 0, 0 }, "validThrough", sp_validthrough, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "validThrough", sp_validthrough, t_datetime },
    { { 4, 0 }, { 0, 0 }, "validThrough", sp_validthrough, t_schema, sch_date },
    { { 4, 0 }, { 0, 0 }, "validThrough", sp_validthrough, t_just_date },
    { { 2, 0 }, { 0, 0 }, "validUntil", sp_validuntil, t_schema, sch_date },
    { { 2, 0 }, { 0, 0 }, "validUntil", sp_validuntil, t_just_date },
    { { 2, 0 }, { 0, 0 }, "value", sp_value, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "value", sp_value, t_fixedpoint },
    { { 3, 0 }, { 0, 0 }, "value", sp_value, t_schema, sch_structuredvalue },
    { { 3, 0 }, { 0, 0 }, "value", sp_value, t_schema, sch_boolean },
    { { 3, 0 }, { 0, 0 }, "value", sp_value, t_bool },
    { { 3, 0 }, { 0, 0 }, "value", sp_value, t_schema, sch_text },
    { { 3, 0 }, { 0, 0 }, "value", sp_value, t_text },
    { { 2, 0 }, { 0, 0 }, "valueAddedTaxIncluded", sp_valueaddedtaxincluded, t_schema, sch_boolean },
    { { 2, 0 }, { 0, 0 }, "valueAddedTaxIncluded", sp_valueaddedtaxincluded, t_bool },
    { { 2, 0 }, { 0, 0 }, "valueMaxLength", sp_valuemaxlength, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "valueMaxLength", sp_valuemaxlength, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "valueMinLength", sp_valueminlength, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "valueMinLength", sp_valueminlength, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "valueName", sp_valuename, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "valueName", sp_valuename, t_text },
    { { 2, 0 }, { 0, 0 }, "valuePattern", sp_valuepattern, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "valuePattern", sp_valuepattern, t_text },
    { { 2, 0 }, { 0, 0 }, "valueReference", sp_valuereference, t_schema, sch_enumeration },
    { { 2, 0 }, { 0, 0 }, "valueReference", sp_valuereference, t_schema, sch_propertyvalue },
    { { 2, 0 }, { 0, 0 }, "valueReference", sp_valuereference, t_schema, sch_qualitativevalue },
    { { 2, 0 }, { 0, 0 }, "valueReference", sp_valuereference, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "valueReference", sp_valuereference, t_schema, sch_structuredvalue },
    { { 2, 0 }, { 0, 0 }, "valueRequired", sp_valuerequired, t_schema, sch_boolean },
    { { 2, 0 }, { 0, 0 }, "valueRequired", sp_valuerequired, t_bool },
    { { 3, 5 }, { 0, 0 }, "variableMeasured", sp_variablemeasured, t_schema, sch_propertyvalue },
    { { 3, 5 }, { 0, 0 }, "variableMeasured", sp_variablemeasured, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "variableMeasured", sp_variablemeasured, t_text },
    { { 3, 5 }, { 0, 0 }, "variablesMeasured", sp_variablesmeasured, t_schema, sch_propertyvalue },
    { { 3, 5 }, { 0, 0 }, "variablesMeasured", sp_variablesmeasured, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "variablesMeasured", sp_variablesmeasured, t_text },
    { { 3, 5 }, { 0, 0 }, "variantCover", sp_variantcover, t_schema, sch_text },
    { { 3, 5 }, { 0, 0 }, "variantCover", sp_variantcover, t_text },
    { { 9, 0 }, { 0, 0 }, "variesBy", sp_variesby, t_schema, sch_definedterm },
    { { 9, 0 }, { 0, 0 }, "variesBy", sp_variesby, t_schema, sch_text },
    { { 9, 0 }, { 0, 0 }, "variesBy", sp_variesby, t_text },
    { { 2, 0 }, { 0, 0 }, "vatID", sp_vatid, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "vatID", sp_vatid, t_text },
    { { 2, 0 }, { 0, 0 }, "vehicleConfiguration", sp_vehicleconfiguration, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "vehicleConfiguration", sp_vehicleconfiguration, t_text },
    { { 2, 0 }, { 0, 0 }, "vehicleEngine", sp_vehicleengine, t_schema, sch_enginespecification },
    { { 2, 0 }, { 0, 0 }, "vehicleIdentificationNumber", sp_vehicleidentificationnumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "vehicleIdentificationNumber", sp_vehicleidentificationnumber, t_text },
    { { 2, 0 }, { 0, 0 }, "vehicleInteriorColor", sp_vehicleinteriorcolour, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "vehicleInteriorColor", sp_vehicleinteriorcolour, t_text },
    { { 2, 0 }, { 0, 0 }, "vehicleInteriorType", sp_vehicleinteriortype, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "vehicleInteriorType", sp_vehicleinteriortype, t_text },
    { { 2, 0 }, { 0, 0 }, "vehicleModelDate", sp_vehiclemodeldate, t_schema, sch_date },
    { { 2, 0 }, { 0, 0 }, "vehicleModelDate", sp_vehiclemodeldate, t_just_date },
    { { 2, 0 }, { 0, 0 }, "vehicleSeatingCapacity", sp_vehicleseatingcapacity, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "vehicleSeatingCapacity", sp_vehicleseatingcapacity, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "vehicleSeatingCapacity", sp_vehicleseatingcapacity, t_schema, sch_quantitativevalue },
    { { 3, 5 }, { 0, 0 }, "vehicleSpecialUsage", sp_vehiclespecialusage, t_schema, sch_carusagetype },
    { { 3, 0 }, { 0, 0 }, "vehicleSpecialUsage", sp_vehiclespecialusage, t_schema, sch_text },
    { { 3, 0 }, { 0, 0 }, "vehicleSpecialUsage", sp_vehiclespecialusage, t_text },
    { { 2, 0 }, { 0, 0 }, "vehicleTransmission", sp_vehicletransmission, t_schema, sch_qualitativevalue },
    { { 2, 0 }, { 0, 0 }, "vehicleTransmission", sp_vehicletransmission, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "vehicleTransmission", sp_vehicletransmission, t_text },
    { { 2, 0 }, { 0, 0 }, "vehicleTransmission", sp_vehicletransmission, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "vehicleTransmission", sp_vehicletransmission, t_url },
    { { 3, 5 }, { 0, 0 }, "verificationFactCheckingPolicy", sp_verificationfactcheckingpolicy, t_schema, sch_creativework },
    { { 3, 5 }, { 0, 0 }, "verificationFactCheckingPolicy", sp_verificationfactcheckingpolicy, t_schema, sch_url },
    { { 3, 5 }, { 0, 0 }, "verificationFactCheckingPolicy", sp_verificationfactcheckingpolicy, t_url },
    { { 2, 0 }, { 0, 0 }, "version", sp_version, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "version", sp_version, t_fixedpoint },
    { { 3, 1 }, { 0, 0 }, "version", sp_version, t_schema, sch_text },
    { { 3, 1 }, { 0, 0 }, "version", sp_version, t_text },
    { { 3, 5 }, { 0, 0 }, "video", sp_video, t_schema, sch_clip },
    { { 2, 0 }, { 0, 0 }, "video", sp_video, t_schema, sch_videoobject },
    { { 2, 0 }, { 0, 0 }, "videoFormat", sp_videoformat, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "videoFormat", sp_videoformat, t_text },
    { { 2, 0 }, { 0, 0 }, "videoFrameSize", sp_videoframesize, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "videoFrameSize", sp_videoframesize, t_text },
    { { 2, 0 }, { 0, 0 }, "videoQuality", sp_videoquality, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "videoQuality", sp_videoquality, t_text },
    { { 2, 0 }, { 0, 0 }, "volumeNumber", sp_volumenumber, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "volumeNumber", sp_volumenumber, t_integer },
    { { 2, 0 }, { 0, 0 }, "volumeNumber", sp_volumenumber, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "volumeNumber", sp_volumenumber, t_text },
    { { 2, 0 }, { 0, 0 }, "warning", sp_warning, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "warning", sp_warning, t_text },
    { { 2, 0 }, { 0, 0 }, "warning", sp_warning, t_schema, sch_url },
    { { 2, 0 }, { 0, 0 }, "warning", sp_warning, t_url },
    { { 2, 0 }, { 0, 0 }, "warranty", sp_warranty, t_schema, sch_warrantypromise },
    { { 2, 0 }, { 0, 0 }, "warrantyScope", sp_warrantyscope, t_schema, sch_warrantyscope },
    { { 2, 0 }, { 0, 0 }, "webCheckInTime", sp_webcheckintime, t_schema, sch_datetime },
    { { 2, 0 }, { 0, 0 }, "webCheckInTime", sp_webcheckintime, t_datetime },
    { { 7, 1 }, { 0, 0 }, "webFeed", sp_webfeed, t_schema, sch_datafeed },
    { { 4, 0 }, { 0, 0 }, "webFeed", sp_webfeed, t_schema, sch_url },
    { { 4, 0 }, { 0, 0 }, "webFeed", sp_webfeed, t_url },
    { { 2, 0 }, { 0, 0 }, "weight", sp_weight, t_schema, sch_quantitativevalue },
    { { 3, 5 }, { 0, 0 }, "weightTotal", sp_weighttotal, t_schema, sch_quantitativevalue },
    { { 3, 5 }, { 0, 0 }, "wheelbase", sp_wheelbase, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "width", sp_width, t_schema, sch_distance },
    { { 2, 0 }, { 0, 0 }, "width", sp_width, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "winner", sp_winner, t_schema, sch_person },
    { { 2, 0 }, { 0, 0 }, "wordCount", sp_wordcount, t_schema, sch_integer },
    { { 2, 0 }, { 0, 0 }, "wordCount", sp_wordcount, t_integer },
    { { 2, 0 }, { 0, 0 }, "workExample", sp_workexample, t_schema, sch_creativework },
    { { 2, 2 }, { 0, 0 }, "workFeatured", sp_workfeatured, t_schema, sch_creativework },
    { { 2, 0 }, { 0, 0 }, "workHours", sp_workhours, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "workHours", sp_workhours, t_text },
    { { 2, 0 }, { 0, 0 }, "workLocation", sp_worklocation, t_schema, sch_contactpoint },
    { { 2, 0 }, { 0, 0 }, "workLocation", sp_worklocation, t_schema, sch_place },
    { { 2, 0 }, { 0, 0 }, "workPerformed", sp_workperformed, t_schema, sch_creativework },
    { { 2, 0 }, { 0, 0 }, "workPresented", sp_workpresented, t_schema, sch_movie },
    { { 3, 5 }, { 0, 0 }, "workTranslation", sp_worktranslation, t_schema, sch_creativework },
    { { 2, 0 }, { 0, 0 }, "workload", sp_workload, t_schema, sch_energy },
    { { 3, 5 }, { 0, 0 }, "workload", sp_workload, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "worksFor", sp_worksfor, t_schema, sch_organisation },
    { { 2, 0 }, { 0, 0 }, "worstRating", sp_worstrating, t_schema, sch_number },
    { { 2, 0 }, { 0, 0 }, "worstRating", sp_worstrating, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "worstRating", sp_worstrating, t_schema, sch_text },
    { { 2, 0 }, { 0, 0 }, "worstRating", sp_worstrating, t_text },
    { { 3, 5 }, { 0, 0 }, "xpath", sp_xpath, t_schema, sch_xpathtype },
    { { 6, 0 }, { 0, 0 }, "yearBuilt", sp_yearbuilt, t_schema, sch_number },
    { { 6, 0 }, { 0, 0 }, "yearBuilt", sp_yearbuilt, t_fixedpoint },
    { { 2, 0 }, { 0, 0 }, "yearlyRevenue", sp_yearlyrevenue, t_schema, sch_quantitativevalue },
    { { 2, 0 }, { 0, 0 }, "yearsInOperation", sp_yearsinoperation, t_schema, sch_quantitativevalue },
    { { 3, 3 }, { 0, 0 }, "yield", sp_yield, t_schema, sch_quantitativevalue },
    { { 3, 4 }, { 0, 0 }, "yield", sp_yield, t_schema, sch_text },
    { { 3, 4 }, { 0, 0 }, "yield", sp_yield, t_text },

    { { 0, 0 }, { 0, 0 }, nullptr, sp_illegal } };

typedef ::std::vector < e_schema > c;
typedef ::std::multimap < ::std::string, property_gen* > mdp_t;
typedef ::std::multimap < e_schema_property, property_gen* > mpp_t;
mdp_t propermap;
mpp_t mpp;

void schema_property_init (nitpick& )
{   assert (propermap.empty ());
    for (property_gen* p = &gentab [0]; p -> prop_ != sp_illegal; ++p)
    {   if (p -> name_ != nullptr) propermap.insert (mdp_t::value_type (::boost::to_lower_copy (::std::string (p -> name_)), p));
        mpp.insert (mpp_t::value_type (p -> prop_, p)); } }

e_schema_property identify_schema_property (nitpick& nits, const schema_version& sv, const ::std::string& name)
{   ::std::string test_name (::boost::to_lower_copy (name));
    mdp_t::const_iterator i = propermap.find (test_name);
    if ((i == propermap.cend ()) && (name.length () > 20))
       if (type_master < t_microdata_domain > :: starts_with (test_name) == mdd_schema)
       {    ::std::string::size_type st = (name.at (5) == 's') ? HTTPS_SCHEMA_ORG : HTTP_SCHEMA_ORG;
            test_name = test_name.substr (st);
            i = propermap.find (test_name); }
    if (i != propermap.cend ()) return i -> second -> prop_;
    nits.pick (nit_not_schema_property, es_error, ec_microdata, quote (test_name), " is not a schema ", sv.report (), " property");
    return sp_illegal; }

bool check_schema_property_version (const schema_version& from, const schema_version& to, const e_schema_property prop, bool& found)
{   for (mpp_t::const_iterator i = mpp.find (prop); (i != mpp.cend ()) && (i -> first == prop); ++i)
    {   found = true;
        if (does_apply (from, i -> second -> from_, i -> second -> to_) &&
            does_apply (to, i -> second -> from_, i -> second -> to_)) return true; }
    return false; }

::std::string schema_property_name (const e_schema_property prop)
{   mpp_t::const_iterator i = mpp.find (prop);
    if ((i == mpp.cend ()) || (i -> second == nullptr) || (i -> second -> name_ == nullptr)) return ::std::string ();
    return i -> second -> name_; }

bool test_enumerated_type (nitpick& nits, const html_version& v, const bool ex, const ::std::string& value)
{   if (value.empty ()) return false;
    if (ex && type_master < t_microdata_domain > :: starts_with (value) == mdd_purl) return true;
    ::std::string test_value (value);
    if (test_value.find (':') == ::std::string::npos)
        test_value = ::std::string ("https://schema.org/") + value;
    type_master < t_itemtype > tm;
    tm.set_value (nits, v, test_value);
    return (tm.good ()); }

bool is_valid_schema_property_int (nitpick& nits, const html_version& v, const e_schema schema, const e_schema_property prop, const ::std::string& value, const bool is_link)
{   nitpick knots;
    schema_version sv (context.schema_ver ());
    ::std::string expected, unfound;
    bool many = false, valid_type = false;
    ssch_t ssch (generalise (context.schema_ver (), schema));
    for (e_schema gen : ssch)
    {   if (is_schema_property (gen, prop))
            for (mpp_t::const_iterator i = mpp.find (prop); (i != mpp.cend ()) && (i -> first == prop); ++i)
                if (i -> second -> field_type_ == t_schema)
                {   if ((i -> second -> flags_ & SP_VALUE_TYPENAME) == SP_VALUE_TYPENAME)
                        if (test_enumerated_type (knots, v, false, value))
                        {   itemtype_index ii = find_itemtype_index (knots, v, value);
                            if (ii == make_itemtype_index (i -> second -> field_schema_)) return true;
                                if (type_category (ii) == itemtype_schema)
                                    if (is_specific_type_of (context.schema_ver (), i -> second -> field_schema_, static_cast < e_schema > (ii & uint32_item_mask)))
                                        return true; }
                    uint64_t flags = sch :: flags (i -> second -> field_schema_);
                    bool en = enumerated_schema_type (flags);
                    bool ex = external_enumerated_schema_type (flags);
                    if (ex || en) if (test_enumerated_type (knots, v, ex, value)) return true;
                    if (is_link)
                    {   nitpick ohsnoes;
                        url u (ohsnoes, v, value);
                        if (! u.invalid ())
                        {   if (! u.is_local () || u.has_args () || u.has_query () || u.empty ()) { nits.merge (ohsnoes); return true; }
                            if (! u.is_http () && ! u.is_https ()) { nits.merge (ohsnoes); return true; }
                            if (u.has_id () && (u.has_path () || u.has_file ())) { nits.merge (ohsnoes); return true; } } }
                    if (has_simple_schema_type (flags))
                    {   nitpick nuts;
                        if (test_value (nuts, v, get_simple_schema_type (flags), value))
                        {   nits.merge (nuts);
                            return true; }
                        valid_type = true;
                        knots.merge (nuts); }
                    else
                    {   if (! expected.empty ()) { many = true; expected += ", "; }
                        expected += quote ("https://schema.org/" + sch :: name (i -> second -> field_schema_)); } }
                else if (does_apply (sv, i -> second -> from_, i -> second -> to_))
                {   nitpick nuts;
                    if (test_value (nuts, v, i -> second -> field_type_, value))
                    {   nits.merge (nuts);
                        return true; }
                    valid_type = true;
                    knots.merge (nuts); }
        if (! expected.empty ())
        {   ::std::string msg ("consider specifying ");
            nitpick nuts;
            msg += quote (schema_property_name (prop)) + " in greater detail using ";
            if (many) msg += "one of ";
            msg += expected;
            nuts.pick (nit_schema_property, es_comment, ec_microdata, msg);
            if (test_value (nuts, v, t_text, value))
            {   nits.merge (nuts);
                return true; }
            valid_type = true;
            knots.merge (nuts); }
        if (unfound.empty ())
            unfound = quote (schema_property_name (prop)) + " is not a valid property of " + quote (sch::name (gen)); }
    if (! unfound.empty () && ! valid_type)
        knots.pick (nit_not_schema_property, es_error, ec_microdata, unfound);
    nits.merge (knots);
    return false; }

bool is_valid_schema_property (nitpick& nits, const html_version& v, const e_schema schema, const e_schema_property prop, const ::std::string& value, const bool is_link)
{   if (! is_valid_schema_property_int (nits, v, schema, prop, value, is_link)) return false;
//    context.mark (schema, prop);
    return true; }

bool is_valid_schema_property_int (nitpick& nits, const html_version& , const e_schema schema, const e_schema_property prop, const e_schema value)
{   nitpick knots;
    ssch_t ssch (generalise (context.schema_ver (), schema));
    for (e_schema gen : ssch)
    {   if (is_schema_property (gen, prop))
            for (mpp_t::const_iterator i = mpp.find (prop); (i != mpp.cend ()) && (i -> first == prop); ++i)
                if (i -> second -> field_type_ == t_schema)
                    if (i -> second -> field_schema_ == value)
                        if (does_apply (context.schema_ver (), i -> second -> from_, i -> second -> to_))
                            return true;
        knots.pick (nit_not_schema_property, es_error, ec_microdata, quote (schema_property_name (prop)), " is not a property of ", quote (sch::name (gen))); }
    nits.merge (knots);
    return false; }

bool is_valid_schema_property (nitpick& nits, const html_version& v, const e_schema schema, const e_schema_property prop, const e_schema value)
{   if (! is_valid_schema_property_int (nits, v, schema, prop, value)) return false;
//    context.mark (schema, prop);
    return true; }

vit_t sought_schema_itemtypes (const e_schema_property prop)
{   vit_t res;
    for (mpp_t::const_iterator i = mpp.find (prop); (i != mpp.cend ()) && (i -> first == prop); ++i)
        if (i -> second -> field_type_ == t_schema)
            if (does_apply (context.schema_ver (), i -> second -> from_, i -> second -> to_))
                res.push_back (make_itemtype_index (i -> second -> field_schema_));
    return res; }
