/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "standard.h"
#include "type_currency.h"

struct symbol_entry < e_currency > currency_symbol_table [] =
{   { { HTML_UNDEF }, { HTML_UNDEF }, "AED", e_iso_AED },
    { { HTML_UNDEF }, { HTML_UNDEF }, "AFN", e_iso_AFN },
    { { HTML_UNDEF }, { HTML_UNDEF }, "ALL", e_iso_ALL },
    { { HTML_UNDEF }, { HTML_UNDEF }, "AMD", e_iso_AMD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "ANG", e_iso_ANG },
    { { HTML_UNDEF }, { HTML_UNDEF }, "AOA", e_iso_AOA },
    { { HTML_UNDEF }, { HTML_UNDEF }, "ARS", e_iso_ARS },
    { { HTML_UNDEF }, { HTML_UNDEF }, "AUD", e_iso_AUD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "AWG", e_iso_AWG },
    { { HTML_UNDEF }, { HTML_UNDEF }, "AZN", e_iso_AZN },
    { { HTML_UNDEF }, { HTML_UNDEF }, "BAM", e_iso_BAM },
    { { HTML_UNDEF }, { HTML_UNDEF }, "BBD", e_iso_BBD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "BDT", e_iso_BDT },
    { { HTML_UNDEF }, { HTML_UNDEF }, "BGN", e_iso_BGN },
    { { HTML_UNDEF }, { HTML_UNDEF }, "BHD", e_iso_BHD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "BIF", e_iso_BIF },
    { { HTML_UNDEF }, { HTML_UNDEF }, "BMD", e_iso_BMD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "BND", e_iso_BND },
    { { HTML_UNDEF }, { HTML_UNDEF }, "BOB", e_iso_BOB },
    { { HTML_UNDEF }, { HTML_UNDEF }, "BOV", e_iso_BOV },
    { { HTML_UNDEF }, { HTML_UNDEF }, "BRL", e_iso_BRL },
    { { HTML_UNDEF }, { HTML_UNDEF }, "BSD", e_iso_BSD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "BTN", e_iso_BTN },
    { { HTML_UNDEF }, { HTML_UNDEF }, "BWP", e_iso_BWP },
    { { HTML_UNDEF }, { HTML_UNDEF }, "BYN", e_iso_BYN },
    { { HTML_UNDEF }, { HTML_UNDEF }, "BZD", e_iso_BZD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "CAD", e_iso_CAD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "CDF", e_iso_CDF },
    { { HTML_UNDEF }, { HTML_UNDEF }, "CHE", e_iso_CHE },
    { { HTML_UNDEF }, { HTML_UNDEF }, "CHF", e_iso_CHF },
    { { HTML_UNDEF }, { HTML_UNDEF }, "CHW", e_iso_CHW },
    { { HTML_UNDEF }, { HTML_UNDEF }, "CLF", e_iso_CLF },
    { { HTML_UNDEF }, { HTML_UNDEF }, "CLP", e_iso_CLP },
    { { HTML_UNDEF }, { HTML_UNDEF }, "CNY", e_iso_CNY },
    { { HTML_UNDEF }, { HTML_UNDEF }, "COP", e_iso_COP },
    { { HTML_UNDEF }, { HTML_UNDEF }, "COU", e_iso_COU },
    { { HTML_UNDEF }, { HTML_UNDEF }, "CRC", e_iso_CRC },
    { { HTML_UNDEF }, { HTML_UNDEF }, "CUC", e_iso_CUC },
    { { HTML_UNDEF }, { HTML_UNDEF }, "CUP", e_iso_CUP },
    { { HTML_UNDEF }, { HTML_UNDEF }, "CVE", e_iso_CVE },
    { { HTML_UNDEF }, { HTML_UNDEF }, "CZK", e_iso_CZK },
    { { HTML_UNDEF }, { HTML_UNDEF }, "DJF", e_iso_DJF },
    { { HTML_UNDEF }, { HTML_UNDEF }, "DKK", e_iso_DKK },
    { { HTML_UNDEF }, { HTML_UNDEF }, "DOP", e_iso_DOP },
    { { HTML_UNDEF }, { HTML_UNDEF }, "DZD", e_iso_DZD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "EGP", e_iso_EGP },
    { { HTML_UNDEF }, { HTML_UNDEF }, "ERN", e_iso_ERN },
    { { HTML_UNDEF }, { HTML_UNDEF }, "ETB", e_iso_ETB },
    { { HTML_UNDEF }, { HTML_UNDEF }, "EUR", e_iso_EUR },
    { { HTML_UNDEF }, { HTML_UNDEF }, "FJD", e_iso_FJD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "FKP", e_iso_FKP },
    { { HTML_UNDEF }, { HTML_UNDEF }, "GBP", e_iso_GBP },
    { { HTML_UNDEF }, { HTML_UNDEF }, "GEL", e_iso_GEL },
    { { HTML_UNDEF }, { HTML_UNDEF }, "GHS", e_iso_GHS },
    { { HTML_UNDEF }, { HTML_UNDEF }, "GIP", e_iso_GIP },
    { { HTML_UNDEF }, { HTML_UNDEF }, "GMD", e_iso_GMD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "GNF", e_iso_GNF },
    { { HTML_UNDEF }, { HTML_UNDEF }, "GTQ", e_iso_GTQ },
    { { HTML_UNDEF }, { HTML_UNDEF }, "GYD", e_iso_GYD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "HKD", e_iso_HKD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "HNL", e_iso_HNL },
    { { HTML_UNDEF }, { HTML_UNDEF }, "HRK", e_iso_HRK },
    { { HTML_UNDEF }, { HTML_UNDEF }, "HTG", e_iso_HTG },
    { { HTML_UNDEF }, { HTML_UNDEF }, "HUF", e_iso_HUF },
    { { HTML_UNDEF }, { HTML_UNDEF }, "IDR", e_iso_IDR },
    { { HTML_UNDEF }, { HTML_UNDEF }, "ILS", e_iso_ILS },
    { { HTML_UNDEF }, { HTML_UNDEF }, "INR", e_iso_INR },
    { { HTML_UNDEF }, { HTML_UNDEF }, "IQD", e_iso_IQD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "IRR", e_iso_IRR },
    { { HTML_UNDEF }, { HTML_UNDEF }, "ISK", e_iso_ISK },
    { { HTML_UNDEF }, { HTML_UNDEF }, "JMD", e_iso_JMD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "JOD", e_iso_JOD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "JPY", e_iso_JPY },
    { { HTML_UNDEF }, { HTML_UNDEF }, "KES", e_iso_KES },
    { { HTML_UNDEF }, { HTML_UNDEF }, "KGS", e_iso_KGS },
    { { HTML_UNDEF }, { HTML_UNDEF }, "KHR", e_iso_KHR },
    { { HTML_UNDEF }, { HTML_UNDEF }, "KMF", e_iso_KMF },
    { { HTML_UNDEF }, { HTML_UNDEF }, "KPW", e_iso_KPW },
    { { HTML_UNDEF }, { HTML_UNDEF }, "KRW", e_iso_KRW },
    { { HTML_UNDEF }, { HTML_UNDEF }, "KWD", e_iso_KWD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "KYD", e_iso_KYD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "KZT", e_iso_KZT },
    { { HTML_UNDEF }, { HTML_UNDEF }, "LAK", e_iso_LAK },
    { { HTML_UNDEF }, { HTML_UNDEF }, "LBP", e_iso_LBP },
    { { HTML_UNDEF }, { HTML_UNDEF }, "LKR", e_iso_LKR },
    { { HTML_UNDEF }, { HTML_UNDEF }, "LRD", e_iso_LRD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "LSL", e_iso_LSL },
    { { HTML_UNDEF }, { HTML_UNDEF }, "LYD", e_iso_LYD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "MAD", e_iso_MAD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "MDL", e_iso_MDL },
    { { HTML_UNDEF }, { HTML_UNDEF }, "MGA", e_iso_MGA },
    { { HTML_UNDEF }, { HTML_UNDEF }, "MKD", e_iso_MKD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "MMK", e_iso_MMK },
    { { HTML_UNDEF }, { HTML_UNDEF }, "MNT", e_iso_MNT },
    { { HTML_UNDEF }, { HTML_UNDEF }, "MOP", e_iso_MOP },
    { { HTML_UNDEF }, { HTML_UNDEF }, "MRU", e_iso_MRU },
    { { HTML_UNDEF }, { HTML_UNDEF }, "MUR", e_iso_MUR },
    { { HTML_UNDEF }, { HTML_UNDEF }, "MVR", e_iso_MVR },
    { { HTML_UNDEF }, { HTML_UNDEF }, "MWK", e_iso_MWK },
    { { HTML_UNDEF }, { HTML_UNDEF }, "MXN", e_iso_MXN },
    { { HTML_UNDEF }, { HTML_UNDEF }, "MXV", e_iso_MXV },
    { { HTML_UNDEF }, { HTML_UNDEF }, "MYR", e_iso_MYR },
    { { HTML_UNDEF }, { HTML_UNDEF }, "MZN", e_iso_MZN },
    { { HTML_UNDEF }, { HTML_UNDEF }, "NAD", e_iso_NAD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "NGN", e_iso_NGN },
    { { HTML_UNDEF }, { HTML_UNDEF }, "NIO", e_iso_NIO },
    { { HTML_UNDEF }, { HTML_UNDEF }, "NOK", e_iso_NOK },
    { { HTML_UNDEF }, { HTML_UNDEF }, "NPR", e_iso_NPR },
    { { HTML_UNDEF }, { HTML_UNDEF }, "NZD", e_iso_NZD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "OMR", e_iso_OMR },
    { { HTML_UNDEF }, { HTML_UNDEF }, "PAB", e_iso_PAB },
    { { HTML_UNDEF }, { HTML_UNDEF }, "PEN", e_iso_PEN },
    { { HTML_UNDEF }, { HTML_UNDEF }, "PGK", e_iso_PGK },
    { { HTML_UNDEF }, { HTML_UNDEF }, "PHP", e_iso_PHP },
    { { HTML_UNDEF }, { HTML_UNDEF }, "PKR", e_iso_PKR },
    { { HTML_UNDEF }, { HTML_UNDEF }, "PLN", e_iso_PLN },
    { { HTML_UNDEF }, { HTML_UNDEF }, "PYG", e_iso_PYG },
    { { HTML_UNDEF }, { HTML_UNDEF }, "QAR", e_iso_QAR },
    { { HTML_UNDEF }, { HTML_UNDEF }, "RON", e_iso_RON },
    { { HTML_UNDEF }, { HTML_UNDEF }, "RSD", e_iso_RSD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "RUB", e_iso_RUB },
    { { HTML_UNDEF }, { HTML_UNDEF }, "RWF", e_iso_RWF },
    { { HTML_UNDEF }, { HTML_UNDEF }, "SAR", e_iso_SAR },
    { { HTML_UNDEF }, { HTML_UNDEF }, "SBD", e_iso_SBD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "SCR", e_iso_SCR },
    { { HTML_UNDEF }, { HTML_UNDEF }, "SDG", e_iso_SDG },
    { { HTML_UNDEF }, { HTML_UNDEF }, "SEK", e_iso_SEK },
    { { HTML_UNDEF }, { HTML_UNDEF }, "SGD", e_iso_SGD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "SHP", e_iso_SHP },
    { { HTML_UNDEF }, { HTML_UNDEF }, "SLL", e_iso_SLL },
    { { HTML_UNDEF }, { HTML_UNDEF }, "SOS", e_iso_SOS },
    { { HTML_UNDEF }, { HTML_UNDEF }, "SRD", e_iso_SRD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "SSP", e_iso_SSP },
    { { HTML_UNDEF }, { HTML_UNDEF }, "STN", e_iso_STN },
    { { HTML_UNDEF }, { HTML_UNDEF }, "SVC", e_iso_SVC },
    { { HTML_UNDEF }, { HTML_UNDEF }, "SYP", e_iso_SYP },
    { { HTML_UNDEF }, { HTML_UNDEF }, "SZL", e_iso_SZL },
    { { HTML_UNDEF }, { HTML_UNDEF }, "THB", e_iso_THB },
    { { HTML_UNDEF }, { HTML_UNDEF }, "TJS", e_iso_TJS },
    { { HTML_UNDEF }, { HTML_UNDEF }, "TMT", e_iso_TMT },
    { { HTML_UNDEF }, { HTML_UNDEF }, "TND", e_iso_TND },
    { { HTML_UNDEF }, { HTML_UNDEF }, "TOP", e_iso_TOP },
    { { HTML_UNDEF }, { HTML_UNDEF }, "TRY", e_iso_TRY },
    { { HTML_UNDEF }, { HTML_UNDEF }, "TTD", e_iso_TTD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "TWD", e_iso_TWD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "TZS", e_iso_TZS },
    { { HTML_UNDEF }, { HTML_UNDEF }, "UAH", e_iso_UAH },
    { { HTML_UNDEF }, { HTML_UNDEF }, "UGX", e_iso_UGX },
    { { HTML_UNDEF }, { HTML_UNDEF }, "USD", e_iso_USD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "USN", e_iso_USN },
    { { HTML_UNDEF }, { HTML_UNDEF }, "UYI", e_iso_UYI },
    { { HTML_UNDEF }, { HTML_UNDEF }, "UYU", e_iso_UYU },
    { { HTML_UNDEF }, { HTML_UNDEF }, "UYW", e_iso_UYW },
    { { HTML_UNDEF }, { HTML_UNDEF }, "UZS", e_iso_UZS },
    { { HTML_UNDEF }, { HTML_UNDEF }, "VES", e_iso_VES },
    { { HTML_UNDEF }, { HTML_UNDEF }, "VND", e_iso_VND },
    { { HTML_UNDEF }, { HTML_UNDEF }, "VUV", e_iso_VUV },
    { { HTML_UNDEF }, { HTML_UNDEF }, "WST", e_iso_WST },
    { { HTML_UNDEF }, { HTML_UNDEF }, "XAF", e_iso_XAF },
    { { HTML_UNDEF }, { HTML_UNDEF }, "XAG", e_iso_XAG },
    { { HTML_UNDEF }, { HTML_UNDEF }, "XAU", e_iso_XAU },
    { { HTML_UNDEF }, { HTML_UNDEF }, "XBA", e_iso_XBA },
    { { HTML_UNDEF }, { HTML_UNDEF }, "XBB", e_iso_XBB },
    { { HTML_UNDEF }, { HTML_UNDEF }, "XBC", e_iso_XBC },
    { { HTML_UNDEF }, { HTML_UNDEF }, "XBD", e_iso_XBD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "XCD", e_iso_XCD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "XDR", e_iso_XDR },
    { { HTML_UNDEF }, { HTML_UNDEF }, "XOF", e_iso_XOF },
    { { HTML_UNDEF }, { HTML_UNDEF }, "XPD", e_iso_XPD },
    { { HTML_UNDEF }, { HTML_UNDEF }, "XPF", e_iso_XPF },
    { { HTML_UNDEF }, { HTML_UNDEF }, "XPT", e_iso_XPT },
    { { HTML_UNDEF }, { HTML_UNDEF }, "XSU", e_iso_XSU },
    { { HTML_UNDEF }, { HTML_UNDEF }, "XTS", e_iso_XTS },
    { { HTML_UNDEF }, { HTML_UNDEF }, "XUA", e_iso_XUA },
    { { HTML_UNDEF }, { HTML_UNDEF }, "XXX", e_iso_XXX },
    { { HTML_UNDEF }, { HTML_UNDEF }, "YER", e_iso_YER },
    { { HTML_UNDEF }, { HTML_UNDEF }, "ZAR", e_iso_ZAR },
    { { HTML_UNDEF }, { HTML_UNDEF }, "ZMW", e_iso_ZMW },
    { { HTML_UNDEF }, { HTML_UNDEF }, "ZWL", e_iso_ZWL } };

void currency_init (nitpick& nits)
{   type_master < t_currency > :: init (nits, currency_symbol_table, sizeof (currency_symbol_table) / sizeof (symbol_entry < e_currency >)); }
