/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once
#include "type_master.h"

bool parse_media_query (nitpick& nits, const html_version& v, const ::std::string& s);

template < > struct type_master < t_mql > : tidy_string < t_mql >
{   void set_value (nitpick& nits, const html_version& v, const ::std::string& s)
    {   tidy_string < t_mql > :: set_value (nits, v, s);
        if (tidy_string < t_mql > :: empty ())
            nits.pick (nit_mq_syntax, ed_mql, "3. Syntax", es_warning, ec_mql, "is the empty media value intentional?");
        else if (tidy_string < t_mql > :: good () && parse_media_query (nits, v, tidy_string < t_mql > :: get_string ())) return;
        tidy_string < t_mql > :: status (s_invalid);
        return; } };

