/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "standard.h"
#include "type_rel.h"
#include "reldef.h"

struct symbol_entry < e_rel > rel_symbol_table [] =
{   { { HTML_4_0 }, { HTML_UNDEF }, R_ABOUT, r_about },
    { { HTML_4_0 }, { HTML_UNDEF }, R_ACCESSIBILITY, r_accessibility },
    { { HTML_4_0 }, { HTML_UNDEF }, R_ACQUAINTANCE, r_acquaintance },
    { { HTML_4_0, HR_5 }, { HTML_UNDEF }, R_ALTERNATIVE, r_alternative },
    { { HTML_4_0 }, { HTML_UNDEF }, R_AMPHTML, r_amphtml },
    { { HTML_4_0 }, { HTML_UNDEF }, R_APPENDIX, r_appendix },
    { { HTML_4_0, HR_54_LINKHEAD | HR_54_EXTERNAL }, { HTML_UNDEF }, R_APPLE_TOUCH_ICON, r_apple_touch_icon },
    { { HTML_4_0 }, { HTML_UNDEF }, R_APPLE_TOUCH_ICON_PRECOMPOSED, r_apple_touch_icon_precomposed },
    { { HTML_4_0 }, { HTML_UNDEF }, R_APPLE_TOUCH_STARTUP_IMAGE, r_apple_touch_startup_image },
    { { HTML_4_0 }, { HTML_UNDEF }, R_ARCHIVED, r_archived },
    { { HTML_4_0 }, { HTML_UNDEF }, R_ARCHIVES, r_archives },
    { { HTML_4_0 }, { HTML_UNDEF }, R_ATTACHMENT, r_attachment },
    { { HTML_4_0, HR_5 }, { HTML_UNDEF }, R_AUTHOR, r_author },
    { { HTML_4_0 }, { HTML_UNDEF }, R_AUTHORISATION_ENDPOINT, r_authorisation_endpoint },
    { { HTML_3_0 }, { HTML_UNDEF }, R_BANNER, r_banner },
    { { HTML_4_0 }, { HTML_UNDEF }, R_BEGIN, r_begin },
    { { HTML_4_0 }, { HTML_UNDEF }, R_BIBLIOENTRY, r_biblioentry },
    { { HTML_4_0 }, { HTML_UNDEF }, R_BIBLIOGRAPHY, r_bibliography },
    { { HTML_4_0 }, { HTML_UNDEF }, R_BLOCKED_BY, r_blocked_by },
    { { HTML_PLUS, HR_A_AREA }, { HTML_UNDEF }, R_BOOKMARK, r_bookmark },
    { { HTML_4_0, HR_53_A_AREA | HR_54_LINKHEAD }, { HTML_UNDEF }, R_CANONICAL, r_canonical },
    { { HTML_4_0 }, { HTML_UNDEF }, R_CATEGORY, r_category },
    { { HTML_4_0 }, { HTML_UNDEF }, R_CHAPTER, r_chapter },
    { { HTML_4_0 }, { HTML_UNDEF }, R_CHILD, r_child },
    { { HTML_4_0 }, { HTML_UNDEF }, R_CHROME_WEBSTORE_ITEM, r_chrome_webstore_item },
    { { HTML_4_0 }, { HTML_UNDEF }, R_CITATION, r_citation },
    { { HTML_4_0 }, { HTML_UNDEF }, R_CITE, r_cite },
    { { HTML_4_0 }, { HTML_UNDEF }, R_CITE_AS, r_cite_as },
    { { HTML_4_0 }, { HTML_UNDEF }, R_CMIS, r_docs_oasis_open_org_ns_cmis_link_200908_acl },
    { { HTML_4_0 }, { HTML_UNDEF }, R_CODE_LICENCE, r_code_licence },
    { { HTML_4_0 }, { HTML_UNDEF }, R_CODE_REPOSITORY, r_code_repository },
    { { HTML_4_0 }, { HTML_UNDEF }, R_COLLEAGUE, r_colleague },
    { { HTML_4_0 }, { HTML_UNDEF }, R_COLLECTION, r_collection },
    { { HTML_4_0 }, { HTML_UNDEF }, R_COMMENT, r_comment },
    { { HTML_4_0 }, { HTML_UNDEF }, R_COMPONENT, r_component },
    { { HTML_4_0 }, { HTML_UNDEF }, R_CONTACT, r_contact },
    { { HTML_PLUS }, { HTML_UNDEF }, R_CONTENTS, r_contents },
    { { HTML_4_0 }, { HTML_UNDEF }, R_CONTENT_LICENCE, r_content_licence },
    { { HTML_4_0 }, { HTML_UNDEF }, R_CONTENT_REPOSITORY, r_content_repository },
    { { HTML_4_0 }, { HTML_UNDEF }, R_CONTRIBUTION, r_contribution },
    { { HTML_4_0 }, { HTML_UNDEF }, R_CONVERTED_FROM, r_convertedfrom },
    { { HTML_3_0 }, { HTML_UNDEF }, R_COPYRIGHT, r_copyright },
    { { HTML_4_0 }, { HTML_UNDEF }, R_CORESIDENT, r_coresident },
    { { HTML_4_0 }, { HTML_UNDEF }, R_COWORKER, r_coworker },
    { { HTML_4_0 }, { HTML_UNDEF }, R_CREATE_FORM, r_create_form },
    { { HTML_4_0 }, { HTML_UNDEF }, R_CRUSH, r_crush },
    { { HTML_4_0 }, { HTML_UNDEF }, R_CURRENT, r_current },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DATE, r_date },

    { { HTML_4_0 }, { HTML_UNDEF }, "dc.contributor", r_dc_contributor },
    { { HTML_4_0 }, { HTML_UNDEF }, "dc.coverage", r_dc_coverage },
    { { HTML_4_0 }, { HTML_UNDEF }, "dc.creator", r_dc_creator },
    { { HTML_4_0 }, { HTML_UNDEF }, "dc.date", r_dc_date },
    { { HTML_4_0 }, { HTML_UNDEF }, "dc.description", r_dc_description },
    { { HTML_4_0 }, { HTML_UNDEF }, "dc.format", r_dc_format },
    { { HTML_4_0 }, { HTML_UNDEF }, "dc.identifier", r_dc_identifier },
    { { HTML_4_0 }, { HTML_UNDEF }, "dc.language", r_dc_language },
    { { HTML_4_0 }, { HTML_UNDEF }, "dc.publisher", r_dc_publisher },
    { { HTML_4_0 }, { HTML_UNDEF }, "dc.relation", r_dc_relation },
    { { HTML_4_0 }, { HTML_UNDEF }, "dc.right", r_dc_rights },
    { { HTML_4_0 }, { HTML_UNDEF }, "dc.source", r_dc_source },
    { { HTML_4_0 }, { HTML_UNDEF }, "dc.subject", r_dc_subject },
    { { HTML_4_0 }, { HTML_UNDEF }, "dc.title", r_dc_title },
    { { HTML_4_0 }, { HTML_UNDEF }, "dc.type", r_dc_type },

    { { XHTML_1_0 }, { HTML_UNDEF }, "contributor", r_dc_contributor, ns_dc },
    { { XHTML_1_0 }, { HTML_UNDEF }, "coverage", r_dc_coverage, ns_dc },
    { { XHTML_1_0 }, { HTML_UNDEF }, "creator", r_dc_creator, ns_dc },
    { { XHTML_1_0 }, { HTML_UNDEF }, "date", r_dc_date, ns_dc },
    { { XHTML_1_0 }, { HTML_UNDEF }, "description", r_dc_description, ns_dc },
    { { XHTML_1_0 }, { HTML_UNDEF }, "format", r_dc_format, ns_dc },
    { { XHTML_1_0 }, { HTML_UNDEF }, "identifier", r_dc_identifier, ns_dc },
    { { XHTML_1_0 }, { HTML_UNDEF }, "language", r_dc_language, ns_dc },
    { { XHTML_1_0 }, { HTML_UNDEF }, "publisher", r_dc_publisher, ns_dc },
    { { XHTML_1_0 }, { HTML_UNDEF }, "relation", r_dc_relation, ns_dc },
    { { XHTML_1_0 }, { HTML_UNDEF }, "right", r_dc_rights, ns_dc },
    { { XHTML_1_0 }, { HTML_UNDEF }, "source", r_dc_source, ns_dc },
    { { XHTML_1_0 }, { HTML_UNDEF }, "subject", r_dc_subject, ns_dc },
    { { XHTML_1_0 }, { HTML_UNDEF }, "title", r_dc_title, ns_dc },
    { { XHTML_1_0 }, { HTML_UNDEF }, "type", r_dc_type, ns_dc },

    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_CONFORMS_TO, r_dcterms_conformsto },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_CONTRIBUTOR, r_dcterms_contributor },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_CREATOR, r_dcterms_creator },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_DESCRIPTION, r_dcterms_description },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_HAS_FORMAT, r_dcterms_hasformat },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_HAS_PART, r_dcterms_haspart },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_HAS_VERSION, r_dcterms_hasversion },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_IS_FORMAT_OF, r_dcterms_isformatof },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_IS_PART_OF, r_dcterms_ispartof },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_IS_REFERENCED_BY, r_dcterms_isreferencedby },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_IS_REPLACED_BY, r_dcterms_isreplacedby },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_IS_REQUIRED_BY, r_dcterms_isrequiredby },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_IS_VERSION_OF, r_dcterms_isversionof },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_LICENCE, r_dcterms_licence },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_MEDIATOR, r_dcterms_mediator },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_PUBLISHER, r_dcterms_publisher },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_REFERENCES, r_dcterms_references },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_RELATION, r_dcterms_relation },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_REPLACES, r_dcterms_replaces },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_REQUIRES, r_dcterms_requires },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_RIGHTS_HOLDER, r_dcterms_rightsholder },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_SOURCE, r_dcterms_source },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DCTERMS_SUBJECT, r_dcterms_subject },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DEFINITION, r_definition },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DESCRIBED_BY, r_describedby },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DESCRIBES, r_describes },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DIRECTORY, r_directory },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DISCLAIMER, r_disclaimer },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DISCLOSURE, r_disclosure },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DISCUSSION, r_discussion },
    { { HTML_4_0, HR_53_A_AREA | HR_53_LINK | HR_54_LINK }, { HTML_UNDEF }, R_DNSPREFETCH, r_dnsprefetch },
    { { HTML_4_0 }, { HTML_UNDEF }, R_DUPLICATE, r_duplicate },
    { { HTML_4_0 }, { HTML_UNDEF }, R_EDIT, r_edit },
    { { HTML_4_0 }, { HTML_UNDEF }, R_EDITOR, r_editor },
    { { HTML_4_0 }, { HTML_UNDEF }, R_EDIT_FORM, r_edit_form },
    { { HTML_4_0 }, { HTML_UNDEF }, R_EDIT_MEDIA, r_edit_media },
    { { HTML_4_0 }, { HTML_UNDEF }, R_EDIT_URI, r_edituri },
    { { HTML_4_0 }, { HTML_UNDEF }, R_ENCLOSURE, r_enclosure },
    { { HTML_4_0 }, { HTML_UNDEF }, R_END, r_end },
    { { HTML_4_0 }, { HTML_UNDEF }, R_ENDORSED, r_endorsed },
    { { HTML_4_0 }, { HTML_UNDEF }, R_ENTRY_CATEGORY, r_entry_category },
    { { HTML_4_0 }, { HTML_UNDEF }, R_ENTRY_CONTENT, r_entry_content },
    { { HTML_4_0, HR_52_A_AREA | HR_53_A_AREA | HR_54_A_AREA | HR_54_FORM }, { HTML_UNDEF }, R_EXTERNAL, r_external },
    { { HTML_4_0 }, { HTML_UNDEF }, R_FAN, r_fan },
    { { HTML_4_0 }, { HTML_UNDEF }, R_FEED, r_feed },
    { { HTML_4_0 }, { HTML_UNDEF }, R_FIRST, r_first },
    { { HTML_4_0 }, { HTML_UNDEF }, R_FOOTNOTE, r_footnote },
    { { HTML_4_0 }, { HTML_UNDEF }, R_FRIEND, r_friend },
    { { HTML_4_0 }, { HTML_UNDEF }, R_GBFS, r_gbfs },
    { { HTML_4_0 }, { HTML_UNDEF }, R_GTFS_REALTIME, r_gtfs_realtime },
    { { HTML_4_0 }, { HTML_UNDEF }, R_GTFS_STATIC, r_gtfs_static },
    { { HTML_3_0 }, { HTML_UNDEF }, R_GLOSSARY, r_glossary },
    { { HTML_4_0 }, { HTML_UNDEF }, R_GROUP, r_group },
    { { HTML_PLUS, HR_5 }, { HTML_UNDEF }, R_HELP, r_help },
    { { HTML_3_0 }, { HTML_UNDEF }, R_HOME, r_home },
    { { HTML_4_0 }, { HTML_UNDEF }, R_HOSTS, r_hosts },
    { { HTML_4_0 }, { HTML_UNDEF }, R_HUB, r_hub },
    { { HTML_4_0, HR_LINKHEAD | HR_EXTERNAL }, { HTML_UNDEF }, R_ICON, r_icon },
    { { HTML_4_0 }, { HTML_UNDEF }, R_IMAGE_SRC, r_image_src },
    { { HTML_4_0 }, { HTML_UNDEF }, R_IMPORT, r_import },
    { { HTML_3_0 }, { HTML_UNDEF }, R_INDEX, r_index },
    { { HTML_4_0 }, { HTML_UNDEF }, R_INTERVAL_AFTER, r_intervalafter },
    { { HTML_4_0 }, { HTML_UNDEF }, R_INTERVAL_BEFORE, r_intervalbefore },
    { { HTML_4_0 }, { HTML_UNDEF }, R_INTERVAL_CONTAINS, r_intervalcontains },
    { { HTML_4_0 }, { HTML_UNDEF }, R_INTERVAL_DISJOINT, r_intervaldisjoint },
    { { HTML_4_0 }, { HTML_UNDEF }, R_INTERVAL_DURING, r_intervalduring },
    { { HTML_4_0 }, { HTML_UNDEF }, R_INTERVAL_EQUALS, r_intervalequals },
    { { HTML_4_0 }, { HTML_UNDEF }, R_INTERVAL_FINISHED_BY, r_intervalfinishedby },
    { { HTML_4_0 }, { HTML_UNDEF }, R_INTERVAL_FINISHES, r_intervalfinishes },
    { { HTML_4_0 }, { HTML_UNDEF }, R_INTERVAL_IN, r_intervalin },
    { { HTML_4_0 }, { HTML_UNDEF }, R_INTERVAL_MEETS, r_intervalmeets },
    { { HTML_4_0 }, { HTML_UNDEF }, R_INTERVAL_MET_BY, r_intervalmetby },
    { { HTML_4_0 }, { HTML_UNDEF }, R_INTERVAL_OVERLAPPED_BY, r_intervaloverlappedby },
    { { HTML_4_0 }, { HTML_UNDEF }, R_INTERVAL_OVERLAPS, r_intervaloverlaps },
    { { HTML_4_0 }, { HTML_UNDEF }, R_INTERVAL_STARTED_BY, r_intervalstartedby },
    { { HTML_4_0 }, { HTML_UNDEF }, R_INTERVAL_STARTS, r_intervalstarts },
    { { HTML_4_0 }, { HTML_UNDEF }, R_IN_REPLY_TO, r_in_reply_to },
    { { HTML_4_0 }, { HTML_UNDEF }, R_ISSUES, r_issues },
    { { HTML_4_0 }, { HTML_UNDEF }, R_ITEM, r_item },
    { { HTML_4_0 }, { HTML_UNDEF }, R_ITSRULES, r_its_rules },
    { { HTML_4_0 }, { HTML_UNDEF }, R_JSLICENCE, r_jslicence },
    { { HTML_4_0 }, { HTML_UNDEF }, R_KIN, r_kin },
    { { HTML_4_0 }, { HTML_UNDEF }, R_KINETIC_STYLESHEET, r_kinetic_stylesheet },
    { { HTML_4_0 }, { HTML_UNDEF }, R_LAST, r_last },
    { { HTML_4_0 }, { HTML_UNDEF }, R_LATEST_VERSION, r_latest_version },
    { { HTML_4_0, HR_5 | HR_FORM }, { HTML_UNDEF }, R_LICENCE, r_licence },
    { { HTML_4_0 }, { HTML_UNDEF }, R_LIGHTBOX, r_lightbox },
    { { HTML_4_0 }, { HTML_UNDEF }, R_LIGHTVIDEO, r_lightvideo },
    { { HTML_4_0 }, { HTML_UNDEF }, R_LOGO, r_logo },
    { { HTML_4_0 }, { HTML_UNDEF }, R_LONGDESC, r_longdesc },
    { { HTML_4_0 }, { HTML_UNDEF }, R_LRDD, r_lrdd },
    { { HTML_1_0 }, { HTML_UNDEF }, R_MADE, r_made },
    { { HTML_4_0, HR_54_LINKHEAD | HR_54_EXTERNAL }, { HTML_UNDEF }, R_MANIFEST, r_manifest },
    { { HTML_4_0 }, { HTML_UNDEF }, R_MAP, r_map },
    { { HTML_4_0 }, { HTML_UNDEF }, R_MASKICON, r_maskicon },
    { { HTML_4_0 }, { HTML_UNDEF }, R_ME, r_me },
    { { HTML_4_0 }, { HTML_UNDEF }, R_MEMBER, r_member },
    { { HTML_4_0 }, { HTML_UNDEF }, R_MEMENTO, r_memento },
    { { HTML_4_0 }, { HTML_UNDEF }, R_MET, r_met },
    { { HTML_4_0 }, { HTML_UNDEF }, R_META, r_meta },
    { { HTML_4_0 }, { HTML_UNDEF }, R_MICROPUB, r_micropub },
    { { HTML_4_0 }, { HTML_UNDEF }, R_MICROSUMMARY, r_microsummary },
    { { HTML_JUL20, HR_54_LINK | HR_54_EXTERNAL }, { HTML_UNDEF }, "modulepreload", r_modulepreload },
    { { HTML_4_0 }, { HTML_UNDEF }, R_MONITOR, r_monitor },
    { { HTML_4_0 }, { HTML_UNDEF }, R_MONITOR_GROUP, r_monitor_group },
    { { HTML_4_0 }, { HTML_UNDEF }, R_MUSE, r_muse },
    { { HTML_4_0 }, { HTML_UNDEF }, R_M_PAGESCROLL2ID, r_m_pagescroll2id },
    { { HTML_4_0 }, { HTML_UNDEF }, R_NAVIGATE, r_navigate },
    { { HTML_4_0 }, { HTML_UNDEF }, R_NEIGHBOUR, r_neighbour },
    { { HTML_PLUS, HR_5 | HR_FORM }, { HTML_UNDEF }, R_NEXT, r_next },
    { { HTML_4_0 }, { HTML_UNDEF }, R_NEXT_ARCHIVE, r_next_archive },
    { { HTML_4_0, HR_A_AREA | HR_FORM }, { HTML_UNDEF }, R_NOFOLLOW, r_nofollow },
    { { HTML_4_0, HR_52_A_AREA | HR_53_A_AREA | HR_54_A_AREA | HR_54_FORM }, { HTML_UNDEF }, R_NOOPENER, r_noopener },
    { { HTML_4_0, HR_A_AREA | HR_FORM }, { HTML_UNDEF }, R_NOREFERRER, r_noreferrer },
    { { HTML_JUL20, HR_54_A_AREA | HR_54_FORM }, { HTML_UNDEF }, "opener", r_opener },
    { { HTML_4_0 }, { HTML_UNDEF }, R_OPENID2_LOCAL_ID, r_openid2_local_id },
    { { HTML_4_0 }, { HTML_UNDEF }, R_OPENID2_PROVIDER, r_openid2_provider },
    { { HTML_4_0 }, { HTML_UNDEF }, R_OPENID_DELEGATE, r_openid_delegate },
    { { HTML_4_0 }, { HTML_UNDEF }, R_OPENID_SERVER, r_openid_server },
    { { HTML_4_0 }, { HTML_UNDEF }, R_ORIGIN, r_origin },
    { { HTML_4_0 }, { HTML_UNDEF }, R_ORIGINAL, r_original },
    { { HTML_4_0 }, { HTML_UNDEF }, R_P3PV1, r_p3pv1 },
    { { HTML_PLUS }, { HTML_UNDEF }, R_PARENT, r_parent },
    { { HTML_4_0 }, { HTML_UNDEF }, R_PAVATAR, r_pavatar },
    { { HTML_4_0 }, { HTML_UNDEF }, R_PAYMENT, r_payment },
    { { HTML_4_0 }, { HTML_UNDEF }, R_PERMALINK, r_permalink },
    { { HTML_4_0 }, { HTML_UNDEF }, R_PGPKEY, r_pgpkey },
    { { HTML_4_0, HR_54_LINK | HR_54_EXTERNAL }, { HTML_UNDEF }, R_PINGBACK, r_pingback },
    { { HTML_4_0 }, { HTML_UNDEF }, R_POINTER, r_pointer },
    { { HTML_4_0 }, { HTML_UNDEF }, R_POPOVER, r_popover },
    { { HTML_4_0, HR_53_LINK | HR_53_EXTERNAL | HR_54_LINK | HR_54_EXTERNAL }, { HTML_UNDEF }, R_PRECONNECT, r_preconnect },
    { { HTML_4_0 }, { HTML_UNDEF }, R_PREDECESSOR_VERSION, r_predecessor_version },
    { { HTML_4_0, HR_50 | HR_50_EXTERNAL | HR_53_LINK | HR_53_EXTERNAL | HR_54_LINK | HR_54_EXTERNAL }, { HTML_UNDEF }, R_PREFETCH, r_prefetch },
    { { HTML_4_0, HR_53_LINK | HR_53_EXTERNAL | HR_54_LINK | HR_54_EXTERNAL }, { HTML_UNDEF }, R_PRELOAD, r_preload },
    { { HTML_4_0, HR_53_LINK | HR_53_EXTERNAL | HR_54_LINK | HR_54_EXTERNAL }, { HTML_UNDEF }, R_PRERENDER, r_prerender },
    { { HTML_4_0, HR_5 | HR_FORM }, { HTML_UNDEF }, R_PREV, r_prev },
    { { HTML_4_0 }, { HTML_UNDEF }, R_PREVIEW, r_preview },
    { { HTML_PLUS }, { HTML_UNDEF }, R_PREVIOUS, r_prev },
    { { HTML_4_0 }, { HTML_UNDEF }, R_PREV_ARCHIVE, r_prev_archive },
    { { HTML_4_0 }, { HTML_UNDEF }, R_PRINCIPLES, r_principles },
    { { HTML_4_0 }, { HTML_UNDEF }, R_PRIVACY, r_privacy },
    { { HTML_4_0 }, { HTML_UNDEF }, R_PRIVACY_POLICY, r_privacy_policy },
    { { HTML_4_0 }, { HTML_UNDEF }, R_PROFILE, r_profile },
    { { HTML_4_0 }, { HTML_UNDEF }, R_PRONUNCIATION, r_pronunciation },
    { { HTML_4_0 }, { HTML_UNDEF }, R_PUBLICKEY, r_publickey },
    { { HTML_4_0 }, { HTML_UNDEF }, R_PUBLISHER, r_publisher },
    { { HTML_4_0 }, { HTML_UNDEF }, R_RADIOEPG, r_radioepg },
    { { HTML_4_0 }, { HTML_UNDEF }, R_REFERRAL, r_referral },
    { { HTML_4_0 }, { HTML_UNDEF }, R_RELATED, r_related },
    { { HTML_4_0 }, { HTML_UNDEF }, R_RENDITION, r_rendition },
    { { HTML_4_0 }, { HTML_UNDEF }, R_REPLIES, r_replies },
    { { HTML_4_0 }, { HTML_UNDEF }, R_REPLY_TO, r_reply_to },
    { { HTML_4_0 }, { HTML_UNDEF }, R_RESOURCE, r_resource },
    { { HTML_4_0 }, { HTML_UNDEF }, R_RESPOND_PROXY, r_respond_proxy },
    { { HTML_4_0 }, { HTML_UNDEF }, R_RESPOND_REDIRECT, r_respond_redirect },
    { { HTML_4_0 }, { HTML_UNDEF }, R_RESTCONF, r_restconf },
    { { HTML_4_0 }, { HTML_UNDEF }, R_ROOT, r_root },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SCHEMA_DC, r_schema_dc },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SCHEMA_DCTERMS, r_schema_dcterms },
    { { HTML_1_0, HR_5 | HR_FORM }, { HTML_UNDEF }, R_SEARCH, r_search },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SECTION, r_section },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SELF, r_self },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SERVICE, r_service },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SERVICE_DESC, r_service_desc },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SERVICE_DOC, r_service_doc },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SERVICE_META, r_service_meta },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SHORTLINK, r_shortlink },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SIBLING, r_sibling },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SIDEBAR, r_sidebar },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SITEMAP, r_sitemap },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SOURCE, r_source },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SPONSOR, r_sponsor },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SPOUSE, r_spouse },
    { { HTML_4_0 }, { HTML_UNDEF }, R_START, r_start },
    { { HTML_4_0 }, { HTML_UNDEF }, R_STATUS, r_status },
    { { HTML_3_0, HR_LINK | HR_EXTERNAL }, { HTML_UNDEF }, R_STYLESHEET, r_stylesheet },
    { { HTML_4_0 }, { HTML_UNDEF }, R_STYLESHEET_LESS, r_stylesheetless },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SUBRESOURCE, r_subresource },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SUBSECTION, r_subsection },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SUCCESSOR_VERSION, r_successor_version },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SUNSET, r_sunset },
    { { HTML_4_0 }, { HTML_UNDEF }, "supercedes", r_supercedes },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SWEETHEART, r_sweetheart },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SWORD, r_sword },
    { { HTML_4_0 }, { HTML_UNDEF }, R_SYNDICATION, r_syndication },
    { { HTML_4_0, HR_A_AREA }, { HTML_UNDEF }, R_TAG, r_tag },
    { { HTML_4_0 }, { HTML_UNDEF }, R_TERMS_OF_SERVICE, r_terms_of_service },
    { { HTML_4_0 }, { HTML_UNDEF }, R_TIMEGATE, r_timegate },
    { { HTML_4_0 }, { HTML_UNDEF }, R_TIMEMAP, r_timemap },
    { { HTML_4_0 }, { HTML_UNDEF }, R_TIMESHEET, r_timesheet },
    { { HTML_3_0 }, { HTML_UNDEF }, R_TOC, r_toc },
    { { HTML_4_0 }, { HTML_UNDEF }, R_TOKEN_ENDPOINT, r_token_endpoint },
    { { HTML_4_0 }, { HTML_UNDEF }, R_TOOLTIP, r_tooltip },
    { { HTML_3_2 }, { HTML_UNDEF }, R_TOP, r_top },
    { { HTML_4_0 }, { HTML_UNDEF }, R_TRACKBACK, r_trackback },
    { { HTML_4_0 }, { HTML_UNDEF }, R_TRADEMARK, r_trademark },
    { { HTML_4_0 }, { HTML_UNDEF }, R_TRANSFORMATION, r_transformation },
    { { HTML_4_0 }, { HTML_UNDEF }, R_TRANSLATION, r_translation },
    { { HTML_4_0 }, { HTML_UNDEF }, R_TYPE, r_type },
    { { HTML_4_0 }, { HTML_UNDEF }, R_UNENDORSED, r_unendorsed },
    { { HTML_3_0 }, { HTML_UNDEF }, R_UP, r_up },
    { { HTML_4_0 }, { HTML_UNDEF }, R_URC, r_urc },
    { { HTML_4_0 }, { HTML_UNDEF }, R_USER, r_user },
    { { HTML_4_0 }, { HTML_UNDEF }, R_VCALENDAR_CHILD, r_vcalendar_child },
    { { HTML_4_0 }, { HTML_UNDEF }, R_VCALENDAR_PARENT, r_vcalendar_parent },
    { { HTML_4_0 }, { HTML_UNDEF }, R_VCALENDAR_SIBLING, r_vcalendar_sibling },
    { { HTML_4_0 }, { HTML_UNDEF }, R_VCS_GIT, r_vcs_git },
    { { HTML_4_0 }, { HTML_UNDEF }, R_VCS_SVN, r_vcs_svn },
    { { HTML_4_0 }, { HTML_UNDEF }, R_VERSION_HISTORY, r_version_history },
    { { HTML_4_0 }, { HTML_UNDEF }, R_VIA, r_via },
    { { HTML_4_0 }, { HTML_UNDEF }, R_WEBMENTION, r_webmention },
    { { HTML_4_0 }, { HTML_UNDEF }, R_WIDGET, r_widget },
    { { HTML_4_0 }, { HTML_UNDEF }, R_WLWMANIFEST, r_wlwmanifest },
    { { HTML_4_0 }, { HTML_UNDEF }, R_WORDPRESS_API, r_w_api_org },
    { { HTML_4_0 }, { HTML_UNDEF }, R_WORKING_COPY, r_working_copy },
    { { HTML_4_0 }, { HTML_UNDEF }, R_WORKING_COPY_OF, r_working_copy_of },
    { { HTML_4_0 }, { HTML_UNDEF }, R_YANDEX_TABLEAU_WIDGET, r_yandex_tableau_widget },
    { { HTML_4_0 }, { HTML_UNDEF }, "permits", r_cc_permits, ns_cc },
    { { HTML_4_0 }, { HTML_UNDEF }, "require", r_cc_requires, ns_cc },
    { { HTML_4_0 }, { HTML_UNDEF }, "prohibits", r_cc_prohibits, ns_cc },
    { { HTML_4_0 }, { HTML_UNDEF }, "jurisdiction", r_cc_jurisdiction, ns_cc },
    { { HTML_4_0 }, { HTML_UNDEF }, "legalcode", r_cc_legalcode, ns_cc },
    { { HTML_4_0 }, { HTML_UNDEF }, "deprecatedon", r_cc_deprecatedon, ns_cc },
    { { HTML_4_0 }, { HTML_UNDEF }, "license", r_cc_licence, ns_cc },
    { { HTML_4_0 }, { HTML_UNDEF }, "morepermissions", r_cc_morepermissions, ns_cc },
    { { HTML_4_0 }, { HTML_UNDEF }, "attributionname", r_cc_attributionname, ns_cc },
    { { HTML_4_0 }, { HTML_UNDEF }, "attributionurl", r_cc_attributionurl, ns_cc },
    { { HTML_4_0 }, { HTML_UNDEF }, "useguidelines", r_cc_useguidelines, ns_cc },
    { { HTML_1_0 }, { HTML_UNDEF }, "annotation", r_annotation },
    { { HTML_1_0 }, { HTML_UNDEF }, "embed", r_embed },
    { { HTML_1_0 }, { HTML_UNDEF }, "history", r_history },
    { { HTML_1_0 }, { HTML_UNDEF }, "includes", r_includes },
    { { HTML_1_0 }, { HTML_UNDEF }, "interested", r_interested },
    { { HTML_1_0 }, { HTML_UNDEF }, "present", r_present },
    { { HTML_1_0 }, { HTML_UNDEF }, "recedes", r_recedes },
    { { HTML_1_0 }, { HTML_UNDEF }, "reply", r_reply },
    { { HTML_1_0 }, { HTML_UNDEF }, "subdocument", r_subdocument },
    { { HTML_1_0 }, { HTML_UNDEF }, "supersedes", r_supersedes },
    { { HTML_1_0 }, { HTML_UNDEF }, "useglossary", r_useglossary },
    { { HTML_1_0 }, { HTML_UNDEF }, "useindex", r_useindex } };

void rel_init (nitpick& nits)
{   type_master < t_rel > :: init (nits, rel_symbol_table, sizeof (rel_symbol_table) / sizeof (symbol_entry < e_rel >)); }

void check_rel_spelling (nitpick& nits, const html_version& v, const ::std::string& original)
{   check_spelling (nits, v, original);
    nits.pick (nit_unknown_rel, ed_microformats, "http://microformats.org/wiki/existing-rel-values", es_warning, ec_type, quote (::boost::to_lower_copy (trim_the_lot_off (original))), " is an unknown rel / rev identifier"); }
